/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.Population;
import java.awt.LayoutManager;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class PopulationUI extends InputContentUI<fr.ifremer.isisfish.entities.Population> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_POPULATION_BASICS_UI_ACTIVE = "populationBasicsUI.active";
    public static final String BINDING_POPULATION_BASICS_UI_BEAN = "populationBasicsUI.bean";
    public static final String BINDING_POPULATION_BASICS_UI_SENSITIVITY = "populationBasicsUI.sensitivity";
    public static final String BINDING_POPULATION_CAPTURABILITY_UI_ACTIVE = "populationCapturabilityUI.active";
    public static final String BINDING_POPULATION_CAPTURABILITY_UI_BEAN = "populationCapturabilityUI.bean";
    public static final String BINDING_POPULATION_CAPTURABILITY_UI_SENSITIVITY = "populationCapturabilityUI.sensitivity";
    public static final String BINDING_POPULATION_EQUATION_UI_ACTIVE = "populationEquationUI.active";
    public static final String BINDING_POPULATION_EQUATION_UI_BEAN = "populationEquationUI.bean";
    public static final String BINDING_POPULATION_EQUATION_UI_SENSITIVITY = "populationEquationUI.sensitivity";
    public static final String BINDING_POPULATION_GROUP_UI_ACTIVE = "populationGroupUI.active";
    public static final String BINDING_POPULATION_GROUP_UI_BEAN = "populationGroupUI.bean";
    public static final String BINDING_POPULATION_GROUP_UI_SENSITIVITY = "populationGroupUI.sensitivity";
    public static final String BINDING_POPULATION_MIGRATION_UI_ACTIVE = "populationMigrationUI.active";
    public static final String BINDING_POPULATION_MIGRATION_UI_BEAN = "populationMigrationUI.bean";
    public static final String BINDING_POPULATION_MIGRATION_UI_SENSITIVITY = "populationMigrationUI.sensitivity";
    public static final String BINDING_POPULATION_PRICE_UI_ACTIVE = "populationPriceUI.active";
    public static final String BINDING_POPULATION_PRICE_UI_BEAN = "populationPriceUI.bean";
    public static final String BINDING_POPULATION_PRICE_UI_SENSITIVITY = "populationPriceUI.sensitivity";
    public static final String BINDING_POPULATION_RECRUITEMENT_UI_ACTIVE = "populationRecruitementUI.active";
    public static final String BINDING_POPULATION_RECRUITEMENT_UI_BEAN = "populationRecruitementUI.bean";
    public static final String BINDING_POPULATION_RECRUITEMENT_UI_SENSITIVITY = "populationRecruitementUI.sensitivity";
    public static final String BINDING_POPULATION_SEASONS_UI_ACTIVE = "populationSeasonsUI.active";
    public static final String BINDING_POPULATION_SEASONS_UI_BEAN = "populationSeasonsUI.bean";
    public static final String BINDING_POPULATION_SEASONS_UI_SENSITIVITY = "populationSeasonsUI.sensitivity";
    public static final String BINDING_POPULATION_ZONE_UI_ACTIVE = "populationZoneUI.active";
    public static final String BINDING_POPULATION_ZONE_UI_BEAN = "populationZoneUI.bean";
    public static final String BINDING_POPULATION_ZONE_UI_SENSITIVITY = "populationZoneUI.sensitivity";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWVTW/TQBCGp4EWSoGWFgqFIsqXACE5tHxKRXwVCkEpVC1FiFzYxNt2K9dedtfFvSB+Aj8B7lyQuHFCHDhz4IL4Cwhx4IqYdRw7po5Z5BziaGffZ+edrGfefIduKeDwCgkCS/iuYqvUunv90aP79RXaUDepbAjGlSeg+ekqQakGfXa8LhUcrVW1vBzJy1PeKvdc6rapJ6uwTap1h8plSpWCg2lFQ8ryfByeDLgvWtQ4qSzqq58/Si/tF69LAAHH7IbRyti/VImTzVUoMVvBIJ60RsoOcZcwDcHcJcx3h16bcoiU98gqfQrPYUsVejgRCFNwxNxyyAj1AVcwcKzicl9Nea7C7QuVMwpOLQqLLQq6SvEpmVxkctnymcX0RmvW475DFPPchQrnIahHweY6Ja6CE1lS5DLFqGyTtgs9ex0ta3eBJZ+hWevuLHGpk+zZwWPhA1JXsDe1GZfq1NYSvb0/Vg0mqhtEsoZcqCgoG3prKTRrMEYOJMjHWF4NtAyBev8G3lDCm6dEem6Y4xlDZCxJQ3cn0FtP/eifUjBuSE00aey+BDtHG8JnClH6xig4Z4iOdE1Zmr4rod8Wns//p7SRIA0cSYBThCtfkDpzmFrX4AuG4L+E6QP2JAfMsCUR13nCEN4m6liKWcEa/3XLIkEa2HsMX5GKu+jhu70/1Y2ab1AU5RsF43phIiMw0SlwtlPgXKfA+U6BC50CFzsFLrUCAg6kfGI/t5J+njTcrhp0Cx+X8XrXNo6AOQw1m/++v5q/BobR38NDX95/ezfd6vgH8Ow9mVvbBhZ2Yi48ToXuigr6m+3eV8wpzxA+WYNeSR2cduE0G81IbD4KY3J43i4tt7TcukPkMiK6t3z98HH4yedNUJqGbY5H7Gmi91egVy0LrILn2AG/ei3MaPuzrfg9oHNT0IP72BrWaOdlmygyVmeujXfkSoBFGM0oQpxJvffTr6H5t9dahejCxEY6bk+K0f0YepjrMJeGwy+aa5nDro9L6tteMr+yJlqXfg7z6HbcCb+rWU7DiaWj9wNfP2bDpPWvOWNGn6SuxNm2hv2hEEov38shjBgRHhYm1AoT8lyMFnZhRshzYUbIc3GosAszQp4LM0KeiyOFXZgR8lyYEfJcHC/swoyQ58KMkOfiZGEXZoQ8F2aEPBenC7swI+S5MCPkubAKuzAj5LnQhD+WvXqOCQ8AAA==";
    private static final Log log = LogFactory.getLog(PopulationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Population bean;
    protected PopulationBasicsUI populationBasicsUI;
    protected PopulationCapturabilityUI populationCapturabilityUI;
    protected PopulationEquationUI populationEquationUI;
    protected PopulationGroupUI populationGroupUI;
    protected PopulationMigrationUI populationMigrationUI;
    protected PopulationPriceUI populationPriceUI;
    protected PopulationRecruitmentUI populationRecruitementUI;
    protected PopulationSeasonsUI populationSeasonsUI;
    protected JTabbedPane populationTab;
    protected PopulationZonesUI populationZoneUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationUI $InputContentUI0 = this;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;
    private TabInfo $TabInfo3;
    private TabInfo $TabInfo4;
    private TabInfo $TabInfo5;
    private TabInfo $TabInfo6;
    private TabInfo $TabInfo7;
    private TabInfo $TabInfo8;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        setButtonTitle(_("isisfish.input.continueGears"));
        setNextPath(n_("isisfish.input.tree.gears"));
        
        // install change listener
        // (depends on sensitivity can't be done on constructor)
        installChangeListener(populationTab);
    }
    
    /*public void refresh() {
        // reverse ordre is no more needed
        getSaveVerifier().addCurrentPanel(populationMigrationUI, populationRecruitementUI, populationCapturabilityUI,
            populationSeasonsUI, populationZoneUI, populationEquationUI, populationGroupUI, populationBasicsUI);
    }*/
    
    @Override
    public void setLayer(boolean active) {
        super.setLayer(active);
        populationBasicsUI.setLayer(active);
        populationZoneUI.setLayer(active);
        populationSeasonsUI.setLayer(active);
        populationEquationUI.setLayer(active);
        populationRecruitementUI.setLayer(active);
        populationGroupUI.setLayer(active);
        populationCapturabilityUI.setLayer(active);
        populationMigrationUI.setLayer(active);
        populationPriceUI.setLayer(active);
    }
    
    @Override
    public void resetChangeModel() {
        populationBasicsUI.resetChangeModel();
        populationZoneUI.resetChangeModel();
        populationSeasonsUI.resetChangeModel();
        populationEquationUI.resetChangeModel();
        populationRecruitementUI.resetChangeModel();
        populationGroupUI.resetChangeModel();
        populationCapturabilityUI.resetChangeModel();
        populationMigrationUI.resetChangeModel();
        populationPriceUI.resetChangeModel();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PopulationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationUI() {
        $initialize();
    }

    public PopulationUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Population getBean() {
        return bean;
    }

    public PopulationBasicsUI getPopulationBasicsUI() {
        return populationBasicsUI;
    }

    public PopulationCapturabilityUI getPopulationCapturabilityUI() {
        return populationCapturabilityUI;
    }

    public PopulationEquationUI getPopulationEquationUI() {
        return populationEquationUI;
    }

    public PopulationGroupUI getPopulationGroupUI() {
        return populationGroupUI;
    }

    public PopulationMigrationUI getPopulationMigrationUI() {
        return populationMigrationUI;
    }

    public PopulationPriceUI getPopulationPriceUI() {
        return populationPriceUI;
    }

    public PopulationRecruitmentUI getPopulationRecruitementUI() {
        return populationRecruitementUI;
    }

    public PopulationSeasonsUI getPopulationSeasonsUI() {
        return populationSeasonsUI;
    }

    public JTabbedPane getPopulationTab() {
        return populationTab;
    }

    public PopulationZonesUI getPopulationZoneUI() {
        return populationZoneUI;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected TabInfo get$TabInfo4() {
        return $TabInfo4;
    }

    protected TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    protected TabInfo get$TabInfo6() {
        return $TabInfo6;
    }

    protected TabInfo get$TabInfo7() {
        return $TabInfo7;
    }

    protected TabInfo get$TabInfo8() {
        return $TabInfo8;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(populationTab);
    }

    protected void addChildrenToPopulationTab() {
        if (!allComponentsCreated) {
            return;
        }
        populationTab.add(populationBasicsUI);
        populationTab.add(populationZoneUI);
        populationTab.add(populationSeasonsUI);
        populationTab.add(populationEquationUI);
        populationTab.add(populationRecruitementUI);
        populationTab.add(populationGroupUI);
        populationTab.add(populationCapturabilityUI);
        populationTab.add(populationMigrationUI);
        populationTab.add(populationPriceUI);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(populationTab, 0));
        populationTab.setTitleAt(0, _("isisfish.populationBasics.title"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(populationTab, 1));
        populationTab.setTitleAt(1, _("isisfish.populationZones.title"));
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener(populationTab, 2));
        populationTab.setTitleAt(2, _("isisfish.populationSeasons.title"));
        $TabInfo3.addPropertyChangeListener(new TabInfoPropertyChangeListener(populationTab, 3));
        populationTab.setTitleAt(3, _("isisfish.populationEquation.title"));
        $TabInfo4.addPropertyChangeListener(new TabInfoPropertyChangeListener(populationTab, 4));
        populationTab.setTitleAt(4, _("isisfish.populationRecruitment.title"));
        $TabInfo5.addPropertyChangeListener(new TabInfoPropertyChangeListener(populationTab, 5));
        populationTab.setTitleAt(5, _("isisfish.populationGroup.title"));
        $TabInfo6.addPropertyChangeListener(new TabInfoPropertyChangeListener(populationTab, 6));
        populationTab.setTitleAt(6, _("isisfish.populationCapturability.title"));
        $TabInfo7.addPropertyChangeListener(new TabInfoPropertyChangeListener(populationTab, 7));
        populationTab.setTitleAt(7, _("isisfish.populationMigration.title"));
        $TabInfo8.addPropertyChangeListener(new TabInfoPropertyChangeListener(populationTab, 8));
        populationTab.setTitleAt(8, _("isisfish.populationPrice.title"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createPopulationBasicsUI() {
        $objectMap.put("populationBasicsUI", populationBasicsUI = new PopulationBasicsUI(this));
        
        populationBasicsUI.setName("populationBasicsUI");
    }

    protected void createPopulationCapturabilityUI() {
        $objectMap.put("populationCapturabilityUI", populationCapturabilityUI = new PopulationCapturabilityUI(this));
        
        populationCapturabilityUI.setName("populationCapturabilityUI");
    }

    protected void createPopulationEquationUI() {
        $objectMap.put("populationEquationUI", populationEquationUI = new PopulationEquationUI(this));
        
        populationEquationUI.setName("populationEquationUI");
    }

    protected void createPopulationGroupUI() {
        $objectMap.put("populationGroupUI", populationGroupUI = new PopulationGroupUI(this));
        
        populationGroupUI.setName("populationGroupUI");
    }

    protected void createPopulationMigrationUI() {
        $objectMap.put("populationMigrationUI", populationMigrationUI = new PopulationMigrationUI(this));
        
        populationMigrationUI.setName("populationMigrationUI");
    }

    protected void createPopulationPriceUI() {
        $objectMap.put("populationPriceUI", populationPriceUI = new PopulationPriceUI(this));
        
        populationPriceUI.setName("populationPriceUI");
    }

    protected void createPopulationRecruitementUI() {
        $objectMap.put("populationRecruitementUI", populationRecruitementUI = new PopulationRecruitmentUI(this));
        
        populationRecruitementUI.setName("populationRecruitementUI");
    }

    protected void createPopulationSeasonsUI() {
        $objectMap.put("populationSeasonsUI", populationSeasonsUI = new PopulationSeasonsUI(this));
        
        populationSeasonsUI.setName("populationSeasonsUI");
    }

    protected void createPopulationTab() {
        $objectMap.put("populationTab", populationTab = new JTabbedPane());
        
        populationTab.setName("populationTab");
    }

    protected void createPopulationZoneUI() {
        $objectMap.put("populationZoneUI", populationZoneUI = new PopulationZonesUI(this));
        
        populationZoneUI.setName("populationZoneUI");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToPopulationTab();
        
        // apply 27 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createPopulationTab();
        createPopulationBasicsUI();
        createPopulationZoneUI();
        createPopulationSeasonsUI();
        createPopulationEquationUI();
        createPopulationRecruitementUI();
        createPopulationGroupUI();
        createPopulationCapturabilityUI();
        createPopulationMigrationUI();
        createPopulationPriceUI();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(_("isisfish.populationBasics.title"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(_("isisfish.populationZones.title"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setTitle(_("isisfish.populationSeasons.title"));
        // inline creation of $TabInfo3
        $objectMap.put("$TabInfo3", $TabInfo3 = new TabInfo());
        
        $TabInfo3.setTitle(_("isisfish.populationEquation.title"));
        // inline creation of $TabInfo4
        $objectMap.put("$TabInfo4", $TabInfo4 = new TabInfo());
        
        $TabInfo4.setTitle(_("isisfish.populationRecruitment.title"));
        // inline creation of $TabInfo5
        $objectMap.put("$TabInfo5", $TabInfo5 = new TabInfo());
        
        $TabInfo5.setTitle(_("isisfish.populationGroup.title"));
        // inline creation of $TabInfo6
        $objectMap.put("$TabInfo6", $TabInfo6 = new TabInfo());
        
        $TabInfo6.setTitle(_("isisfish.populationCapturability.title"));
        // inline creation of $TabInfo7
        $objectMap.put("$TabInfo7", $TabInfo7 = new TabInfo());
        
        $TabInfo7.setTitle(_("isisfish.populationMigration.title"));
        // inline creation of $TabInfo8
        $objectMap.put("$TabInfo8", $TabInfo8 = new TabInfo());
        
        $TabInfo8.setTitle(_("isisfish.populationPrice.title"));
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 27 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 27 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_BASICS_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                populationBasicsUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_BASICS_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                populationBasicsUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_BASICS_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                populationBasicsUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_ZONE_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                populationZoneUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_ZONE_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                populationZoneUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_ZONE_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                populationZoneUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_SEASONS_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                populationSeasonsUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_SEASONS_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                populationSeasonsUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_SEASONS_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                populationSeasonsUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_EQUATION_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                populationEquationUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_EQUATION_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                populationEquationUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_EQUATION_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                populationEquationUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_RECRUITEMENT_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                populationRecruitementUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_RECRUITEMENT_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                populationRecruitementUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_RECRUITEMENT_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                populationRecruitementUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_GROUP_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                populationGroupUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_GROUP_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                populationGroupUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_GROUP_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                populationGroupUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_CAPTURABILITY_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                populationCapturabilityUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_CAPTURABILITY_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                populationCapturabilityUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_CAPTURABILITY_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                populationCapturabilityUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                populationMigrationUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                populationMigrationUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                populationMigrationUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_PRICE_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                populationPriceUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_PRICE_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                populationPriceUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_PRICE_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                populationPriceUI.setSensitivity(isSensitivity());
            }
        });
    }

}