/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.Gear;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class GearTabUI extends InputContentUI<Gear> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_FIELD_GEAR_COMMENT_ENABLED = "fieldGearComment.enabled";
    public static final String BINDING_FIELD_GEAR_COMMENT_TEXT = "fieldGearComment.text";
    public static final String BINDING_FIELD_GEAR_EFFORT_UNIT_ENABLED = "fieldGearEffortUnit.enabled";
    public static final String BINDING_FIELD_GEAR_EFFORT_UNIT_TEXT = "fieldGearEffortUnit.text";
    public static final String BINDING_FIELD_GEAR_NAME_ENABLED = "fieldGearName.enabled";
    public static final String BINDING_FIELD_GEAR_NAME_TEXT = "fieldGearName.text";
    public static final String BINDING_FIELD_GEAR_PARAM_NAME_ENABLED = "fieldGearParamName.enabled";
    public static final String BINDING_FIELD_GEAR_PARAM_NAME_TEXT = "fieldGearParamName.text";
    public static final String BINDING_FIELD_GEAR_STANDARDISATION_FACTOR_ENABLED = "fieldGearStandardisationFactor.enabled";
    public static final String BINDING_FIELD_GEAR_STANDARDISATION_FACTOR_TEXT = "fieldGearStandardisationFactor.text";
    public static final String BINDING_RANGE_OF_VALUES_ACTIVE = "rangeOfValues.active";
    public static final String BINDING_RANGE_OF_VALUES_BEAN = "rangeOfValues.bean";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";
    private static final String BINDING_$JLABEL4_ENABLED = "$JLabel4.enabled";
    private static final String BINDING_$JLABEL5_ENABLED = "$JLabel5.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWTU8TQRgeKt+KIgSoARUENUbdImqMAT8QRUuKIAUl9uK0O5Uh29l1ZhbWi/En+BP07sXEmyfjwbMHL8a/YIwHr8Z3tu2WLcOyyfYwpfO+7/M+78c+y/tfqE1wNLaJPc/gLpO0QoyF2fX1peImKcm7RJQ4daTNUfXTkkKpAjpoBvdCovFCToVnauGZObvi2IywHdHTOdQt5EuLiA1CpETHwxElITL5wDztOS6vowakdKhv//xOvTFfv0sh5DnALg2ljO4X1aikNYdS1JSoDzJt4YyF2XOgwSl7Dnx71N2chYV4iCvkBXqFOnKo3cEcwCQ6Fb9kH8OP9xyJeieyzHHlnM0kuK9lJyU6U+YGLXNSIfAtqChTsWG41KDK0bhPMF/FxbWs4/go7RK1FglmEo3p4gCUSkqEH9cI6drCFjUx8JLofKhDgcEQ21C5kVfn4/rlzqS2+RJ6pdri1XwXljEjVsOnYwKYWgRqSodyVL19m/Lsaw64pH4OqWMgMHVOLORwkViTzTn9W+WUDnx7ypRYpqpYzUqiwVDAKvHkvHIIB9UT+MlHwrb+APBeuQw9W2NUKtNJPcSUBuJEAJGXmJmYm1RgSW02j0vQ2Ai0yxq0vgBtGXNcqa/kHghXNAg9HNabLJVhtC6Bp/ZC5Nat7HRey+rTXNWlmVjIl7htWWo1YHZDoVE0TOGo3qA8eJIq/hM2sGuGs5xg5X+5eX2mNOvTKvAWbEJ/COWOK6XNlMf1wLG9hFmpulA3mi2QUBKdxSQWCVs4Gg6tPEia0ZC0hua0FFAbdy01gXRhtwqugKmqf+km/VOAvvXfYP/3Tz8/ztdFbxRyD2hdd2g2iJHDbYdwpQ0SHakqniuplVnEznQBdQkoqVQV9BENsXzNDOQg31EVbqhw4wEWGwDR1vHj85fBZ98OoNQ86rZsbFb3PIu65AaHLtiW6Tm3bvuMDm13wtmruMEQCVNDBB0+PAOag0eLlJkwrpsedGFE04WASrHr69/+/Ifb9U60ALNje7o3utH2FLVTZlFG/BdATdu1gn/QEcQ17YaG61S9RX0POzUdzPrnoq7UVglrDA/zTDX7KJbwtim6kkCtKuiRX4T6Kx8TU10vqWNZj3AiFsKTxAhRHMbic1hPghDFYTxxH+IhRHE4nbgP8RCiOJxN3Id4CFEcziXuQzyEKA7nE/chHkIUh4uJ+7A/AryrQIbpFongkYmjXOpfzkQY+3VjKnE34iFEcbiWeCviIURxmEnch3gIURxuJeYQDyGKw2xiDvEQojjMJeagEP4Df1u1zmQPAAA=";
    private static final Log log = LogFactory.getLog(GearTabUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Gear bean;
    protected JButton cancel;
    protected JButton create;
    protected JButton delete;
    protected JTextArea fieldGearComment;
    @ValidatorField( validatorId = "validator",  propertyName = "effortUnit",  editorName = "fieldGearEffortUnit")
    protected JTextField fieldGearEffortUnit;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "fieldGearName")
    protected JTextField fieldGearName;
    protected JTextField fieldGearParamName;
    protected JTextField fieldGearStandardisationFactor;
    protected RangeOfValuesUI rangeOfValues;
    protected JButton save;
    @Validator( validatorId = "validator")
    protected SwingValidator<Gear> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private GearTabUI $InputContentUI0 = this;
    private Table $Table0;
    private Table $Table1;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JScrollPane $JScrollPane0;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    fieldGearName.setText("");
                    fieldGearEffortUnit.setText("");
                    fieldGearStandardisationFactor.setText("");
                    fieldGearParamName.setText("");
                    fieldGearComment.setText("");
                }
                if (evt.getNewValue() != null) {
        
                }
            }
        });
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public GearTabUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public GearTabUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public GearTabUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public GearTabUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public GearTabUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public GearTabUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public GearTabUI() {
        $initialize();
    }

    public GearTabUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__create(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().create(Gear.class);
    }

    public void doActionPerformed__on__delete(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().delete();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);
    }

    public void doKeyReleased__on__fieldGearComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setComment(fieldGearComment.getText());
    }

    public void doKeyReleased__on__fieldGearEffortUnit(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setEffortUnit(fieldGearEffortUnit.getText());
    }

    public void doKeyReleased__on__fieldGearName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setName(fieldGearName.getText());
    }

    public void doKeyReleased__on__fieldGearParamName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setParameterName(fieldGearParamName.getText());
    }

    public void doKeyReleased__on__fieldGearStandardisationFactor(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setStandardisationFactor(Double.parseDouble(fieldGearStandardisationFactor.getText()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Gear getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JButton getCreate() {
        return create;
    }

    public JButton getDelete() {
        return delete;
    }

    public JTextArea getFieldGearComment() {
        return fieldGearComment;
    }

    public JTextField getFieldGearEffortUnit() {
        return fieldGearEffortUnit;
    }

    public JTextField getFieldGearName() {
        return fieldGearName;
    }

    public JTextField getFieldGearParamName() {
        return fieldGearParamName;
    }

    public JTextField getFieldGearStandardisationFactor() {
        return fieldGearStandardisationFactor;
    }

    public RangeOfValuesUI getRangeOfValues() {
        return rangeOfValues;
    }

    public JButton getSave() {
        return save;
    }

    public SwingValidator<Gear> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Gear bean) {
        Gear oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(_("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCreate() {
        $objectMap.put("create", create = new JButton());
        
        create.setName("create");
        create.setText(_("isisfish.common.new"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new JButton());
        
        delete.setName("delete");
        delete.setText(_("isisfish.common.remove"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createFieldGearComment() {
        $objectMap.put("fieldGearComment", fieldGearComment = new JTextArea());
        
        fieldGearComment.setName("fieldGearComment");
        fieldGearComment.setColumns(15);
        fieldGearComment.setLineWrap(true);
        fieldGearComment.setWrapStyleWord(true);
        fieldGearComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldGearComment"));
    }

    protected void createFieldGearEffortUnit() {
        $objectMap.put("fieldGearEffortUnit", fieldGearEffortUnit = new JTextField());
        
        fieldGearEffortUnit.setName("fieldGearEffortUnit");
        fieldGearEffortUnit.setColumns(15);
        fieldGearEffortUnit.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldGearEffortUnit"));
    }

    protected void createFieldGearName() {
        $objectMap.put("fieldGearName", fieldGearName = new JTextField());
        
        fieldGearName.setName("fieldGearName");
        fieldGearName.setColumns(15);
        fieldGearName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldGearName"));
    }

    protected void createFieldGearParamName() {
        $objectMap.put("fieldGearParamName", fieldGearParamName = new JTextField());
        
        fieldGearParamName.setName("fieldGearParamName");
        fieldGearParamName.setColumns(15);
        fieldGearParamName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldGearParamName"));
    }

    protected void createFieldGearStandardisationFactor() {
        $objectMap.put("fieldGearStandardisationFactor", fieldGearStandardisationFactor = new JTextField());
        
        fieldGearStandardisationFactor.setName("fieldGearStandardisationFactor");
        fieldGearStandardisationFactor.setColumns(15);
        fieldGearStandardisationFactor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldGearStandardisationFactor"));
        fieldGearStandardisationFactor.putClientProperty("sensitivityBean", Gear.class);
        fieldGearStandardisationFactor.putClientProperty("sensitivityMethod", "StandardisationFactor");
    }

    protected void createRangeOfValues() {
        $objectMap.put("rangeOfValues", rangeOfValues = new RangeOfValuesUI(this));
        
        rangeOfValues.setName("rangeOfValues");
        rangeOfValues.putClientProperty("sensitivityBean", Gear.class);
        rangeOfValues.putClientProperty("sensitivityMethod", "PossibleValue");
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(_("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidatorUtil.newValidator(Gear.class, "gear"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(SwingUtil.boxComponentWithJxLayer(fieldGearName)), new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(SwingUtil.boxComponentWithJxLayer(fieldGearEffortUnit)), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldGearStandardisationFactor), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldGearParamName), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(rangeOfValues), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel5, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(1, 5, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldGearComment));
        // inline complete setup of $Table2
        $Table2.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(delete), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 23 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createValidator();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("isisfish.gear.name"));
        createFieldGearName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("isisfish.gear.effortUnit"));
        createFieldGearEffortUnit();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.gear.standardisationFactor"));
        createFieldGearStandardisationFactor();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.gear.technicalParameter"));
        createFieldGearParamName();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("isisfish.gear.rangeValues"));
        createRangeOfValues();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("isisfish.gear.comments"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldGearComment();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createSave();
        createCancel();
        createCreate();
        createDelete();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        /*public void refresh() {
            Gear gear = getSaveVerifier().getEntity(Gear.class);
            
            // add null before, for second to be considered as a changed event
            // otherwize, setBean has no effect
            setBean(null);
            setBean(gear);
            
            getVerifier().addCurrentPanel(rangeOfValues);
            
            // chatellier commented since number editor is not working
            //if (getBean() != null) {
            //    fieldGearStandardisationFactor.init();
            //}
        }*/;// registers 23 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 23 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_GEAR_NAME_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldGearName.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_GEAR_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldGearName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_GEAR_EFFORT_UNIT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldGearEffortUnit.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_GEAR_EFFORT_UNIT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldGearEffortUnit, jaxx.runtime.SwingUtil.getStringValue(getBean().getEffortUnit()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_GEAR_STANDARDISATION_FACTOR_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldGearStandardisationFactor.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_GEAR_STANDARDISATION_FACTOR_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldGearStandardisationFactor, String.valueOf(getBean().getStandardisationFactor()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_GEAR_PARAM_NAME_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldGearParamName.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_GEAR_PARAM_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldGearParamName, jaxx.runtime.SwingUtil.getStringValue(getBean().getParameterName()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL4_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel4.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RANGE_OF_VALUES_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                rangeOfValues.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RANGE_OF_VALUES_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                rangeOfValues.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL5_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel5.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_GEAR_COMMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldGearComment.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_GEAR_COMMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldGearComment, jaxx.runtime.SwingUtil.getStringValue(getBean().getComment()));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    create.setEnabled(!validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DELETE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
                addPropertyChangeListener("bean", this);
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    delete.setEnabled(!validator.isChanged() && getBean() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
                removePropertyChangeListener("bean", this);
            }
        });
    }

}