/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class MetierAbstract extends TopiaEntityAbstract implements Metier {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : gearParameterValue
     */
    protected String gearParameterValue;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : capturableSpeciesComment
     */
    protected String capturableSpeciesComment;

    /**
     * Nom de l'attribut en BD : gear
     */
    protected Gear gear;

    /**
     * Nom de l'attribut en BD : setOfVessels
     */
    protected Collection<EffortDescription> setOfVesselsEffortDescription;

    /**
     * Nom de l'attribut en BD : metierSeasonInfo
     */
    protected List<MetierSeasonInfo> metierSeasonInfo;

    private static final long serialVersionUID = 7365416395778570295L;

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Metier.class).update(this);
}

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Metier.class).delete(this);
}

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_GEAR_PARAMETER_VALUE, String.class, gearParameterValue);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_CAPTURABLE_SPECIES_COMMENT, String.class, capturableSpeciesComment);
        visitor.visit(this, PROPERTY_GEAR, Gear.class, gear);
        visitor.visit(this, PROPERTY_SET_OF_VESSELS_EFFORT_DESCRIPTION, Collection.class, EffortDescription.class, setOfVesselsEffortDescription);
        visitor.visit(this, PROPERTY_METIER_SEASON_INFO, List.class, MetierSeasonInfo.class, metierSeasonInfo);
        visitor.end(this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
    }

    @Override
    public void setGearParameterValue(String gearParameterValue) {
        String oldValue = this.gearParameterValue;
        fireOnPreWrite(PROPERTY_GEAR_PARAMETER_VALUE, oldValue, gearParameterValue);
        this.gearParameterValue = gearParameterValue;
        fireOnPostWrite(PROPERTY_GEAR_PARAMETER_VALUE, oldValue, gearParameterValue);
    }

    @Override
    public String getGearParameterValue() {
        fireOnPreRead(PROPERTY_GEAR_PARAMETER_VALUE, gearParameterValue);
        String result = this.gearParameterValue;
        fireOnPostRead(PROPERTY_GEAR_PARAMETER_VALUE, gearParameterValue);
        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        fireOnPreWrite(PROPERTY_COMMENT, oldValue, comment);
        this.comment = comment;
        fireOnPostWrite(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public String getComment() {
        fireOnPreRead(PROPERTY_COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(PROPERTY_COMMENT, comment);
        return result;
    }

    @Override
    public void setCapturableSpeciesComment(String capturableSpeciesComment) {
        String oldValue = this.capturableSpeciesComment;
        fireOnPreWrite(PROPERTY_CAPTURABLE_SPECIES_COMMENT, oldValue, capturableSpeciesComment);
        this.capturableSpeciesComment = capturableSpeciesComment;
        fireOnPostWrite(PROPERTY_CAPTURABLE_SPECIES_COMMENT, oldValue, capturableSpeciesComment);
    }

    @Override
    public String getCapturableSpeciesComment() {
        fireOnPreRead(PROPERTY_CAPTURABLE_SPECIES_COMMENT, capturableSpeciesComment);
        String result = this.capturableSpeciesComment;
        fireOnPostRead(PROPERTY_CAPTURABLE_SPECIES_COMMENT, capturableSpeciesComment);
        return result;
    }

    @Override
    public void setGear(Gear gear) {
        Gear oldValue = this.gear;
        fireOnPreWrite(PROPERTY_GEAR, oldValue, gear);
        this.gear = gear;
        fireOnPostWrite(PROPERTY_GEAR, oldValue, gear);
    }

    @Override
    public Gear getGear() {
        fireOnPreRead(PROPERTY_GEAR, gear);
        Gear result = this.gear;
        fireOnPostRead(PROPERTY_GEAR, gear);
        return result;
    }

    @Override
    public void addMetierSeasonInfo(MetierSeasonInfo metierSeasonInfo) {
        fireOnPreWrite(PROPERTY_METIER_SEASON_INFO, null, metierSeasonInfo);
        if (this.metierSeasonInfo == null) {
            this.metierSeasonInfo = new ArrayList<MetierSeasonInfo>();
        }

        metierSeasonInfo.setMetier(this);

        this.metierSeasonInfo.add(metierSeasonInfo);
        fireOnPostWrite(PROPERTY_METIER_SEASON_INFO, this.metierSeasonInfo.size(), null, metierSeasonInfo);
    }

    @Override
    public void addAllMetierSeasonInfo(List<MetierSeasonInfo> metierSeasonInfo) {
        if (metierSeasonInfo == null) {
            return;
        }
        for (MetierSeasonInfo item : metierSeasonInfo) {
            addMetierSeasonInfo(item);
        }
    }

    @Override
    public void setMetierSeasonInfo(List<MetierSeasonInfo> metierSeasonInfo) {
        // Copy elements to keep data for fire with new reference
        List<MetierSeasonInfo> oldValue = this.metierSeasonInfo != null ? new ArrayList<MetierSeasonInfo>(this.metierSeasonInfo) : null;
        fireOnPreWrite(PROPERTY_METIER_SEASON_INFO, oldValue, metierSeasonInfo);
        this.metierSeasonInfo = metierSeasonInfo;
        fireOnPostWrite(PROPERTY_METIER_SEASON_INFO, oldValue, metierSeasonInfo);
    }

    @Override
    public void removeMetierSeasonInfo(MetierSeasonInfo metierSeasonInfo) {
        fireOnPreWrite(PROPERTY_METIER_SEASON_INFO, metierSeasonInfo, null);
        if (this.metierSeasonInfo == null || !this.metierSeasonInfo.remove(metierSeasonInfo)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        metierSeasonInfo.setMetier(null);

        fireOnPostWrite(PROPERTY_METIER_SEASON_INFO, this.metierSeasonInfo.size() + 1, metierSeasonInfo, null);
    }

    @Override
    public void clearMetierSeasonInfo() {
        if (this.metierSeasonInfo == null) {
            return;
        }
        for (MetierSeasonInfo item : this.metierSeasonInfo) {
            item.setMetier(null);
        }
        List<MetierSeasonInfo> oldValue = new ArrayList<MetierSeasonInfo>(this.metierSeasonInfo);
        fireOnPreWrite(PROPERTY_METIER_SEASON_INFO, oldValue, this.metierSeasonInfo);
        this.metierSeasonInfo.clear();
        fireOnPostWrite(PROPERTY_METIER_SEASON_INFO, oldValue, this.metierSeasonInfo);
    }

    @Override
    public List<MetierSeasonInfo> getMetierSeasonInfo() {
        return metierSeasonInfo;
    }

    @Override
    public MetierSeasonInfo getMetierSeasonInfoByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(metierSeasonInfo, topiaId);
    }

    @Override
    public int sizeMetierSeasonInfo() {
        if (metierSeasonInfo == null) {
            return 0;
        }
        return metierSeasonInfo.size();
    }

    @Override
    public boolean isMetierSeasonInfoEmpty() {
        int size = sizeMetierSeasonInfo();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        {
            org.nuiton.topia.persistence.TopiaDAO<EffortDescription> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(EffortDescription.class);
            List<EffortDescription> findAllByProperties = dao.findAllByProperties("possibleMetiers", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }
        if (getMetierSeasonInfo() != null) {
              tmp.addAll(getMetierSeasonInfo());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NAME, this.name).
            append(PROPERTY_GEAR_PARAMETER_VALUE, this.gearParameterValue).
            append(PROPERTY_COMMENT, this.comment).
            append(PROPERTY_CAPTURABLE_SPECIES_COMMENT, this.capturableSpeciesComment).
            append(PROPERTY_GEAR, this.gear).
         toString();
        return result;
    }

} //MetierAbstract
