/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Formule;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.ui.input.InputOneEquationUI;
import fr.ifremer.isisfish.ui.sensitivity.equation.EquationDomainListModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import static org.nuiton.i18n.I18n._;

public class EquationContinuousPanelUI extends ContinuousPanelContainerUI {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_BEAN_PROPERTY = "beanProperty";
    public static final String PROPERTY_CLAZZ = "clazz";
    public static final String PROPERTY_FORMULE = "formule";
    public static final String PROPERTY_FORMULE_CATEGORY = "formuleCategory";
    public static final String PROPERTY_PERCENTAGE_TYPE_DOMAIN = "percentageTypeDomain";
    public static final String PROPERTY_SELECTED_DOMAIN = "selectedDomain";
    public static final String PROPERTY_SELECTED_EQUATION = "selectedEquation";
    public static final String PROPERTY_TEXT = "text";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_VISIBLE = "add.visible";
    public static final String BINDING_COEFFICIENT_FIELD_ENABLED = "coefficientField.enabled";
    public static final String BINDING_EDITOR_BEAN = "editor.bean";
    public static final String BINDING_EDITOR_BEAN_PROPERTY = "editor.beanProperty";
    public static final String BINDING_EDITOR_CLAZZ = "editor.clazz";
    public static final String BINDING_EDITOR_FORMULE = "editor.formule";
    public static final String BINDING_EDITOR_FORMULE_CATEGORY = "editor.formuleCategory";
    public static final String BINDING_EDITOR_SELECTED_EQUATION = "editor.selectedEquation";
    public static final String BINDING_EDITOR_TEXT = "editor.text";
    public static final String BINDING_EDITOR_VISIBLE = "editor.visible";
    public static final String BINDING_MAX_BOUND_FIELD_ENABLED = "maxBoundField.enabled";
    public static final String BINDING_MIN_BOUND_FIELD_ENABLED = "minBoundField.enabled";
    public static final String BINDING_MIN_MAX_BUTTON_ENABLED = "minMaxButton.enabled";
    public static final String BINDING_MIN_MAX_BUTTON_SELECTED = "minMaxButton.selected";
    public static final String BINDING_PERCENTAGE_TYPE_BUTTON_ENABLED = "percentageTypeButton.enabled";
    public static final String BINDING_PERCENTAGE_TYPE_BUTTON_SELECTED = "percentageTypeButton.selected";
    public static final String BINDING_REFERENCE_VALUE_FIELD_ENABLED = "referenceValueField.enabled";
    public static final String BINDING_REMOVE_ENABLED = "remove.enabled";
    public static final String BINDING_REMOVE_VISIBLE = "remove.visible";
    public static final String BINDING_VARIABLE_NAME_FIELD_ENABLED = "variableNameField.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";
    private static final String BINDING_$JLABEL4_ENABLED = "$JLabel4.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVYz28bRRSeuHV+tGmTJiUEEVAKhgpU1m1TcUkoaZIabBxS4iQULARj7ziear2znZ117BwQNy4gceYEdy5IvXFCHDhz4IL4FxDiwIEL4s3setcbbzYrJoe1M++9773vvTczz/vdHyjvcnTtEe71DO7ZgnaIUbn38OFO4xFpii3iNjl1BOPI/xvLoVwdXTTDdVegF+tVaV4MzIubrOMwm9hD1qtVdMEVfYu4bUKEQM/FLZquW6yF4tWe4/EBahhUEuo3f/2Z+8r87NscQj0HorsOVJbPsoqYnK+iHDUFmgNPXVy0sH0IYXBqH0K8l+TapoVd913cIY/Rp2iiisYdzAFMoBeyU1YYyr7nCLRU2GRgY3vMcx9gm1jyX0xtwvfLNwVaa3GDtjjpEPh0qduibtvwqOES26WCdqnoG/cfe1hQZp8A2i87jvIzLtB5QXoQ5azkYEhehs9rSKNBsC3QCuOHhu1RwWxDMIdiwyEc/ApiN4mxJ1fugxfRl84AEzcsEoFMS5AHnIGN6Mu1y5Es37Tw8bFAM1EMKhORxkyL8Y4HCcKCHDJ+EmDWJRa0IDEHfAV6KSk7RMZHiRvmJYKYCDwIVEi1LPlqkeHlge8t1oHiCHQlYrHBmAW0I+WrQL8JWPiQ7PUd4ptI2bVIZ75QU31RtsEjtugx4VDtl1WvNqF5qAWB+a1jjGgOEWrKMsgGnJMB9Qz3CKpqVFQDRGqXChUAYZYl18HP0zHlSCTVr0fghT1ZXtBfjO0h30zJpOaryW5uycUb8vFaqDDXxZxKO7cKLbXNTGIJtJmhxUlQyrCmflJDlCGqMRdBoUKqck0q3oyKVZBrNVVewFVowPj5YbNRDedkkhTbYpxtILodilZD0WShUsUN5SleOLUqld4Ida8MGMlzp0SJBSfUQsxoDzaiEsQNpzvU3sa9DU8IuVkWYza72KTMF8VDO9G9kcpbcb3pNjVlVKrV5NorcXnAfiVkXxlhr5J2Tz6qUf0g6A3m2WZIaCuuMDC+nWgMdNOMg6DupAS1EuIeRLuVkxbh8gg8wJZH4ugHIxB3EiBmm4y0WrRJIbWn2U8VKn66oS3mY9VKKtQ5bCqQRrzrxmEnsS5JkhATznUuUPGUHUdtxxNGWT53bDLYavvlAIajZ2PnANzSRnRLR9foWB3lORyfMAos1kcv9l0Q+Vf64okrXQIq6b8L87/+8PuT0uAevwG+n0pUHRpD4H51/KuHStcz/iXuCWoVt7GzWkdT/iGuZpSlhMBqgRiCA3/+CS/Njbex2waI/MRvP/608Mkv51CuhC5YDJslLPXLaEq0OWSBWWbPeXNdRTR9NAnPWRkb9KWjGogTswbnN1wnayYWeLlBbRPKe7cHuVhKyEUYUGPq57/na9+vD/IxBvE9c6p6lJP8h2ic2hZME2qyCYaWxEnmouMSz2TRcJI0rozJz1tOcPox9XSTCE83iWXtEtuEXcOlVrfnyY8jFbz81ldYr2fAynfkiasJMkFsufHNFJj1DDDBHDW35md1GQsYoxqeIHf/L6Zc/jwlqk1thFIGXpOD+UYLRy5/IR9f6iCkcSlnQvhaGyGNxdkIcNRauM88kRLHO1lQGoybqftnWzujO9r5yIaQFsN72gg1bRbZENJi2M+E8CQF4X3tGD7QzkM2hLQY6toIH2mzyIaQFsPH2ghYm4U+gpnlauzCDBj8ljuFytkwZyWjpU0lG8I/WjHAkQsTHfWn51PiaGdAuYo9wWq4S+DHIoWhX83RmpjqBU0KuywYI+9nNLD89zmaIIMXMpowSW+ONOBG3jRp4YWNrYWQ1tgS4T84vIVzuRUAAA==";
    private static final Log log = LogFactory.getLog(EquationContinuousPanelUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton add;
    protected TopiaEntityContextable bean;
    protected String beanProperty;
    protected Class clazz;
    protected JTextField coefficientField;
    protected InputOneEquationUI editor;
    protected Formule formule;
    protected String formuleCategory;
    protected JPanel hidablePanel;
    protected JTextField maxBoundField;
    protected JTextField minBoundField;
    protected JRadioButton minMaxButton;
    protected JRadioButton percentageTypeButton;
    protected Boolean percentageTypeDomain;
    protected JTextField referenceValueField;
    protected JButton remove;
    protected Boolean selectedDomain;
    protected Equation selectedEquation;
    protected String text;
    protected JTextField variableNameField;
    protected JList variablesList;
    protected EquationDomainListModel variablesListModel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private EquationContinuousPanelUI $ContinuousPanelContainerUI0 = this;
    private JScrollPane $JScrollPane0;
    private Table $Table0;
    private JScrollPane $JScrollPane1;
    private ListSelectionModel $ListSelectionModel0;
    private Table $Table1;
    private Table $Table2;
    private JLabel $JLabel0;
    private Table $Table3;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private Table $Table4;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JButton $JButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<EquationContinuousDomain> domains;
    
    
    public List<EquationContinuousDomain> getDomains() {
        return domains;
    }
    
    protected void addDomain(EquationContinuousDomain domain) {
        domains.add(domain);
        // fire data change
        variablesListModel.setDomains(domains);
    }
    
    /**
     * Valid selected domain.
     */
    protected void validSelectedDomain() {
        // fill selected
        EquationContinuousDomain selectedDomain = (EquationContinuousDomain)variablesList.getSelectedValue();
        selectedDomain.setVariableName(variableNameField.getText().trim());
        if (isPercentageTypeDomain()) {
            selectedDomain.setPercentageType(true);
            selectedDomain.setReferenceValue(Double.parseDouble(referenceValueField.getText()));
            selectedDomain.setCoefficient(Double.parseDouble(coefficientField.getText()) / 100);
        } else {
            selectedDomain.setPercentageType(false);
            selectedDomain.setMinBound(Double.parseDouble(minBoundField.getText())); 
            selectedDomain.setMaxBound(Double.parseDouble(maxBoundField.getText()));
        }
        
        
        // parse equation content to replace
        // double xxx = 4.0;
        // by
        // double xxx = context.getValueAndCompute("myfactorname.xxx", 4.0)
        // if xxx is the variable name to replace
        String variableName = selectedDomain.getVariableName();
        String[] lines = editor.getEditor().getText().split("\n");
        String result = "";
        for (String line : lines) {
            Pattern p = Pattern.compile("(^.*\\s+" + variableName + "\\s*\\=\\s*)([\\d\\.]+).*\\;$");
            Matcher matcher = p.matcher(line);
            if (matcher.find()) {
                String fullVariableName = bean.toString() + "." + StringUtils.uncapitalize(beanProperty) + "." + variableName;
                line = matcher.group(1) +  "context.getValueAndCompute(\"" + fullVariableName + "\", " + matcher.group(2) + ");";
            }
            result += line + "\n";
        }
        editor.getEditor().setText(result);
        
        // fire data change
        variablesListModel.setDomains(domains);
    }
    
    protected void addNewVariable() {
        EquationContinuousDomain domain = new EquationContinuousDomain();
        domain.setVariableName("X");
        addDomain(domain);
        
        // auto select
        variablesList.setSelectedValue(domain, true);
    }
    
    protected void displaySelectedDomain() {
        EquationContinuousDomain selectedDomain = (EquationContinuousDomain)variablesList.getSelectedValue();
        if (selectedDomain != null) {
            setSelectedDomain(true);
            variableNameField.setText(selectedDomain.getVariableName());
            setPercentageTypeDomain(selectedDomain.getCoefficient() != null);
            if (selectedDomain.getCoefficient() != null) {
                coefficientField.setText(String.valueOf(selectedDomain.getCoefficient() * 100));
            } else {
                coefficientField.setText("");
            }
            if (selectedDomain.getReferenceValue() != null) {
                referenceValueField.setText(selectedDomain.getReferenceValue().toString());
            } else {
                referenceValueField.setText("");
            }
            if (selectedDomain.getMinBound() != null) {
                minBoundField.setText(selectedDomain.getMinBound().toString());
            } else {
                minBoundField.setText("");
            }
            if (selectedDomain.getMaxBound() != null) {
                maxBoundField.setText(selectedDomain.getMaxBound().toString());
            } else {
                maxBoundField.setText("");
            }
        } else {
            setSelectedDomain(false);
        }
    }
    
    protected void removeSelectedVariable() {
        int selectedIndex = variablesList.getSelectedIndex();
        domains.remove(selectedIndex);
        
        // fire data change
        variablesList.clearSelection();
        variablesListModel.setDomains(domains);
    }
    
    @Override
    public boolean isFactorValid() {
        boolean valid = true;
    
        try {
            for (EquationContinuousDomain domain : domains) {
                if (StringUtils.isBlank(domain.getVariableName())) {
                    valid = false;
                }
                else if (domain.getCoefficient() == null) {
                    valid = domain.getMinBound() != null && domain.getMaxBound() != null;
                }
                else {
                    valid = domain.getReferenceValue() != null;
                }
            }
        } catch (NumberFormatException ex) {
            valid = false;
        }
        
        return valid;
    }
    
    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_PERCENTAGE_TYPE_DOMAIN, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ((Boolean)evt.getNewValue()) {
                    ((CardLayout) hidablePanel.getLayout()).show(hidablePanel, "percentageType");
                } else {
                    ((CardLayout) hidablePanel.getLayout()).show(hidablePanel, "minMaxType");
                }
            }
        });
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EquationContinuousPanelUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EquationContinuousPanelUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EquationContinuousPanelUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EquationContinuousPanelUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EquationContinuousPanelUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EquationContinuousPanelUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EquationContinuousPanelUI() {
        $initialize();
    }

    public EquationContinuousPanelUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        validSelectedDomain();
    }

    public void doActionPerformed__on__add(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addNewVariable();
    }

    public void doActionPerformed__on__minMaxButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setPercentageTypeDomain(!minMaxButton.isSelected());
    }

    public void doActionPerformed__on__percentageTypeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setPercentageTypeDomain(percentageTypeButton.isSelected());
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeSelectedVariable();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        displaySelectedDomain();setSelectedDomain(variablesList.getSelectedIndex() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAdd() {
        return add;
    }

    public TopiaEntityContextable getBean() {
        return bean;
    }

    public String getBeanProperty() {
        return beanProperty;
    }

    public Class getClazz() {
        return clazz;
    }

    public JTextField getCoefficientField() {
        return coefficientField;
    }

    public InputOneEquationUI getEditor() {
        return editor;
    }

    public Formule getFormule() {
        return formule;
    }

    public String getFormuleCategory() {
        return formuleCategory;
    }

    public JPanel getHidablePanel() {
        return hidablePanel;
    }

    public JTextField getMaxBoundField() {
        return maxBoundField;
    }

    public JTextField getMinBoundField() {
        return minBoundField;
    }

    public JRadioButton getMinMaxButton() {
        return minMaxButton;
    }

    public JRadioButton getPercentageTypeButton() {
        return percentageTypeButton;
    }

    public Boolean getPercentageTypeDomain() {
        return percentageTypeDomain;
    }

    public JTextField getReferenceValueField() {
        return referenceValueField;
    }

    public JButton getRemove() {
        return remove;
    }

    public Boolean getSelectedDomain() {
        return selectedDomain;
    }

    public Equation getSelectedEquation() {
        return selectedEquation;
    }

    public String getText() {
        return text;
    }

    public JTextField getVariableNameField() {
        return variableNameField;
    }

    public JList getVariablesList() {
        return variablesList;
    }

    public EquationDomainListModel getVariablesListModel() {
        return variablesListModel;
    }

    public Boolean isPercentageTypeDomain() {
        return percentageTypeDomain !=null && percentageTypeDomain;
    }

    public Boolean isSelectedDomain() {
        return selectedDomain !=null && selectedDomain;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(TopiaEntityContextable bean) {
        TopiaEntityContextable oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setBeanProperty(String beanProperty) {
        String oldValue = this.beanProperty;
        this.beanProperty = beanProperty;
        firePropertyChange(PROPERTY_BEAN_PROPERTY, oldValue, beanProperty);
    }

    public void setClazz(Class clazz) {
        Class oldValue = this.clazz;
        this.clazz = clazz;
        firePropertyChange(PROPERTY_CLAZZ, oldValue, clazz);
    }

    public void setFormule(Formule formule) {
        Formule oldValue = this.formule;
        this.formule = formule;
        firePropertyChange(PROPERTY_FORMULE, oldValue, formule);
    }

    public void setFormuleCategory(String formuleCategory) {
        String oldValue = this.formuleCategory;
        this.formuleCategory = formuleCategory;
        firePropertyChange(PROPERTY_FORMULE_CATEGORY, oldValue, formuleCategory);
    }

    public void setPercentageTypeDomain(Boolean percentageTypeDomain) {
        Boolean oldValue = this.percentageTypeDomain;
        this.percentageTypeDomain = percentageTypeDomain;
        firePropertyChange(PROPERTY_PERCENTAGE_TYPE_DOMAIN, oldValue, percentageTypeDomain);
    }

    public void setSelectedDomain(Boolean selectedDomain) {
        Boolean oldValue = this.selectedDomain;
        this.selectedDomain = selectedDomain;
        firePropertyChange(PROPERTY_SELECTED_DOMAIN, oldValue, selectedDomain);
    }

    public void setSelectedEquation(Equation selectedEquation) {
        Equation oldValue = this.selectedEquation;
        this.selectedEquation = selectedEquation;
        firePropertyChange(PROPERTY_SELECTED_EQUATION, oldValue, selectedEquation);
    }

    public void setText(String text) {
        String oldValue = this.text;
        this.text = text;
        firePropertyChange(PROPERTY_TEXT, oldValue, text);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected Table get$Table4() {
        return $Table4;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToContent() {
        if (!allComponentsCreated) {
            return;
        }
        content.add($JScrollPane0, BorderLayout.CENTER);
    }

    protected void addChildrenToHidablePanel() {
        if (!allComponentsCreated) {
            return;
        }
        hidablePanel.add($Table3, "minMaxType");
        hidablePanel.add($Table4, "percentageType");
    }

    protected void createAdd() {
        $objectMap.put("add", add = new JButton());
        
        add.setName("add");
        add.setText(_("isisfish.common.add"));
        add.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__add"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createBeanProperty() {
        $objectMap.put("beanProperty", beanProperty = null);
    }

    protected void createClazz() {
        $objectMap.put("clazz", clazz = null);
    }

    protected void createCoefficientField() {
        $objectMap.put("coefficientField", coefficientField = new JTextField());
        
        coefficientField.setName("coefficientField");
        coefficientField.setColumns(15);
    }

    @Override
    protected void createContent() {
        super.createContent();
        content.setName("content");
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new InputOneEquationUI(this));
        
        editor.setName("editor");
        editor.setActive(true);
        editor.setAutoSaveModification(false);
    }

    protected void createFormule() {
        $objectMap.put("formule", formule = null);
    }

    protected void createFormuleCategory() {
        $objectMap.put("formuleCategory", formuleCategory = null);
    }

    protected void createHidablePanel() {
        $objectMap.put("hidablePanel", hidablePanel = new JPanel());
        
        hidablePanel.setName("hidablePanel");
        hidablePanel.setLayout(new CardLayout());
    }

    protected void createMaxBoundField() {
        $objectMap.put("maxBoundField", maxBoundField = new JTextField());
        
        maxBoundField.setName("maxBoundField");
        maxBoundField.setColumns(15);
    }

    protected void createMinBoundField() {
        $objectMap.put("minBoundField", minBoundField = new JTextField());
        
        minBoundField.setName("minBoundField");
        minBoundField.setColumns(15);
    }

    protected void createMinMaxButton() {
        $objectMap.put("minMaxButton", minMaxButton = new JRadioButton());
        
        minMaxButton.setName("minMaxButton");
        minMaxButton.setText(_("isisfish.sensitivity.continuousminmaxtype"));
        minMaxButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__minMaxButton"));
    }

    protected void createPercentageTypeButton() {
        $objectMap.put("percentageTypeButton", percentageTypeButton = new JRadioButton());
        
        percentageTypeButton.setName("percentageTypeButton");
        percentageTypeButton.setText(_("isisfish.sensitivity.continuouspercentagetype"));
        percentageTypeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__percentageTypeButton"));
    }

    protected void createPercentageTypeDomain() {
        $objectMap.put("percentageTypeDomain", percentageTypeDomain = false);
    }

    protected void createReferenceValueField() {
        $objectMap.put("referenceValueField", referenceValueField = new JTextField());
        
        referenceValueField.setName("referenceValueField");
        referenceValueField.setColumns(15);
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.setText(_("isisfish.common.remove"));
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createSelectedDomain() {
        $objectMap.put("selectedDomain", selectedDomain = false);
    }

    protected void createSelectedEquation() {
        $objectMap.put("selectedEquation", selectedEquation = null);
    }

    protected void createText() {
        $objectMap.put("text", text = null);
    }

    protected void createVariableNameField() {
        $objectMap.put("variableNameField", variableNameField = new JTextField());
        
        variableNameField.setName("variableNameField");
        variableNameField.setColumns(15);
    }

    protected void createVariablesList() {
        $objectMap.put("variablesList", variablesList = new JList());
        
        variablesList.setName("variablesList");
    }

    protected void createVariablesListModel() {
        $objectMap.put("variablesListModel", variablesListModel = new EquationDomainListModel(domains));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToContent();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JScrollPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table1, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(add, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(remove, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(editor, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(variablesList);
        // inline complete setup of $Table1
        $Table1.add($Table2, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(minMaxButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(percentageTypeButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(hidablePanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton0, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(variableNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToHidablePanel();
        // inline complete setup of $Table3
        $Table3.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(minBoundField, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(maxBoundField, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table4
        $Table4.add($JLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(referenceValueField, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JLabel4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(coefficientField, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 26 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        $JScrollPane1.setPreferredSize(new Dimension(200, 150));
        variablesList.setCellRenderer(new fr.ifremer.isisfish.ui.sensitivity.equation.EquationDomainRenderer());
        variablesList.setModel(variablesListModel);
        $Table3.setBorder(BorderFactory.createTitledBorder(""));
        $Table4.setBorder(BorderFactory.createTitledBorder(""));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$ContinuousPanelContainerUI0", $ContinuousPanelContainerUI0);
        createText();
        createBean();
        createBeanProperty();
        createClazz();
        createFormuleCategory();
        createSelectedEquation();
        createFormule();
        createSelectedDomain();
        createPercentageTypeDomain();
        domains = new ArrayList<EquationContinuousDomain>();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createVariablesListModel();
        createVariablesList();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = variablesList.getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("isisfish.sensitivity.equation.variablename"));
        createVariableNameField();
        createMinMaxButton();
        createPercentageTypeButton();
        createHidablePanel();
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("isisfish.sensitivity.firstValue"));
        createMinBoundField();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.sensitivity.lastValue"));
        createMaxBoundField();
        // inline creation of $Table4
        $objectMap.put("$Table4", $Table4 = new Table());
        
        $Table4.setName("$Table4");
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.sensitivity.referencevalue"));
        createReferenceValueField();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("isisfish.sensitivity.coefficient"));
        createCoefficientField();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("isisfish.sensitivity.equation.valid"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createAdd();
        createRemove();
        createEditor();
        // inline creation of $ContinuousPanelContainerUI0
        setName("$ContinuousPanelContainerUI0");
        
        // registers 26 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 26 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"selectedDomain") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isSelectedDomain());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLE_NAME_FIELD_ENABLED, true ,"selectedDomain") {
        
            @Override
            public void processDataBinding() {
                variableNameField.setEnabled(isSelectedDomain());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MIN_MAX_BUTTON_ENABLED, true ,"selectedDomain") {
        
            @Override
            public void processDataBinding() {
                minMaxButton.setEnabled(isSelectedDomain());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MIN_MAX_BUTTON_SELECTED, true ,"percentageTypeDomain") {
        
            @Override
            public void processDataBinding() {
                minMaxButton.setSelected(!isPercentageTypeDomain());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PERCENTAGE_TYPE_BUTTON_ENABLED, true ,"selectedDomain") {
        
            @Override
            public void processDataBinding() {
                percentageTypeButton.setEnabled(isSelectedDomain());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PERCENTAGE_TYPE_BUTTON_SELECTED, true ,"percentageTypeDomain") {
        
            @Override
            public void processDataBinding() {
                percentageTypeButton.setSelected(isPercentageTypeDomain());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"selectedDomain") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isSelectedDomain());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MIN_BOUND_FIELD_ENABLED, true ,"selectedDomain") {
        
            @Override
            public void processDataBinding() {
                minBoundField.setEnabled(isSelectedDomain());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"selectedDomain") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isSelectedDomain());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MAX_BOUND_FIELD_ENABLED, true ,"selectedDomain") {
        
            @Override
            public void processDataBinding() {
                maxBoundField.setEnabled(isSelectedDomain());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"selectedDomain") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(isSelectedDomain());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REFERENCE_VALUE_FIELD_ENABLED, true ,"selectedDomain") {
        
            @Override
            public void processDataBinding() {
                referenceValueField.setEnabled(isSelectedDomain());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL4_ENABLED, true ,"selectedDomain") {
        
            @Override
            public void processDataBinding() {
                $JLabel4.setEnabled(isSelectedDomain());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COEFFICIENT_FIELD_ENABLED, true ,"selectedDomain") {
        
            @Override
            public void processDataBinding() {
                coefficientField.setEnabled(isSelectedDomain());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"selectedDomain") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isSelectedDomain());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_VISIBLE, true ,"continuePossible") {
        
            @Override
            public void processDataBinding() {
                add.setVisible(isContinuePossible());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_ENABLED, true ,"selectedDomain") {
        
            @Override
            public void processDataBinding() {
                remove.setEnabled(isSelectedDomain());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_VISIBLE, true ,"continuePossible") {
        
            @Override
            public void processDataBinding() {
                remove.setVisible(isContinuePossible());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                editor.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_BEAN_PROPERTY, true ,"beanProperty") {
        
            @Override
            public void processDataBinding() {
                editor.setBeanProperty(getBeanProperty());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_CLAZZ, true ,"clazz") {
        
            @Override
            public void processDataBinding() {
                editor.setClazz(getClazz());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_FORMULE, true ,"formule") {
        
            @Override
            public void processDataBinding() {
                editor.setFormule(getFormule());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_FORMULE_CATEGORY, true ,"formuleCategory") {
        
            @Override
            public void processDataBinding() {
                editor.setFormuleCategory(getFormuleCategory());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_SELECTED_EQUATION, true ,"selectedEquation") {
        
            @Override
            public void processDataBinding() {
                editor.setSelectedEquation(getSelectedEquation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_TEXT, true ,"text") {
        
            @Override
            public void processDataBinding() {
                editor.setText(_(getText()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_VISIBLE, true ,"continuePossible") {
        
            @Override
            public void processDataBinding() {
                editor.setVisible(isContinuePossible());
            }
        });
    }

}