/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.sensitivity;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ContinuousPanelContainerUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CONTINUE_POSSIBLE = "continuePossible";
    public static final String PROPERTY_CONTINUE_SELECTED = "continueSelected";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1STW8TMRCdLE3SpFBKKqpWtCKlPW+4h49CUUSrABURUkUuOFmnceXYxva2mwviJ/AT4M4FiRsnxIEzBy6Iv4AQB66IsZNmW7oIcrA3npk3b968198gbzSs7pMkCXUsLBvQcPvW7u6Dzj7t2jvUdDVTVmoY/XIBBG2YiSbvxsJau+nKa+Py2qYcKCmoOFZdb0LZ2CGnpk+ptbBysqJrTK01CdcTFesj1AmpLNSXP74HL6LnrwKARCG7KRyl+q+qdJKpJgQsslDBTgekxonYQxqaiT3ke869bXJizH0yoE/hGRSbUFBEI5iFK/8/ssfw9YmyML2+vUME5VctXO/pkPU0HVC8DTM9ZvphzEJDhWGWHTA7RP7YQMQyNr7K/SVMUP1oSykPWrAw1x0l0R1pDOtwauGCIx+6gcLbUnJKREZ6i3JcMY3c+2waL7q4H7LiUJLQHKIi4Yi2yykplPnSCZlxgWG6wFThXBvyOsZnC4vt0zt/iKHRthf/2LYD9NFfC/Of33192zhacYC9L2amHnMoSq+0VFRb5lqfH+03tozX7hFVb0PJ+Nm9fZcziLXGYSSH/UZquvLwLjF9hMgXv7z/sPDk0xkIGlDmkkQN4vK3oGT7GlWQPErUzQ3P6OzhNJ5zjpuFAidDGaO4s9ciYkm1w0SE8t5IUITlDBEmTDqljz/nW282joTIIbGlv6anYuQfQ4EJjqbxbh8bOdPdM8rQOJKpYbMsnHN3WY39suTPldOTuufL7qgmsbtWPWX3teZjFUT4DXBeEHV9BAAA";
    private static final Log log = LogFactory.getLog(ContinuousPanelContainerUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel content;
    protected Boolean continuePossible;
    protected Boolean continueSelected;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ContinuousPanelContainerUI $JPanel0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /**
     * Return true only if UI component are all filled and value are correct
     * to define new factor.
     */
    public abstract boolean isFactorValid();

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ContinuousPanelContainerUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ContinuousPanelContainerUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ContinuousPanelContainerUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ContinuousPanelContainerUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ContinuousPanelContainerUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ContinuousPanelContainerUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ContinuousPanelContainerUI() {
        $initialize();
    }

    public ContinuousPanelContainerUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getContent() {
        return content;
    }

    public Boolean getContinuePossible() {
        return continuePossible;
    }

    public Boolean getContinueSelected() {
        return continueSelected;
    }

    public Boolean isContinuePossible() {
        return continuePossible !=null && continuePossible;
    }

    public Boolean isContinueSelected() {
        return continueSelected !=null && continueSelected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setContinuePossible(Boolean continuePossible) {
        Boolean oldValue = this.continuePossible;
        this.continuePossible = continuePossible;
        firePropertyChange(PROPERTY_CONTINUE_POSSIBLE, oldValue, continuePossible);
    }

    public void setContinueSelected(Boolean continueSelected) {
        Boolean oldValue = this.continueSelected;
        this.continueSelected = continueSelected;
        firePropertyChange(PROPERTY_CONTINUE_SELECTED, oldValue, continueSelected);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createContent() {
        $objectMap.put("content", content = new JPanel());
        
        content.setName("content");
        content.setLayout(new BorderLayout());
    }

    protected void createContinuePossible() {
        $objectMap.put("continuePossible", continuePossible = true);
    }

    protected void createContinueSelected() {
        $objectMap.put("continueSelected", continueSelected = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(content, BorderLayout.CENTER);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createContinuePossible();
        createContinueSelected();
        createContent();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

}