/*
 * #%L
 * IsisFish
 * 
 * $Id: RuleListModel.java 3393 2011-06-14 17:43:37Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.rule;

import java.util.List;

import javax.swing.AbstractListModel;

import fr.ifremer.isisfish.rule.Rule;

/**
 * Model pour la liste des regles des parametres d'une simulation.
 *
 * @author chatellier
 * @version $Revision: 3393 $
 * 
 * Last update : $Date: 2011-06-14 19:43:37 +0200 (mar., 14 juin 2011) $
 * By : $Author: chatellier $
 */
public class RuleListModel extends AbstractListModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    protected List<Rule> rules;

    /**
     * Empty constructor.
     */
    public RuleListModel() {
        this(null);
    }

    /**
     * Constructor with rule list.
     * 
     * @param rules rules
     */
    public RuleListModel(List<Rule> rules) {
        this.rules = rules;
    }

    /**
     * Get rules list.
     * 
     * @return the rules
     */
    public List<Rule> getRules() {
        return rules;
    }

    /**
     * Set rules list.
     * 
     * @param rules the rules to set
     */
    public void setRules(List<Rule> rules) {
        this.rules = rules;
        fireContentsChanged(this, 0, rules.size() - 1);
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return rules.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (rules != null) {
            size = rules.size();
        }
        return size;
    }
}
