/*
 * #%L
 * IsisFish
 * 
 * $Id: RuleComboModel.java 3445 2011-07-15 13:12:45Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.rule;

import java.util.List;

import javax.swing.DefaultComboBoxModel;

/**
 * Model pour la liste des noms de regles.
 *
 * @author chatellier
 * @version $Revision: 3445 $
 * 
 * Last update : $Date: 2011-07-15 15:12:45 +0200 (ven., 15 juil. 2011) $
 * By : $Author: chatellier $
 */
public class RuleComboModel extends DefaultComboBoxModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    /** Rule names. */
    protected List<String> rulesNames;

    /**
     * Empty constructor.
     */
    public RuleComboModel() {
        this(null);
    }

    /**
     * Constructor with rule names list.
     * 
     * @param rulesNames exports Names
     */
    public RuleComboModel(List<String> rulesNames) {
        super();
        setExportNames(rulesNames);
    }

    /**
     * Get rule names.
     * 
     * @return the rule names
     */
    public List<String> getExportNames() {
        return rulesNames;
    }

    /**
     * Set rule names.
     * 
     * @param rulesNames the rule names to set
     */
    public void setExportNames(List<String> rulesNames) {
        this.rulesNames = rulesNames;

        // default first selected
        if (!rulesNames.isEmpty()) {
            setSelectedItem(rulesNames.get(0));
        }
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return rulesNames.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (rulesNames != null) {
            size = rulesNames.size();
        }
        return size;
    }
}
