/*
 * #%L
 * $Id: CellsNodeLoador.java 3264 2011-04-18 15:44:40Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.0.0.1/src/main/java/fr/ifremer/isisfish/ui/input/tree/loadors/CellsNodeLoador.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input.tree.loadors;

import java.util.List;

import jaxx.runtime.swing.nav.NavDataProvider;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.ui.input.tree.FisheryDataProvider;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeNode;

/**
 * Cell tree path node loader.
 * 
 * @author chatellier
 * @since 3.4.0.0
 */
public class CellsNodeLoador extends FisheryTreeNodeLoador<Cell> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6540304326033236054L;

    public CellsNodeLoador() {
        super(Cell.class);
    }

    @Override
    public List<Cell> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {
        FisheryDataProvider ficheryRegionDataProvider = (FisheryDataProvider)dataProvider;
        FisheryRegion fisheryRegion = ficheryRegionDataProvider.getFisheryRegion();
        List<Cell> cell = fisheryRegion.getCell();
        return cell;
    }

    @Override
    public FisheryTreeNode createNode(Cell cell, NavDataProvider dataProvider) {

        // Create clients static nodes
        FisheryTreeNode cellNode = new FisheryTreeNode(
                Cell.class, cell.getTopiaId(),
                null, null);

        return cellNode;
    }
}
