/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.ui.input.model.ZoneListModel;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import static org.nuiton.i18n.I18n._;

public class PopulationZonesEditorUI extends InputContentUI<fr.ifremer.isisfish.entities.Population> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FIELD_POPULATION_MAPPING_ZONE_REPRO_ZONE_RECRU_ENABLED = "fieldPopulationMappingZoneReproZoneRecru.enabled";
    public static final String BINDING_FIELD_POPULATION_ZONES_RECRUITMENT_ENABLED = "fieldPopulationZonesRecruitment.enabled";
    public static final String BINDING_FIELD_POPULATION_ZONES_REPRODUCTION_ENABLED = "fieldPopulationZonesReproduction.enabled";
    public static final String BINDING_POPULATION_ZONES_PRESENCE_ENABLED = "populationZonesPresence.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUz08TQRTHh0r5IaIIQUVRilRFQ7b4I/EACgRpLClKqCSEXpx2p3TM7Ow4MyuLB+Of4J+gdy8m3jwZD549eDH+C8Z48Gp8My0thaU0KYftMvPe533f25nv+18oriQaf4bD0JEB19QjzvLCxsbjwjNS1A+IKkoqtC9R5a8jhmJ51OfW1pVGE/msSU9V01OLvid8Tvie7JksOq70DiOqTIjW6GJjRlGpVK62PROKQO5Sa6KiqG///I69cV+/iyEUClA3AK0kjsqqd9KZRTHqajQIlV7gFMN8C2RIyrdAb79ZW2RYqUfYI8/RK9SdRV0CS4BpdLn1li3D5odCo4FkhotAL/pcQ/h6ZlqjOyXp0JIkHoFfRVWJqrITUIeaQGfVFwHDmvp8EyqoJZcCfD0jhGV2adRZIJhrdC2KAiWopkTtodQTh5I5qzXDIQYz+pJIUHPVzq8IDVEGqEo7zoHIvfV9dweGaOYVOmobxucsr2JOWD2mO/kEFxgB/LmGz1OJtnsmcrCW0JNczuICYdP7wXbVBA0fiL1p/j8fvXcrYq8/uQxt+YwZsVDobEOh+lZj1lnR+EFWJVGEF4lGpxuFUqVNylh0PSt2vBGdKFHC3H0ffI0I6btB0SyYuKR5XImG3oqAjkVDizKg2oPzUWNePzC02xFDm9yHW8FCQL+GapVWXoCu0ZQvtxwOZXzueFiXzUPS0NmCs71iX+0pqZzoahWJLjQcEHAGp+4M9avbkUdxGcAynKj8QTNZg62KjZzbZyMGaHf/nRn6/unnx/SudwxC7eHI0D3WB3caehREmkul0amKcQSashQMYiaPehVh4JvWF0cjhOWq2yAO6tkT45h05yFWZUDEu398/nLm6bdjKJZGx5mP3TQ28RnUq8tw0so+c0MxN28VndjuMaZntMEVI9xcI7Czk7Mu1jhRoNyFL3M/hCmMRkyhJqXQ+/XvUO7D/O4kOkDZyKHh9WnEN1EX5YxyYn20apGRvtknFAlcv26FUebYYX5HRNU17trnTFSrnZqE4MGDs5XqCazhMBUCTaBXkzRnmzBvCy0yzfI98ziEMNoSYck80u0Qmmm41LaGowka9XmUUy/wcmDyTcQkWkD1C0lKREritg07ajYTLRHyTQhXWyI8bZvQrIvJtru40XYXrRGadTHVNsFp+6S3RmimYRoI/wEaKbHdHQsAAA==";
    private static final Log log = LogFactory.getLog(PopulationZonesEditorUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Population bean;
    protected MatrixPanelEditor fieldPopulationMappingZoneReproZoneRecru;
    protected JList fieldPopulationZonesRecruitment;
    protected JList fieldPopulationZonesReproduction;
    protected JList populationZonesPresence;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationZonesEditorUI $InputContentUI0 = this;
    private Table $Table0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JScrollPane $JScrollPane2;
    private JLabel $JLabel3;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected boolean init;
    
    
    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    setPopulationZonesPresenceModel();
                    setFieldPopulationZonesReproductionModel(getSelectedValues(populationZonesPresence));
                    setFieldPopulationZonesRecruitmentModel(getSelectedValues(populationZonesPresence));
                    setFieldPopulationMappingZoneReproZoneRecru();
                }
                if (evt.getNewValue() != null) {
                    init = true;
                    setPopulationZonesPresenceModel();
                    setFieldPopulationZonesReproductionModel(getSelectedValues(populationZonesPresence));
                    setFieldPopulationZonesRecruitmentModel(getSelectedValues(populationZonesPresence));
                    setFieldPopulationMappingZoneReproZoneRecru();
                    init = false;
                }
            }
        });
    }
    
    protected void populationMappingZoneReproZoneRecruMatrixChanged(MatrixPanelEvent event) {
        getBean().setMappingZoneReproZoneRecru(fieldPopulationMappingZoneReproZoneRecru.getMatrix().clone());
    }
    
    /*public void refresh() {
        setPopulationZonesPresenceModel();
        setFieldPopulationZonesReproductionModel(getSelectedValues(populationZonesPresence));
        setFieldPopulationZonesRecruitmentModel(getSelectedValues(populationZonesPresence));
        //fieldPopulationMappingZoneReproZoneRecru.removeMatrixPanelListener(listener);
        setFieldPopulationMappingZoneReproZoneRecru();
        //fieldPopulationMappingZoneReproZoneRecru.addMatrixListener(listener);
    }*/
    
    protected void setFieldPopulationMappingZoneReproZoneRecru() {
        if (getBean() != null) {
            if (getBean().getMappingZoneReproZoneRecru() != null) {
                fieldPopulationMappingZoneReproZoneRecru.setMatrix(getBean().getMappingZoneReproZoneRecru().copy());
            }
        }
    }
    protected void setPopulationZonesPresenceModel() {
        if (getBean() != null) {
            java.util.List<Zone> zones = getFisheryRegion().getZone();
            setModel(zones, getBean().getPopulationZone(), populationZonesPresence);
        }
    }
    protected void setFieldPopulationZonesReproductionModel(List<Zone> zones) {
        if (getBean() != null) {
            setModel(zones, getBean().getReproductionZone(), fieldPopulationZonesReproduction);
        }
    }
    protected void setFieldPopulationZonesRecruitmentModel(List<Zone> zones) {
        if (getBean() != null) {
            setModel(zones, getBean().getRecruitmentZone(), fieldPopulationZonesRecruitment);
        }
    }
    
    /**
     * Change model of {@code associatedList} with all available zones, but keep
     * selection with {@code selectedZones}.
     */
    protected void setModel(List<Zone> availableZones, List<Zone> selectedZones, JList associatedList) {    
        ZoneListModel zoneModel = new ZoneListModel(availableZones);
        associatedList.setModel(zoneModel);
        
        // can be null at population init
        if (selectedZones != null) {
            for (Zone selectedZone : selectedZones) {
                int index = availableZones.indexOf(selectedZone);
                associatedList.addSelectionInterval(index, index);
            }
        }
    }
    
    protected void presenceChanged() {
        if (!init) {
            getBean().setPopulationZone(getSelectedValues(populationZonesPresence));
            setFieldPopulationZonesReproductionModel(getSelectedValues(populationZonesPresence));
            setFieldPopulationZonesRecruitmentModel(getSelectedValues(populationZonesPresence));
            setFieldPopulationMappingZoneReproZoneRecru();
        }
    }
    
    protected void reproductionChanged() {
        if (!init) {
            getBean().setReproductionZone(getSelectedValues(fieldPopulationZonesReproduction));
            setFieldPopulationMappingZoneReproZoneRecru();
        }
    }
    
    protected void recruitementChanged() {
        if (!init) {
            getBean().setRecruitmentZone(getSelectedValues(fieldPopulationZonesRecruitment));
            setFieldPopulationMappingZoneReproZoneRecru();
        }
    }
    
    /**
     * Get selected values for components as list.
     */
    protected List<Zone> getSelectedValues(JList component) {
        Object[] selectedValues = component.getSelectedValues();
        List<Zone> selectedZone = new ArrayList<Zone>();
        for (Object value : selectedValues) {
            selectedZone.add((Zone)value);
        }
        return selectedZone;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationZonesEditorUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationZonesEditorUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PopulationZonesEditorUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationZonesEditorUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationZonesEditorUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationZonesEditorUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationZonesEditorUI() {
        $initialize();
    }

    public PopulationZonesEditorUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doMatrixChanged__on__fieldPopulationMappingZoneReproZoneRecru(MatrixPanelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        populationMappingZoneReproZoneRecruMatrixChanged(event);
    }

    public void doValueChanged__on__fieldPopulationZonesRecruitment(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        recruitementChanged();
    }

    public void doValueChanged__on__fieldPopulationZonesReproduction(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        reproductionChanged();
    }

    public void doValueChanged__on__populationZonesPresence(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        presenceChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Population getBean() {
        return bean;
    }

    public MatrixPanelEditor getFieldPopulationMappingZoneReproZoneRecru() {
        return fieldPopulationMappingZoneReproZoneRecru;
    }

    public JList getFieldPopulationZonesRecruitment() {
        return fieldPopulationZonesRecruitment;
    }

    public JList getFieldPopulationZonesReproduction() {
        return fieldPopulationZonesReproduction;
    }

    public JList getPopulationZonesPresence() {
        return populationZonesPresence;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createFieldPopulationMappingZoneReproZoneRecru() {
        $objectMap.put("fieldPopulationMappingZoneReproZoneRecru", fieldPopulationMappingZoneReproZoneRecru = new MatrixPanelEditor(false));
        
        fieldPopulationMappingZoneReproZoneRecru.setName("fieldPopulationMappingZoneReproZoneRecru");
        fieldPopulationMappingZoneReproZoneRecru.addMatrixPanelListener(JAXXUtil.getEventListener(MatrixPanelListener.class, "matrixChanged", this, "doMatrixChanged__on__fieldPopulationMappingZoneReproZoneRecru"));
    }

    protected void createFieldPopulationZonesRecruitment() {
        $objectMap.put("fieldPopulationZonesRecruitment", fieldPopulationZonesRecruitment = new JList());
        
        fieldPopulationZonesRecruitment.setName("fieldPopulationZonesRecruitment");
        fieldPopulationZonesRecruitment.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__fieldPopulationZonesRecruitment"));
    }

    protected void createFieldPopulationZonesReproduction() {
        $objectMap.put("fieldPopulationZonesReproduction", fieldPopulationZonesReproduction = new JList());
        
        fieldPopulationZonesReproduction.setName("fieldPopulationZonesReproduction");
        fieldPopulationZonesReproduction.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__fieldPopulationZonesReproduction"));
    }

    protected void createPopulationZonesPresence() {
        $objectMap.put("populationZonesPresence", populationZonesPresence = new JList());
        
        populationZonesPresence.setName("populationZonesPresence");
        populationZonesPresence.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__populationZonesPresence"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(2, 0, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 1, 1, 0.3, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane1, new GridBagConstraints(1, 1, 1, 1, 0.3, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane2, new GridBagConstraints(2, 1, 1, 1, 0.3, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMappingZoneReproZoneRecru, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(populationZonesPresence);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(fieldPopulationZonesReproduction);
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(fieldPopulationZonesRecruitment);
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        $JScrollPane0.setMinimumSize(new Dimension(0,0));
        $JScrollPane0.setPreferredSize(new Dimension(0,0));
        $JScrollPane1.setMinimumSize(new Dimension(0,0));
        $JScrollPane1.setPreferredSize(new Dimension(0,0));
        $JScrollPane2.setMinimumSize(new Dimension(0,0));
        $JScrollPane2.setPreferredSize(new Dimension(0,0));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        init = false;
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("isisfish.populationZones.selectPopulationAreas"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("isisfish.populationZones.selectSpawningAreas"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.populationZones.selectRecruitmentAreas"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createPopulationZonesPresence();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createFieldPopulationZonesReproduction();
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new JScrollPane());
        
        $JScrollPane2.setName("$JScrollPane2");
        createFieldPopulationZonesRecruitment();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.populationZones.betweenSpawningRecruitmentAreas"));
        createFieldPopulationMappingZoneReproZoneRecru();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_ZONES_PRESENCE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                populationZonesPresence.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_ZONES_REPRODUCTION_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationZonesReproduction.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_ZONES_RECRUITMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationZonesRecruitment.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MAPPING_ZONE_REPRO_ZONE_RECRU_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMappingZoneReproZoneRecru.setEnabled(isActive());
            }
        });
    }

}