/*
 * #%L
 * 
 * 
 * $Id: WelcomeHandler.java 3549 2011-12-01 13:19:20Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.0.0.1/src/main/java/fr/ifremer/isisfish/ui/WelcomeHandler.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui;

import static org.nuiton.i18n.I18n._;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.ToolTipManager;

import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.editor.config.ConfigUI;
import jaxx.runtime.swing.editor.config.ConfigUIHelper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.widget.AboutFrame;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.ui.config.RConfigHandler;
import fr.ifremer.isisfish.ui.config.RConfigUI;
import fr.ifremer.isisfish.ui.config.SSHLauncherConfigUI;
import fr.ifremer.isisfish.ui.input.InputAction;
import fr.ifremer.isisfish.ui.input.InputSaveVerifier;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.queue.QueueUI;
import fr.ifremer.isisfish.ui.result.ResultUI;
import fr.ifremer.isisfish.ui.script.ScriptUI;
import fr.ifremer.isisfish.ui.sensitivity.SensitivitySaveVerifier;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityUI;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import fr.ifremer.isisfish.ui.simulator.SimulUI;
import fr.ifremer.isisfish.ui.vcs.VCSConfigUI;

/**
 * Welcome related ui handler.
 * 
 * @author chatellier
 * @version $Revision: 3549 $
 * 
 * Last update : $Date: 2011-12-01 14:19:20 +0100 (jeu., 01 déc. 2011) $
 * By : $Author: echatellier $
 */
public class WelcomeHandler extends CommonHandler {

    /** Class logger. */
    private static Log log = LogFactory.getLog(WelcomeHandler.class);

    protected Map<JFrame, WelcomePanelUI> allFrameOpened;
    protected WelcomeSaveVerifier verifier = new WelcomeSaveVerifier();
    
    // URL alias
    protected static final Map<String, String> URLSALIAS = new HashMap<String, String>();

    static {
        URLSALIAS.put("ISISFISH", "http://www.isis-fish.org/");
        URLSALIAS.put("JAVA_API", "http://java.sun.com/javase/6/docs/api/index.html");
        URLSALIAS.put("ISIS_API", "http://www.isis-fish.org/isis-fish/apidocs/index.html");
        URLSALIAS.put("MATRIX_API", "http://maven-site.nuiton.org/nuiton-matrix/apidocs/index.html");
        URLSALIAS.put("TOPIA_API", "http://maven-site.nuiton.org/topia/topia-persistence/apidocs/index.html");
    }

    public void postInit(WelcomeUI welcomeUI) {
        welcomeUI.setContextValue(verifier);
        allFrameOpened = new java.util.HashMap<JFrame, WelcomePanelUI>();
        welcomeUI.getWelcomePanelUI().setContent(new WelcomeTabUI(new JAXXInitialContext().add(verifier)));
    
        // increase tooltip display time
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setInitialDelay(0);
        toolTipManager.setDismissDelay(60000);
    }

    protected void openFrame(WelcomeUI welcomeUI, Component c, String title) {

        JAXXInitialContext childContext = new JAXXInitialContext().add(verifier).add(this);
        WelcomePanelUI welcome = new WelcomePanelUI(childContext);
        welcome.setContent(c);
        
        JFrame frame = new JFrame(title);
        frame.setLayout(new BorderLayout());
        frame.add(welcome, BorderLayout.CENTER);
        frame.setSize(new Dimension(800, 600));
        frame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);

        allFrameOpened.put(frame, welcome);
        frame.addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosing(WindowEvent e) {
                JFrame f = (JFrame) e.getSource();
                allFrameOpened.get(f).close(f);
            }
        });
        frame.setLocationRelativeTo(welcomeUI);
        frame.setVisible(true);
    }

    /**
     * 
     * @param welcomeUI
     */
    public void newSimulationFrame(WelcomeUI welcomeUI) {
        JAXXInitialContext context = new JAXXInitialContext();
        context.add(new SimulAction());
        context.add(this);
        SimulUI simulUI = new SimulUI(context);
        openFrame(welcomeUI, simulUI, _("isisfish.simulation.title"));
    }
    
    /**
     * 
     * @param welcomeUI
     */
    public void newResultFrame(WelcomeUI welcomeUI) {
        openFrame(welcomeUI, new ResultUI(), _("isisfish.result.title"));
    }
    
    /**
     * 
     * @param welcomeUI
     */
    public void newInputFrame(WelcomeUI welcomeUI) {
        openFrame(welcomeUI, new InputUI(new JAXXInitialContext().add(verifier).add(new InputAction()).add(new InputSaveVerifier()).add(this)), _("isisfish.input.title"));
    }
    
    /**
     * 
     * @param welcomeUI
     */
    public void newScriptFrame(WelcomeUI welcomeUI) {
        openFrame(welcomeUI, new ScriptUI(), _("isisfish.script.title"));
    }
    
    /**
     * 
     * @param welcomeUI
     */
    public void newSensitivityFrame(WelcomeUI welcomeUI) {
        openFrame(welcomeUI, new SensitivityUI(new JAXXInitialContext().add(new InputAction()).add(new SensitivitySaveVerifier()).add(new SimulAction()).add(this)), _("isisfish.sensitivity.title"));
    }
    
    /**
     * 
     * @param welcomeUI
     */
    public void newQueueFrame(WelcomeUI welcomeUI) {
        openFrame(welcomeUI, new QueueUI(), _("isisfish.queue.title"));
    }

    /**
     * 
     * @param welcomeUI parent ui
     */
    public void close(WelcomeUI welcomeUI) {
        if (verifier.allIsSaved()) {
            welcomeUI.dispose();
        }
    }

    /**
     * 
     * @param welcomeUI parent ui
     */
    public void updateVCS(WelcomeUI welcomeUI) {
        // FIXME a reimplanter
        // thread:Welcome.updateVCS()
    }
    
    /**
     * Show config frame.
     * 
     * @param welcomeUI parent ui
     */
    public void config(WelcomeUI welcomeUI) {
        ConfigUIHelper modelBuilder = new ConfigUIHelper(IsisFish.config);

        // category main
        modelBuilder.addCategory(_("isisfish.config.category.main"), _("isisfish.config.category.main.description"));
        modelBuilder.addOption(IsisConfig.Option.CONFIG_FILE);
        modelBuilder.addOption(IsisConfig.Option.DATABASE_DIRECTORY);
        modelBuilder.addOption(IsisConfig.Option.COMMUNITY_DATABASE_DIRECTORY);
        modelBuilder.addOption(IsisConfig.Option.COMPILATION_DIRECTORY);
        modelBuilder.addOption(IsisConfig.Option.MONITORING_DIRECTORY);
        modelBuilder.addOption(IsisConfig.Option.JAVADOC_DIRECTORY);
        modelBuilder.addOption(IsisConfig.Option.BACKUP_DIRECTORY);
        modelBuilder.addOption(IsisConfig.Option.LOCALE);
        modelBuilder.addOption(IsisConfig.Option.SIMULATION_SHOW_ONLY_ERROR);
        modelBuilder.addOption(IsisConfig.Option.SIMULATION_SCRIPT_AUTOCONFIG);

        // category database vcs
        modelBuilder.addCategory(_("isisfish.config.category.officialvcs"), _("isisfish.config.category.officialvcs.description"));
        modelBuilder.addOption(IsisConfig.Option.VCS_TYPE);
        modelBuilder.addOption(IsisConfig.Option.VCS_PROTOCOL);
        modelBuilder.addOption(IsisConfig.Option.VCS_HOST_NAME);
        modelBuilder.addOption(IsisConfig.Option.VCS_PATH);
        modelBuilder.addOption(IsisConfig.Option.VCS_USER_NAME);
        modelBuilder.addOption(IsisConfig.Option.VCS_USER_PASSWORD);

        // category community vcs
        modelBuilder.addCategory(_("isisfish.config.category.communityvcs"), _("isisfish.config.category.communityvcs.description"));
        modelBuilder.addOption(IsisConfig.Option.VCS_COMMUNITY_TYPE);
        modelBuilder.addOption(IsisConfig.Option.VCS_COMMUNITY_PROTOCOL);
        modelBuilder.addOption(IsisConfig.Option.VCS_COMMUNITY_HOST_NAME);
        modelBuilder.addOption(IsisConfig.Option.VCS_COMMUNITY_PATH);
        modelBuilder.addOption(IsisConfig.Option.VCS_COMMUNITY_USER_NAME);
        modelBuilder.addOption(IsisConfig.Option.VCS_COMMUNITY_PASSWORD);

        // category misc
        modelBuilder.addCategory(_("isisfish.config.category.misc"), _("isisfish.config.category.misc.description"));
        modelBuilder.addOption(IsisConfig.Option.SSH_KEY_FILE);
        modelBuilder.addOption(IsisConfig.Option.USER_NAME);
        modelBuilder.addOption(IsisConfig.Option.SMTP_SERVER);
        modelBuilder.addOption(IsisConfig.Option.USER_MAIL);

        ConfigUI configUI = modelBuilder.buildUI(welcomeUI, _("isisfish.config.category.main"));
        JDialog dialogUI = new JDialog(welcomeUI, _("isisfish.config.title"));
        dialogUI.add(configUI);
        dialogUI.pack();
        dialogUI.setLocationRelativeTo(welcomeUI);
        dialogUI.setVisible(true);
    }

    /**
     * Display VCS config ui.
     * 
     * @param welcomeUI parent ui
     */
    public void configVCS(WelcomeUI welcomeUI) {
        VCSConfigUI vcsConfig = new VCSConfigUI(welcomeUI, welcomeUI);
        vcsConfig.pack();
        vcsConfig.setLocationRelativeTo(welcomeUI);
        vcsConfig.setVisible(true);
    }

    /**
     * Display ssh launcher config ui.
     * 
     * @param welcomeUI parent ui
     */
    public void configurationSSHLauncher(WelcomeUI welcomeUI) {
        SSHLauncherConfigUI configUI = new SSHLauncherConfigUI(welcomeUI, welcomeUI);
        configUI.pack();
        configUI.setSize(600, configUI.getHeight());
        configUI.setLocationRelativeTo(welcomeUI);
        configUI.setVisible(true);
    }

    /**
     * Display R config tester UI.
     * 
     * @param welcomeUI parent ui
     */
    public void configurationR(WelcomeUI welcomeUI) {
        RConfigUI rconfigUI = new RConfigUI(welcomeUI, welcomeUI);
        RConfigHandler handler = rconfigUI.getHandler();
        handler.init(rconfigUI);
        rconfigUI.pack();
        rconfigUI.setLocationRelativeTo(welcomeUI);
        rconfigUI.setVisible(true);
    }

    /**
     * Open url using default system browser.
     * 
     * @param welcomeUI parent ui
     * @param urlOrAlias url alias, or full url
     */
    public void help(WelcomeUI welcomeUI, String urlOrAlias) {
        try {
            String url = URLSALIAS.get(urlOrAlias);

            if (url == null) {
                url = urlOrAlias;
            }

            Desktop.getDesktop().browse(new URL(url).toURI());
        } catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Can't show help", e);
            }
        }
    }

    /**
     * Show about frame from nuiton-widgets.
     * 
     * @param welcomeUI parent ui
     */
    public void about(WelcomeUI welcomeUI) {
       AboutFrame about = new AboutFrame();
       about.setTitle(_("isisfish.about.title"));
       about.setIconPath("images/isislogo.png");
       about.setAboutHtmlText(_("isisfish.about.abouthtmltext", IsisConfig.getVersion()));
       about.setLicenseText(_("isisfish.about.licensetext"));
       about.setBackgroundColor(Color.WHITE);
       about.setSize(640, 520);
       about.setLocationRelativeTo(welcomeUI);
       about.setVisible(true);
    }
}
