/*
 * #%L
 * IsisFish
 * 
 * $Id: TimeStepType.java 3445 2011-07-15 13:12:45Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2002 - 2011 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.types.hibernate;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;

import org.hibernate.HibernateException;
import org.hibernate.type.ImmutableType;

import fr.ifremer.isisfish.types.TimeStep;

/**
 * DateType.java
 *
 * Created: 19 janv. 2006
 *
 * @author Arnaud Thimel <thimel@codelutin.com>
 * @version $Revision: 3445 $
 *
 * Mise a jour: $Date: 2011-07-15 15:12:45 +0200 (ven., 15 juil. 2011) $
 * par : $Author: chatellier $
 */
public class TimeStepType extends ImmutableType {

    /** serialVersionUID. */
    private static final long serialVersionUID = -5295147041590169149L;

    /*
     * @see org.hibernate.type.NullableType#get(java.sql.ResultSet, java.lang.String)
     */
    @Override
    public Object get(ResultSet rs, String name) throws HibernateException,
            SQLException {
        return new TimeStep(rs.getInt(name));
    }

    /*
     * @see org.hibernate.type.NullableType#set(java.sql.PreparedStatement, java.lang.Object, int)
     */
    @Override
    public void set(PreparedStatement st, Object value, int index)
            throws HibernateException, SQLException {
        st.setInt(index, ((TimeStep) value).getStep());
    }

    /*
     * @see org.hibernate.type.NullableType#sqlType()
     */
    @Override
    public int sqlType() {
        return Types.INTEGER;
    }

    /*
     * @see org.hibernate.type.NullableType#toString(java.lang.Object)
     */
    @Override
    public String toString(Object value) throws HibernateException {
        return ((TimeStep)value).toString();
    }

    /*
     * @see org.hibernate.type.NullableType#fromStringValue(java.lang.String)
     */
    @Override
    public Object fromStringValue(String xml) throws HibernateException {
        return new TimeStep(Integer.parseInt(xml));
    }

    /*
     * @see org.hibernate.type.Type#getReturnedClass()
     */
    public Class getReturnedClass() {
        return TimeStep.class;
    }

    /*
     * @see org.hibernate.type.Type#getName()
     */
    public String getName() {
        return TimeStepType.class.getName();
    }

}
