/*
 * #%L
 * IsisFish
 * 
 * $Id: EquationDiscreteDomainXMLVisitor.java 3460 2011-10-06 20:08:09Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.0.0.1/src/main/java/fr/ifremer/isisfish/mexico/xml/EquationDiscreteDomainXMLVisitor.java $
 * %%
 * Copyright (C) 2011 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.mexico.xml;

import org.apache.commons.lang3.StringEscapeUtils;

import fr.ifremer.isisfish.simulator.sensitivity.Domain;

/**
 * XML equation discrete domain visitor.
 *
 * @author chatellier
 * @version $Revision: 3460 $
 * 
 * Last update : $Date: 2011-10-06 22:08:09 +0200 (jeu., 06 oct. 2011) $
 * By : $Author: chatellier $
 */
public class EquationDiscreteDomainXMLVisitor extends DiscreteDomainXMLVisitor {

    /**
     * {@inheritDoc}
     */
    @Override
    public void visit(Domain domain, Object label, Object value) {
        String content = (String)value;
        xmlBuffer.append("<value>");
        xmlBuffer.append(StringEscapeUtils.escapeXml(content));
        xmlBuffer.append("</value>");
    }
}
