/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.mexico.xml;

import fr.ifremer.isisfish.mexico.MexicoHelper;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;

/**
 * XML discrete domain visitor.
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 5 mars 2009 $
 * By : $Author: chatellier $
 */
public class DiscreteDomainXMLVisitor extends DomainXMLVisitor {

    /**
     * {@inheritDoc}
     */
    @Override
    public void start(Domain domain) {
        xmlBuffer.append("<domain>");
        xmlBuffer.append("<fixed>");
        xmlBuffer.append("<enumeration>");
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void visit(Domain domain, Object label, Object value) {
        String stringValue = MexicoHelper.getStringFromObject(value);
        xmlBuffer.append("<value>" + stringValue + "</value>");
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void end(Domain domain) {
        xmlBuffer.append("</enumeration>");
        xmlBuffer.append("</fixed>");
        xmlBuffer.append("</domain>");
    }
}
