/*
 * #%L
 * IsisFish
 * 
 * $Id: PopulationReproductionRateEquation.java 3428 2011-06-22 14:47:43Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.0.0.1/src/main/java/fr/ifremer/isisfish/equation/PopulationReproductionRateEquation.java $
 * %%
 * Copyright (C) 2011 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.equation;

import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.Args;

/**
 * Population's reproduction rate equation.
 *
 * Created: 23 août 2006 11:11:40
 *
 * @author poussin
 * @version $Revision: 3428 $
 *
 * Last update: $Date: 2011-06-22 16:47:43 +0200 (mer., 22 juin 2011) $
 * by : $Author: chatellier $
 */
public interface PopulationReproductionRateEquation {

    /**
     * Compute reproduction rate.
     * 
     * @param context simulation context
     * @param group le groupe dont on souhaite avoir le taux de reproduction
     * @return le taux de reproduction pour le groupe
     * @throws Exception 
     */
    @Args({"context", "group"})
    public double compute(SimulationContext context, PopulationGroup group) throws Exception;

}
