/*
 * #%L
 * IsisFish
 * 
 * $Id: PopulationCapturabilityEquation.java 3499 2011-10-28 12:18:03Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.0.0.1/src/main/java/fr/ifremer/isisfish/equation/PopulationCapturabilityEquation.java $
 * %%
 * Copyright (C) 2006 - 2011 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.equation;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.ArgTypes;
import fr.ifremer.isisfish.util.Args;

/**
 * Population capturability equation.
 *
 * Created: 23 août 2006 11:11:40
 *
 * @author poussin
 * @version $Revision: 3499 $
 *
 * Last update: $Date: 2011-10-28 14:18:03 +0200 (ven., 28 oct. 2011) $
 * by : $Author: echatellier $
 */
public interface PopulationCapturabilityEquation {

    /**
     * Compute capturability equation.
     * 
     * @param context simulation context
     * @param pop population pour lequel on souhaite la matrice de reproduction
     * @param group le group de la population
     * @param season la saison de la population
     * 
     * @return la valeur retournée n'est pas utilisée, par exemple 'return 0;'
     * convient.
     * @throws Exception 
     */
    @Args({"context", "pop", "group", "season"})
    @ArgTypes({
        "fr.ifremer.isisfish.simulator.SimulationContext",
        "fr.ifremer.isisfish.entities.Population", 
        "fr.ifremer.isisfish.entities.PopulationGroup", 
        "fr.ifremer.isisfish.entities.PopulationSeasonInfo"})
    public double compute(SimulationContext context, Population pop,
            PopulationGroup group, PopulationSeasonInfo season) throws Exception;

}
