/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper.IsisFishEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class TargetSpeciesDAOAbstract<E extends TargetSpecies> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)TargetSpecies.class;
    }

    @Override
    public IsisFishEntityEnum getTopiaEntityEnum() {
        return IsisFishEntityEnum.TargetSpecies;
    }

    public E findByTargetFactorEquation(Equation v) throws TopiaException {
        E result = findByProperty(TargetSpecies.PROPERTY_TARGET_FACTOR_EQUATION, v);
        return result;
    }

    public List<E> findAllByTargetFactorEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(TargetSpecies.PROPERTY_TARGET_FACTOR_EQUATION, v);
        return result;
    }

    public E findByPrimaryCatch(boolean v) throws TopiaException {
        E result = findByProperty(TargetSpecies.PROPERTY_PRIMARY_CATCH, v);
        return result;
    }

    public List<E> findAllByPrimaryCatch(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(TargetSpecies.PROPERTY_PRIMARY_CATCH, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //TargetSpeciesDAOAbstract<E extends TargetSpecies>
