/*
 * #%L
 * IsisFish
 * 
 * $Id: StrategyMonthInfoImpl.java 3465 2011-10-10 15:29:46Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2006 - 2011 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.entities;

import static org.nuiton.i18n.I18n._;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.StorageException;

/**
 * StrategyMonthInfoImpl.
 *
 * Created: 29 août 06 11:30:27
 *
 * @author poussin
 * @version $Revision: 3465 $
 *
 * Last update: $Date: 2011-10-10 17:29:46 +0200 (lun., 10 oct. 2011) $
 * by : $Author: chatellier $
 */
public class StrategyMonthInfoImpl extends StrategyMonthInfoAbstract {

    /** serialVersionUID. */
    private static final long serialVersionUID = 4266095355294103240L;

    /** Class logger. */
    private static Log log = LogFactory.getLog(StrategyMonthInfoImpl.class);

    public FisheryRegion getFisheryRegion() {
        try {
            FisheryRegion result = RegionStorage
                    .getFisheryRegion(getTopiaContext());
            return result;
        } catch (StorageException eee) {
            throw new IsisFishRuntimeException("Can't get fishery region", eee);
        }
    }

    public double getProportionMetier(Metier metier) {
        double result = 0;
        // on prend le super car ca ne sert a rien de mettre a jour,
        // se le metier n'y ait pas on renvera 0;
        MatrixND mat = super.getProportionMetier();
        if (mat != null) {
            int indice = mat.getSemantic(0).indexOf(metier);
            if (indice >= 0) {
                result = mat.getValue(indice);
            }
        }
        return result;
    }

    public void setProportionMetier(Metier metier, double value) {
        MatrixND mat = getProportionMetier();
        if (mat != null) {
            mat = mat.copy();
            mat.setValue(metier, value);
            setProportionMetier(mat);
        } else {
            log.warn("Can't set proportion of metier, not enough information available");
        }
    }

    @Override
    public MatrixND getProportionMetier() {
        if (getStrategy() == null || getStrategy().getSetOfVessels() == null
                || getStrategy().getSetOfVessels().getPossibleMetiers() == null) {
            return null;
        }

        Collection<EffortDescription> efforts = getStrategy().getSetOfVessels()
                .getPossibleMetiers();

        List<Metier> metiers = new ArrayList<Metier>(efforts.size());
        for (EffortDescription effort : efforts) {
            metiers.add(effort.getPossibleMetiers());
        }

        if (metiers.size() <= 0) {
            return null;
        }

        MatrixND result = super.getProportionMetier();

        if (result == null) {
            result = MatrixFactory.getInstance().create(
                    _("isisfish.strategyMonthInfo.proportion"),
                    new List[] { metiers },
                    new String[] { _("isisfish.strategyMonthInfo.metier") });
        } else if (!result.getSemantic(0).equals(metiers)) {
            MatrixND tmp = MatrixFactory.getInstance().create(
                    _("isisfish.strategyMonthInfo.proportion"),
                    new List[] { metiers },
                    new String[] { _("isisfish.strategyMonthInfo.metier") });
            tmp.pasteSemantics(result);
            result = tmp;
        }

        return result;
    }

    /*
     * @see fr.ifremer.isisfish.entities.StrategyMonthInfoAbstract#setTripType(fr.ifremer.isisfish.entities.TripType)
     */
    @Override
    public void setTripType(TripType value) {
        super.setTripType(value);
        computeNumberOfTrips();
    }

    /*
     * @see fr.ifremer.isisfish.entities.StrategyMonthInfoAbstract#setMinInactivityDays(int)
     */
    @Override
    public void setMinInactivityDays(double value) {
        super.setMinInactivityDays(value);
        computeNumberOfTrips();
    }

    public void computeNumberOfTrips() {
        TripType tripType = getTripType();
        // remplace un simple getMinInactivityDays(), pour pouvoir utiliser une
        // equation si besoin (tout est pret, il ne manque que l'interface
        // graphique pour saisir l'equation dans strategie
        double inactivity = getStrategy().getInactivityDays(getMonth());
        if (tripType != null && tripType.getTripDuration() != null
                && inactivity >= 0) {
            int nbDayMonth = getMonth().getNumbersOfDays();
            double result = (nbDayMonth - inactivity)
                    / tripType.getTripDuration().getDay();
            setNumberOfTrips(result);
        }
    }

    /*
     * @see fr.ifremer.isisfish.entities.FisheryRegionAbstract#toString()
     */
    @Override
    public String toString() {
        String result = _("isisfish.strategyMonthInfo.toString", this
                .getStrategy(), this.getMonth());
        return result;
    }

}
