/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper.IsisFishEntityEnum;
import fr.ifremer.isisfish.types.TimeStep;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class ResultDAOAbstract<E extends Result> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Result.class;
    }

    @Override
    public IsisFishEntityEnum getTopiaEntityEnum() {
        return IsisFishEntityEnum.Result;
    }

    public E findByResultStep(TimeStep v) throws TopiaException {
        E result = findByProperty(Result.PROPERTY_RESULT_STEP, v);
        return result;
    }

    public List<E> findAllByResultStep(TimeStep v) throws TopiaException {
        List<E> result = findAllByProperty(Result.PROPERTY_RESULT_STEP, v);
        return result;
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Result.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Result.PROPERTY_NAME, v);
        return result;
    }

    public E findByMatrix(MatrixND v) throws TopiaException {
        E result = findByProperty(Result.PROPERTY_MATRIX, v);
        return result;
    }

    public List<E> findAllByMatrix(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty(Result.PROPERTY_MATRIX, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //ResultDAOAbstract<E extends Result>
