/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.TimeStep;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class ResultAbstract extends TopiaEntityAbstract implements Result {

    /**
     * Nom de l'attribut en BD : resultStep
     */
    protected TimeStep resultStep;

    /**
     * <p>Contient la description associ&eacute; &agrave; un type.</p>
     * 
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * <p>contient les matrices associ&eacute;es &agrave; chaque type de r&eacute;sultat. La cle est un type et la valeur une matrice</p>
     * 
     * Nom de l'attribut en BD : matrix
     */
    protected MatrixND matrix;

    private static final long serialVersionUID = 7149517414326231649L;

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Result.class).update(this);
}

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Result.class).delete(this);
}

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_RESULT_STEP, TimeStep.class, resultStep);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_MATRIX, MatrixND.class, matrix);
        visitor.end(this);
    }

    @Override
    public void setResultStep(TimeStep resultStep) {
        TimeStep oldValue = this.resultStep;
        fireOnPreWrite(PROPERTY_RESULT_STEP, oldValue, resultStep);
        this.resultStep = resultStep;
        fireOnPostWrite(PROPERTY_RESULT_STEP, oldValue, resultStep);
    }

    @Override
    public TimeStep getResultStep() {
        fireOnPreRead(PROPERTY_RESULT_STEP, resultStep);
        TimeStep result = this.resultStep;
        fireOnPostRead(PROPERTY_RESULT_STEP, resultStep);
        return result;
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
    }

    @Override
    public void setMatrix(MatrixND matrix) {
        MatrixND oldValue = this.matrix;
        fireOnPreWrite(PROPERTY_MATRIX, oldValue, matrix);
        this.matrix = matrix;
        fireOnPostWrite(PROPERTY_MATRIX, oldValue, matrix);
    }

    @Override
    public MatrixND getMatrix() {
        fireOnPreRead(PROPERTY_MATRIX, matrix);
        MatrixND result = this.matrix;
        fireOnPostRead(PROPERTY_MATRIX, matrix);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_RESULT_STEP, this.resultStep).
            append(PROPERTY_NAME, this.name).
            append(PROPERTY_MATRIX, this.matrix).
         toString();
        return result;
    }

} //ResultAbstract
