/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class CellAbstract extends TopiaEntityAbstract implements Cell {

    /**
     * <p>Repr&eacute;sente le plus petit &eacute;l&eacute;ment g&eacute;ographique de la r&eacute;gion. Plusieurs Mesh compos&eacute; constitues une Zone.</p>
     * 
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * <p>Repr&eacute;sente le plus petit &eacute;l&eacute;ment g&eacute;ographique de la r&eacute;gion. Plusieurs Mesh compos&eacute; constitues une Zone.</p>
     * 
     * Nom de l'attribut en BD : latitude
     */
    protected float latitude;

    /**
     * <p>Repr&eacute;sente le plus petit &eacute;l&eacute;ment g&eacute;ographique de la r&eacute;gion. Plusieurs Mesh compos&eacute; constitues une Zone.</p>
     * 
     * Nom de l'attribut en BD : longitude
     */
    protected float longitude;

    /**
     * <p>Repr&eacute;sente le plus petit &eacute;l&eacute;ment g&eacute;ographique de la r&eacute;gion. Plusieurs Mesh compos&eacute; constitues une Zone.</p>
     * 
     * Nom de l'attribut en BD : land
     */
    protected boolean land;

    /**
     * <p>Repr&eacute;sente le plus petit &eacute;l&eacute;ment g&eacute;ographique de la r&eacute;gion. Plusieurs Mesh compos&eacute; constitues une Zone.</p>
     * 
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    private static final long serialVersionUID = 7291386497664627507L;

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Cell.class).update(this);
}

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Cell.class).delete(this);
}

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_LATITUDE, float.class, latitude);
        visitor.visit(this, PROPERTY_LONGITUDE, float.class, longitude);
        visitor.visit(this, PROPERTY_LAND, boolean.class, land);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.end(this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
    }

    @Override
    public void setLatitude(float latitude) {
        float oldValue = this.latitude;
        fireOnPreWrite(PROPERTY_LATITUDE, oldValue, latitude);
        this.latitude = latitude;
        fireOnPostWrite(PROPERTY_LATITUDE, oldValue, latitude);
    }

    @Override
    public float getLatitude() {
        fireOnPreRead(PROPERTY_LATITUDE, latitude);
        float result = this.latitude;
        fireOnPostRead(PROPERTY_LATITUDE, latitude);
        return result;
    }

    @Override
    public void setLongitude(float longitude) {
        float oldValue = this.longitude;
        fireOnPreWrite(PROPERTY_LONGITUDE, oldValue, longitude);
        this.longitude = longitude;
        fireOnPostWrite(PROPERTY_LONGITUDE, oldValue, longitude);
    }

    @Override
    public float getLongitude() {
        fireOnPreRead(PROPERTY_LONGITUDE, longitude);
        float result = this.longitude;
        fireOnPostRead(PROPERTY_LONGITUDE, longitude);
        return result;
    }

    @Override
    public void setLand(boolean land) {
        boolean oldValue = this.land;
        fireOnPreWrite(PROPERTY_LAND, oldValue, land);
        this.land = land;
        fireOnPostWrite(PROPERTY_LAND, oldValue, land);
    }

    @Override
    public boolean isLand() {
        fireOnPreRead(PROPERTY_LAND, land);
        boolean result = this.land;
        fireOnPostRead(PROPERTY_LAND, land);
        return result;
    }

    @Override
    public boolean getLand() {
        fireOnPreRead(PROPERTY_LAND, land);
        boolean result = this.land;
        fireOnPostRead(PROPERTY_LAND, land);
        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        fireOnPreWrite(PROPERTY_COMMENT, oldValue, comment);
        this.comment = comment;
        fireOnPostWrite(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public String getComment() {
        fireOnPreRead(PROPERTY_COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(PROPERTY_COMMENT, comment);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NAME, this.name).
            append(PROPERTY_LATITUDE, this.latitude).
            append(PROPERTY_LONGITUDE, this.longitude).
            append(PROPERTY_LAND, this.land).
            append(PROPERTY_COMMENT, this.comment).
         toString();
        return result;
    }

} //CellAbstract
