/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.vcs;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.vcs.VCS;
import fr.ifremer.isisfish.vcs.VCSNone;
import fr.ifremer.isisfish.vcs.VCSSVN;
import java.io.File;
import java.util.Properties;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class VCSFactory {
    private static Log log = LogFactory.getLog(VCSFactory.class);
    protected static final Properties TYPE_ALIASES = new Properties();

    private VCSFactory() {
    }

    public static VCS createVCS(IsisConfig config) {
        String type = config.getOption("vcs.type");
        String classname = TYPE_ALIASES.getProperty(type, type);
        File dataDir = config.getDatabaseDirectory();
        String protocol = config.getOption("vcs.protocol");
        String host = config.getOption("vcs.hostName");
        String path = config.getOption("vcs.path");
        File sshKeyFile = config.getSSHPrivateKeyFilePath();
        String login = config.getOption("vcs.username");
        String password = config.getOption("vcs.password");
        VCS result = VCSFactory.makeVCSInstance(classname, dataDir, protocol, host, path, sshKeyFile, login, password);
        return result;
    }

    public static VCS createPublicVCS(IsisConfig config) {
        String type = config.getOption(IsisConfig.Option.VCS_COMMUNITY_TYPE.key);
        String classname = TYPE_ALIASES.getProperty(type, type);
        File dataDir = config.getCommunityDatabaseDirectory();
        String protocol = config.getOption(IsisConfig.Option.VCS_COMMUNITY_PROTOCOL.key);
        String host = config.getOption(IsisConfig.Option.VCS_COMMUNITY_HOST_NAME.key);
        String path = config.getOption(IsisConfig.Option.VCS_COMMUNITY_PATH.key);
        File sshKeyFile = config.getSSHPrivateKeyFilePath();
        String login = config.getOption(IsisConfig.Option.VCS_COMMUNITY_USER_NAME.key);
        String password = config.getOption(IsisConfig.Option.VCS_COMMUNITY_PASSWORD.key);
        VCS result = VCSFactory.makeVCSInstance(classname, dataDir, protocol, host, path, sshKeyFile, login, password);
        return result;
    }

    protected static VCS makeVCSInstance(String classname, File dataDir, String protocol, String host, String path, File sshKeyFile, String login, String password) {
        VCS result = null;
        try {
            Class clazz = (Class)ConvertUtils.convert((String)classname, Class.class);
            result = (VCS)ConstructorUtils.invokeConstructor((Class)clazz, (Object[])new Object[]{dataDir, protocol, host, path, sshKeyFile, login, password});
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n._((String)"isisfish.vcs.factory.cantinstanciate", (Object[])new Object[]{classname}), (Throwable)eee);
            }
            result = new VCSNone(dataDir, protocol, host, path, sshKeyFile, login, password);
        }
        return result;
    }

    static {
        TYPE_ALIASES.setProperty("", VCSNone.class.getName());
        TYPE_ALIASES.setProperty("none", VCSNone.class.getName());
        TYPE_ALIASES.setProperty("svn", VCSSVN.class.getName());
    }
}

