/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXComboBox;
import org.jdesktop.swingx.JXTextField;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;

public class FilterableComboBox
extends JPanel {
    private static final long serialVersionUID = -6669320998140538372L;
    protected JComboBox dataBox;
    protected JTextField filterField;
    protected JButton resetButton;
    protected FilterComboBoxModel filterModel;
    protected List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    protected boolean filtering = false;

    public FilterableComboBox() {
        this.buildLayout();
    }

    public FilterableComboBox(ComboBoxModel model) {
        this();
        this.setModel(model);
    }

    private void buildLayout() {
        this.dataBox = new JXComboBox();
        this.dataBox.addActionListener(new ComboBoxActionListener());
        this.filterField = new JXTextField(I18n._((String)"isisfish.common.filter", (Object[])new Object[0]));
        this.filterField.setPreferredSize(new Dimension(200, 0));
        this.resetButton = new JButton(Resource.getIcon((String)"/icons/cancel.png"));
        this.resetButton.addActionListener(new FilterActionListener());
        this.resetButton.setEnabled(false);
        this.filterField.getDocument().addDocumentListener(new FilterDocumentListener());
        this.setLayout(new BorderLayout());
        this.add((Component)this.dataBox, "Center");
        JPanel filterPanel = new JPanel(new BorderLayout());
        filterPanel.add((Component)this.filterField, "Center");
        filterPanel.add((Component)this.resetButton, "East");
        this.add((Component)filterPanel, "East");
    }

    public void setModel(ComboBoxModel model) {
        this.dataBox.setModel(new FilterComboBoxModel(model));
    }

    public Object getSelectedItem() {
        return this.dataBox.getSelectedItem();
    }

    public void setSelectedItem(Object object) {
        this.dataBox.setSelectedItem(object);
    }

    public boolean addActionListener(ActionListener e) {
        return this.actionListeners.add(e);
    }

    public boolean removeActionListener(ActionListener o) {
        return this.actionListeners.remove(o);
    }

    class ComboBoxActionListener
    implements ActionListener {
        ComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!FilterableComboBox.this.filtering) {
                for (ActionListener a : FilterableComboBox.this.actionListeners) {
                    a.actionPerformed(e);
                }
            }
        }
    }

    class FilterActionListener
    implements ActionListener {
        FilterActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterableComboBox.this.filterField.setText("");
        }
    }

    class FilterDocumentListener
    implements DocumentListener {
        FilterDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateFilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateFilter();
        }

        protected void updateFilter() {
            ((FilterComboBoxModel)FilterableComboBox.this.dataBox.getModel()).fireDataChanged();
            FilterableComboBox.this.resetButton.setEnabled(!FilterableComboBox.this.filterField.getText().isEmpty());
        }
    }

    class FilterComboBoxModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = 6256289874593024153L;
        protected ComboBoxModel model;

        public FilterComboBoxModel(ComboBoxModel model) {
            this.model = model;
        }

        @Override
        public int getSize() {
            int delegateSize = this.model.getSize();
            int realSize = 0;
            for (int i = 0; i < delegateSize; ++i) {
                if (!this.model.getElementAt(i).toString().matches(".*" + FilterableComboBox.this.filterField.getText() + ".*")) continue;
                ++realSize;
            }
            return realSize;
        }

        @Override
        public Object getElementAt(int index) {
            int delegateSize = this.model.getSize();
            int realIndex = -1;
            for (int i = 0; i < delegateSize; ++i) {
                Object element = this.model.getElementAt(i);
                if (element.toString().matches(".*" + FilterableComboBox.this.filterField.getText() + ".*")) {
                    ++realIndex;
                }
                if (index != realIndex) continue;
                return element;
            }
            return null;
        }

        public void fireDataChanged() {
            FilterableComboBox.this.filtering = true;
            super.fireContentsChanged(this, 0, this.model.getSize());
            FilterableComboBox.this.filtering = false;
        }
    }
}

