/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.ScriptStorage;
import fr.ifremer.isisfish.datastore.SensitivityAnalysisStorage;
import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.datastore.SimulationPlanStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.datastore.SimulatorStorage;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.mexico.MexicoHelper;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationParameterImpl;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulatorLauncher;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityAnalysis;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityException;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationDiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.MatrixContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.RuleDiscreteDomain;
import fr.ifremer.isisfish.ui.SimulationUI;
import fr.ifremer.isisfish.ui.sensitivity.FactorWizardUI;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityChooserUI;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityInputHandler;
import fr.ifremer.isisfish.ui.simulator.ParamsUI;
import fr.ifremer.isisfish.ui.simulator.RuleChooser;
import fr.ifremer.isisfish.ui.simulator.SensUI;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import fr.ifremer.isisfish.ui.widget.editor.ScriptParameterDialog;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.topia.TopiaContext;

public class SimulAction {
    private static Log log = LogFactory.getLog(SimulAction.class);
    private static final SimpleDateFormat DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
    protected SimulationParameter param = null;
    protected RegionStorage regionStorage = null;
    protected SimulationStorage simulStorage = null;
    protected List<String> oldSimulNames = null;
    protected String simulName = null;
    protected SensitivityAnalysisStorage sensitivityStorage = null;
    protected FactorGroup factorGroup = new FactorGroup(null);

    public SimulAction() {
        this.init();
    }

    public void init() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Init ");
        }
        try {
            this.param = new SimulationParameterImpl();
            List<String> resultNames = this.getResultNames();
            this.param.setSimulatorName(IsisFish.config.getSimulatorClassfile());
            this.param.setTagValue(IsisFish.config.getDefaultTagValueAsMap());
            this.param.setExportNames(IsisFish.config.getDefaultExportNamesAsList());
            List<String> defaultResultNames = IsisFish.config.getDefaultResultNamesAsList();
            if (defaultResultNames != null) {
                this.param.setResultEnabled(defaultResultNames);
            } else {
                this.param.setResultEnabled(resultNames);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't init SimulationParameter", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.initsimulaction", (Object[])new Object[0]), eee);
        }
    }

    protected void setName(String name) {
        this.simulName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importSimulation(File f) {
        FileInputStream fos = null;
        try {
            fos = new FileInputStream(f);
            Properties proper = new Properties();
            proper.load(fos);
            this.param.fromProperties(proper);
        }
        catch (Exception e) {
            try {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't import simulation", (Throwable)e);
                }
                ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.importparameter", (Object[])new Object[0]), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fos);
        }
        IOUtils.closeQuietly((InputStream)fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSimulation(File f) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            this.param.toProperties().store(fos, this.simulName);
        }
        catch (Exception e) {
            try {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't save simulation", (Throwable)e);
                }
                ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.savesimulation", (Object[])new Object[0]), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fos);
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    protected List<String> getResultNames() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Field[] fields;
            ScriptStorage storage = ScriptStorage.getScript("ResultName.java");
            Class<?> resultNameClass = storage.getCodeClass();
            for (Field f : fields = resultNameClass.getFields()) {
                String fieldName = (String)f.get(null);
                result.add(fieldName);
            }
        }
        catch (Exception eee) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Can't find result name script", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.getresultname", (Object[])new Object[0]), eee);
        }
        return result;
    }

    public void regionChange(ParamsUI paramsUI, String regionName) {
        this.regionStorage = RegionStorage.getRegion(regionName);
        paramsUI.getParentContainer(SimulationUI.class).setContextValue(this.regionStorage);
        paramsUI.getParentContainer(SimulationUI.class).setRegionStorage(this.regionStorage);
        this.param.setRegionName(regionName);
    }

    public void loadOldSimulation(String simulName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("call loadOldSimulation: " + simulName));
        }
        try {
            this.simulName = simulName;
            this.simulStorage = SimulationStorage.getSimulation(simulName);
            this.param = this.simulStorage.getParameter().copy();
            this.param.setSimulationPlanNumber(-1);
            this.regionStorage = this.param.getRegion();
            this.factorGroup.clearFactors();
            File f = SimulationStorage.getMexicoDesignPlan(SimulationStorage.getSimulationDirectory(simulName));
            if (f != null && f.canRead()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Import design plan from : " + f.getAbsolutePath()));
                }
                TopiaContext topiaContext = this.regionStorage.getStorage();
                DesignPlan designPlan = MexicoHelper.getDesignPlanFromXML(f, topiaContext);
                for (Factor factor : designPlan.getFactors()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Find factor : " + factor.getName()));
                    }
                    this.factorGroup = designPlan.getFactorGroup();
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)"No xml design plan file found");
            }
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.simulation.loadoldsimulation", (Object[])new Object[0]), eee);
        }
    }

    public void preRemoveRule(int ruleIndex) {
        this.preRemoveRule(this.factorGroup, ruleIndex);
    }

    protected void preRemoveRule(FactorGroup factorGroup, int ruleIndex) {
        ArrayList<Factor> factorCopy = new ArrayList<Factor>(factorGroup.getFactors());
        for (Factor factor : factorCopy) {
            if (factor instanceof FactorGroup) {
                this.preRemoveRule((FactorGroup)factor, ruleIndex);
                continue;
            }
            Pattern factorPathPattern = Pattern.compile("^(parameters\\.rule\\.)(\\d+)(.*)$");
            Matcher factorPathMatcher = factorPathPattern.matcher(factor.getPath());
            if (!factorPathMatcher.find()) continue;
            Integer index = Integer.parseInt(factorPathMatcher.group(2));
            if (index == ruleIndex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing factor for index " + ruleIndex + " : " + factor.getPath()));
                }
                factorGroup.remove(factor);
                continue;
            }
            if (index <= ruleIndex) continue;
            String factorPath = factorPathMatcher.group(1) + String.valueOf(index - 1) + factorPathMatcher.group(3);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Renammed factor for index " + ruleIndex + " : " + factor.getPath()));
            }
            factor.setPath(factorPath);
        }
    }

    public List<Strategy> getStrategies() {
        ArrayList<Strategy> result = new ArrayList();
        try {
            TopiaContext tx = this.param.getRegion().getStorage().beginTransaction();
            result = RegionStorage.getFisheryRegion(tx).getStrategy();
            tx.rollbackTransaction();
            tx.closeContext();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get strategies", (Throwable)e);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.liststrategies", (Object[])new Object[0]), e);
        }
        return result;
    }

    public void setStrategies(Object[] strategies) {
        ArrayList<Strategy> result = new ArrayList<Strategy>();
        for (Object o : strategies) {
            result.add((Strategy)o);
        }
        this.param.setStrategies(result);
    }

    public List<Population> getPopulations() {
        ArrayList<Population> result = new ArrayList<Population>();
        try {
            TopiaContext tx = this.param.getRegion().getStorage().beginTransaction();
            List<Species> species = RegionStorage.getFisheryRegion(tx).getSpecies();
            for (Species s : species) {
                Collection<Population> populations = s.getPopulation();
                for (Population p : populations) {
                    p.getPopulationGroup().size();
                    p.getPopulationZone().size();
                }
                result.addAll(populations);
            }
            tx.rollbackTransaction();
            tx.closeContext();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get population", (Throwable)e);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.listpopulation", (Object[])new Object[0]), e);
        }
        return result;
    }

    public void setPopulations(Object[] populations) {
        ArrayList<Population> result = new ArrayList<Population>();
        for (Object o : populations) {
            result.add((Population)o);
        }
        this.param.setPopulations(result);
    }

    public int getNumberOfYear() {
        return this.param.getNumberOfYear();
    }

    public void setNumberOfYear(String years) {
        try {
            this.param.setNumberOfYear(Integer.parseInt(years));
        }
        catch (NumberFormatException ex) {
            this.param.setNumberOfYear(1);
        }
    }

    public List<String> getSimulatorNames() {
        return SimulatorStorage.getSimulatorNames();
    }

    public List<String> getOldSimulationItem() {
        this.oldSimulNames = new ArrayList<String>();
        this.oldSimulNames.addAll(SimulationStorage.getSimulationNames());
        this.oldSimulNames.add(0, " ");
        return this.oldSimulNames;
    }

    public List<String> getFilteredOldSimulatorNames(boolean force) {
        if (this.oldSimulNames == null || force) {
            this.oldSimulNames = this.getOldSimulationItem();
        }
        return this.oldSimulNames;
    }

    public void setOldSimulatorNames(List<String> sn) {
        this.oldSimulNames = sn;
    }

    public void resetOldSimulatorNames() {
        this.oldSimulNames = this.getOldSimulationItem();
    }

    public void addTagValue(String tag, String value) {
        this.param.getTagValue().put(tag, value);
    }

    public void removeTagValue(String tag) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeTagValue: " + tag));
        }
        this.param.getTagValue().remove(tag);
    }

    public void saveTagValue(String simulatorName) {
        Map<String, String> tagValues = this.param.getTagValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("call saveTagValue: " + tagValues));
        }
        IsisFish.config.setDefaultTagValues(tagValues);
        IsisFish.config.setSimulatorClassfile(simulatorName);
    }

    public List<String> getExportNames() {
        ArrayList<String> result = new ArrayList<String>();
        List<String> exportNames = ExportStorage.getExportNames();
        for (String export : exportNames) {
            result.add(export);
        }
        return result;
    }

    public void saveExport() {
        if (this.param.getExportNames() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set exports in configuration : " + this.param.getExportNames()));
            }
            IsisFish.config.setDefaultExportNames(this.param.getExportNames());
        }
    }

    public void saveParametersResultNames(Object[] resultNames) {
        ArrayList<String> resultNamesString = new ArrayList<String>();
        for (Object o : resultNames) {
            resultNamesString.add(o.toString());
        }
        this.param.setResultEnabled(resultNamesString);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set simulation result names : " + resultNamesString));
        }
    }

    public void saveConfigurationResultNames(Object[] resultNames) {
        ArrayList<String> resultNamesString = new ArrayList<String>();
        for (Object o : resultNames) {
            resultNamesString.add(o.toString());
        }
        IsisFish.config.setDefaultResultNames(resultNamesString);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set configuration result names : " + resultNamesString));
        }
    }

    public List<String> getDefaultResultNames() {
        return IsisFish.config.getDefaultResultNamesAsList();
    }

    public List<String> getSimulationPlanNames() {
        return SimulationPlanStorage.getSimulationPlanNames();
    }

    public List<SimulationPlan> getParamSimulationPlans() {
        return this.param.getSimulationPlans();
    }

    public void addSimulationPlan(SensUI sensUI, String name) {
        try {
            SimulationPlan sp = SimulationPlanStorage.getSimulationPlan(name).getNewSimulationPlanInstance();
            sp = (SimulationPlan)ScriptParameterDialog.displayConfigurationFrame((JAXXContext)sensUI, sp);
            if (sp != null) {
                this.getSimulationParameter().addSimulationPlan(sp);
            }
        }
        catch (IsisFishException ex) {
            throw new IsisFishRuntimeException("Can't add simulation plan", ex);
        }
    }

    public void removeSimulationPlan(SimulationPlan sp) {
        this.getSimulationParameter().removeSimulationPlan(sp);
    }

    public void clearSimulationPlans() {
        this.getSimulationParameter().clearPlans();
    }

    public Map<String, Class<?>> getSimulationPlanParameterName(SimulationPlan sp) {
        Map<String, Class<?>> result = null;
        if (sp != null) {
            result = SimulationPlanStorage.getParameterNames(sp);
        }
        return result;
    }

    public Object getSimulationPlanParameterValue(String paramName, SimulationPlan sp) {
        Object result = null;
        if (sp != null) {
            try {
                result = SimulationPlanStorage.getParameterValue(sp, paramName);
            }
            catch (IsisFishException ex) {
                throw new IsisFishRuntimeException("Can't get simulation plan param value", ex);
            }
        }
        return result;
    }

    public void setSimulationPlanParameterValue(String paramName, SimulationPlan sp, Object value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("paramName : " + paramName + " simulationPlanName : " + sp + " value : " + value));
        }
        try {
            SimulationPlanStorage.setParameterValue(sp, paramName, value);
        }
        catch (IsisFishException ex) {
            throw new IsisFishRuntimeException("Can't set simulation plan param value", ex);
        }
    }

    public List<String> getSensitivityExportNames() {
        ArrayList<String> result = new ArrayList<String>();
        List<String> exportNames = SensitivityExportStorage.getSensitivityExportNames();
        for (String export : exportNames) {
            result.add(export);
        }
        return result;
    }

    public List<SensitivityExport> getSensitivityExports() {
        List<SensitivityExport> result = this.param.getSensitivityExport();
        return result;
    }

    public void addSensitivityExport(SensitivityChooserUI sensitivityChooserUI, String name) {
        block3: {
            try {
                SensitivityExportStorage storage = SensitivityExportStorage.getSensitivityExport(name);
                SensitivityExport sensitivityExport = storage.getNewSensitivityExportInstance();
                sensitivityExport = (SensitivityExport)ScriptParameterDialog.displayConfigurationFrame((JAXXContext)sensitivityChooserUI, sensitivityExport);
                if (sensitivityExport != null) {
                    this.param.getSensitivityExport().add(sensitivityExport);
                }
            }
            catch (IsisFishException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't add sensitivity export", (Throwable)e);
            }
        }
    }

    public void removeSensitivityExport(SensitivityExport export) {
        this.param.getSensitivityExport().remove(export);
    }

    public void clearSensitivityExport() {
        this.param.getSensitivityExport().clear();
    }

    public Map<String, Class<?>> getSensitivityExportParameterNames(SensitivityExport export) {
        return SensitivityExportStorage.getParameterNames(export);
    }

    public void setSensitivityExportParameterValue(Export export, String paramName, Object value) {
        block3: {
            if (value != null) {
                try {
                    SensitivityExportStorage.setParameterValue(export, paramName, value);
                }
                catch (IsisFishException e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"Can't set sensitivity export param value", (Throwable)e);
                }
            }
        }
    }

    public Object getSensitivityExportParameterValue(SensitivityExport sensitivityExport, String paramName) {
        Object result;
        block2: {
            result = null;
            try {
                result = SensitivityExportStorage.getParameterValue(sensitivityExport, paramName);
            }
            catch (IsisFishException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't get sensitivity export param value", (Throwable)e);
            }
        }
        return result;
    }

    public List<String> getSensitivityAnalysisNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String r : SensitivityAnalysisStorage.getSensitivityAnalysisNames()) {
            if (!r.endsWith(".java")) continue;
            result.add(r.substring(0, r.length() - 5));
        }
        return result;
    }

    public SensitivityAnalysis getSensitivityAnalysis() {
        return this.param.getSensitivityAnalysis();
    }

    public SensitivityAnalysis getSensitivityAnalysisInstance(String name) {
        SensitivityAnalysis sensitivityAnalysis;
        block2: {
            sensitivityAnalysis = null;
            try {
                this.sensitivityStorage = SensitivityAnalysisStorage.getSensitivityAnalysis(name);
                sensitivityAnalysis = this.sensitivityStorage.getNewSensitivityAnalysisInstance();
            }
            catch (IsisFishException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't set sensitivity analysis", (Throwable)e);
            }
        }
        return sensitivityAnalysis;
    }

    public void setSensitivityAnalysis(SensitivityAnalysis sensitivityAnalysis) {
        this.param.setSensitivityAnalysis(sensitivityAnalysis);
    }

    public FactorGroup getFactorGroup() {
        return this.factorGroup;
    }

    public Factor getFactor(String factorPath) {
        return this.getFactor(this.factorGroup, factorPath);
    }

    protected Factor getFactor(FactorGroup factorGroup, String factorPath) {
        Factor result = null;
        for (Factor factor : factorGroup.getFactors()) {
            if (factor instanceof FactorGroup) {
                result = this.getFactor((FactorGroup)factor, factorPath);
            }
            if (!factorPath.equals(factor.getPath())) continue;
            result = factor;
        }
        return result;
    }

    public void removeFactor(String factorPath) {
        this.removeFactor(this.factorGroup, factorPath);
    }

    protected void removeFactor(FactorGroup factorGroup, String factorPath) {
        ArrayList<Factor> factorCopy = new ArrayList<Factor>(factorGroup.getFactors());
        for (Factor factor : factorCopy) {
            if (factor instanceof FactorGroup) {
                this.removeFactor((FactorGroup)factor, factorPath);
            }
            if (!factorPath.equals(factor.getPath())) continue;
            factorGroup.remove(factor);
        }
    }

    public void addFactor(Factor f) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add factor (" + f.getName() + ") : " + f.getPath()));
        }
        this.factorGroup.addFactor(f);
    }

    public void addContinuousFactor(String name, String comment, String path, Double min, Double max, boolean exist) {
        Factor f = new Factor(name);
        ContinuousDomain domain = new ContinuousDomain();
        domain.setMinBound(min);
        domain.setMaxBound(max);
        f.setDomain(domain);
        f.setComment(comment);
        f.setPath(path);
        if (exist) {
            this.removeFactor(path);
        }
        this.addFactor(f);
    }

    public void addContinuousPercentageFactor(String name, String comment, String path, Double referenceValue, Double coefficient, boolean exist) {
        Factor f = new Factor(name);
        ContinuousDomain domain = new ContinuousDomain(true);
        domain.setReferenceValue(referenceValue);
        domain.setCoefficient(coefficient);
        f.setDomain(domain);
        f.setComment(comment);
        f.setPath(path);
        if (exist) {
            this.removeFactor(path);
        }
        this.addFactor(f);
    }

    public void addDiscreteFactor(String name, String comment, String path, List<Object> values, boolean exist) {
        this.addDiscreteFactor(new DiscreteDomain(), name, comment, path, values, exist);
    }

    public void addDiscreteRuleFactor(String name, String comment, String path, List<Object> values, boolean exist) {
        this.addDiscreteFactor(new RuleDiscreteDomain(), name, comment, path, values, exist);
    }

    public void addDiscreteEquationFactor(String name, String comment, String path, List<Object> values, boolean exist) {
        this.addDiscreteFactor(new EquationDiscreteDomain(), name, comment, path, values, exist);
    }

    protected void addDiscreteFactor(DiscreteDomain domain, String name, String comment, String path, List<Object> values, boolean exist) {
        Factor f = new Factor(name);
        TreeMap<Object, Object> domainValues = new TreeMap<Object, Object>();
        int label = 0;
        for (Object value : values) {
            domainValues.put(label, value);
            ++label;
        }
        domain.setValues(domainValues);
        f.setDomain(domain);
        f.setComment(comment);
        f.setPath(path);
        if (exist) {
            this.removeFactor(path);
        }
        this.addFactor(f);
    }

    public void addContinuousEquationFactor(String name, String comment, String path, EquationContinuousDomain domain, boolean exist) {
        Factor f = new Factor(name + "." + domain.getVariableName());
        f.setDomain(domain);
        f.setComment(comment);
        f.setPath(path);
        if (exist) {
            this.removeFactor(path);
        }
        this.addFactor(f);
    }

    public void addContinuousMatrixFactor(String name, String comment, String path, MatrixND referenceValue, Double coef, boolean exist) {
        Factor f = new Factor(name);
        MatrixContinuousDomain domain = new MatrixContinuousDomain(true);
        domain.setReferenceValue(referenceValue);
        domain.setCoefficient(coef);
        f.setComment(comment);
        f.setDomain(domain);
        f.setPath(path);
        if (exist) {
            this.removeFactor(path);
        }
        this.addFactor(f);
    }

    public void addContinuousMatrixFactor(String name, String comment, String path, MatrixND minBound, MatrixND maxBound, boolean exist) {
        Factor f = new Factor(name);
        MatrixContinuousDomain domain = new MatrixContinuousDomain();
        domain.setMinBound(minBound);
        domain.setMaxBound(maxBound);
        f.setComment(comment);
        f.setDomain(domain);
        f.setPath(path);
        if (exist) {
            this.removeFactor(path);
        }
        this.addFactor(f);
    }

    public SimulationParameter getSimulationParameter() {
        return this.param;
    }

    public void setSimulationParameter(SimulationParameter p) {
        this.param = p;
    }

    public SimulationStorage getSimulationStorage() {
        return this.simulStorage;
    }

    public RegionStorage getRegionStorage() {
        return this.regionStorage;
    }

    public List<SimulatorLauncher> getSimulationLauncher() {
        return SimulationService.getService().getSimulationLaunchers();
    }

    public void launchSimulation(String simulationId, SimulatorLauncher launcher) {
        String fullSimulationId = "sim_" + simulationId + "_" + DATEFORMAT.format(new Date());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Launch simulation with custom launcher " + launcher.toString()));
        }
        try {
            if ("".equals(fullSimulationId) || SimulationStorage.localyExists(fullSimulationId) || SimulationService.getService().exists(fullSimulationId)) {
                ErrorHelper.showErrorDialog(I18n._((String)"isisfish.simulator.simulaction.badid", (Object[])new Object[]{fullSimulationId}), null);
            } else {
                SimulationService.getService().submit(fullSimulationId, this.param, launcher, 0);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't start simulation", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.launchsimulation", (Object[])new Object[0]), eee);
        }
    }

    public void launchSimulation(String simulationId, SimulatorLauncher launcher, SensitivityAnalysis sensitivityAnalysis) {
        String fullSimulationId = "as_" + simulationId + "_" + DATEFORMAT.format(new Date());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Launch factor simulation with custom launcher " + launcher.toString()));
            log.debug((Object)("Using sensitivityCalculator : " + sensitivityAnalysis.getDescription()));
        }
        try {
            if ("".equals(fullSimulationId) || SimulationStorage.localyExists(fullSimulationId) || SimulationService.getService().exists(fullSimulationId)) {
                ErrorHelper.showErrorDialog(I18n._((String)"isisfish.simulator.simulaction.badid", (Object[])new Object[]{fullSimulationId}), null);
            } else {
                DesignPlan designPlan = new DesignPlan();
                designPlan.setFactorGroup(this.factorGroup);
                SimulationService.getService().submit(fullSimulationId, this.param, launcher, 0, sensitivityAnalysis, designPlan);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't start simulation", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.launchsimulation", (Object[])new Object[0]), eee);
        }
    }

    public void launchSimulationWithSensibility(String simulationId, SimulatorLauncher launcher) {
        this.launchSimulation(simulationId, launcher, this.getSensitivityAnalysis());
    }

    public void runSensitivitySecondPass(String masterSensitivitySimulationName) {
        SensitivityAnalysis sensitivityAnalysis = null;
        TreeMap<Integer, SimulationStorage> simulationStorageForAnalyze = new TreeMap<Integer, SimulationStorage>();
        File simuationDirectory = SimulationStorage.getSimulationDirectory();
        for (File simuation : simuationDirectory.listFiles()) {
            if (!simuation.isDirectory() || !simuation.getName().startsWith(masterSensitivitySimulationName + "_")) continue;
            SimulationStorage storage = SimulationStorage.getSimulation(simuation.getName());
            String suffix = simuation.getName().substring(simuation.getName().lastIndexOf("_") + 1);
            simulationStorageForAnalyze.put(Integer.valueOf(suffix), storage);
            if (sensitivityAnalysis != null) continue;
            SimulationParameter params = storage.getParameter();
            sensitivityAnalysis = params.getSensitivityAnalysis();
        }
        if (sensitivityAnalysis != null) {
            try {
                File masterExportDirectory = new File(SimulationStorage.getSensitivityResultsDirectory(), masterSensitivitySimulationName);
                if (!masterExportDirectory.isDirectory()) {
                    masterExportDirectory.mkdirs();
                }
                ArrayList<SimulationStorage> simulationStorageForAnalyzeList = new ArrayList<SimulationStorage>(simulationStorageForAnalyze.values());
                sensitivityAnalysis.analyzeResult(simulationStorageForAnalyzeList, masterExportDirectory);
            }
            catch (SensitivityException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't call analyse result", (Throwable)e);
                }
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Can't run sensitivity second pass");
        }
    }

    public List<File> getSensitivitySecondPassResults(String masterSensitivitySimulationName) {
        ArrayList<File> result = new ArrayList<File>();
        File masterExportDirectory = new File(SimulationStorage.getSensitivityResultsDirectory(), masterSensitivitySimulationName);
        if (masterExportDirectory.isDirectory()) {
            for (File exportFile : masterExportDirectory.listFiles()) {
                if (!exportFile.isFile() || exportFile.getName().startsWith(".")) continue;
                result.add(exportFile);
            }
        }
        return result;
    }

    public void populationSelected(final ParamsUI paramsUI) {
        CardLayout layout = (CardLayout)paramsUI.getPopulationEffectivesPanel().getLayout();
        Object[] selectedPopulationsValues = paramsUI.getListSimulParamsPopulations().getSelectedValues();
        if (ArrayUtils.isNotEmpty((Object[])selectedPopulationsValues)) {
            paramsUI.getPopulationEffectivesTabbedPane().removeAll();
            this.setPopulations(selectedPopulationsValues);
            for (Object selectedPopulationValue : selectedPopulationsValues) {
                Population selectedPopulation = (Population)selectedPopulationValue;
                final MatrixPanelEditor matrixPanel = new MatrixPanelEditor();
                MatrixND populationEffectives = this.getSimulationParameter().getNumberOf(selectedPopulation);
                matrixPanel.setMatrix(populationEffectives);
                JPanel matrixPanelComponent = new JPanel(new BorderLayout());
                matrixPanelComponent.add((Component)matrixPanel, "Center");
                if (paramsUI.isSensitivity().booleanValue()) {
                    matrixPanel.putClientProperty((Object)"sensitivityPopulation", (Object)selectedPopulation);
                    JButton addFactorButton = new JButton();
                    addFactorButton.setAction(new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SimulAction.this.addFactorWithComponent(paramsUI, (JComponent)matrixPanel);
                        }

                        @Override
                        public Object getValue(String key) {
                            ImageIcon result = null;
                            if (key.equals("SmallIcon")) {
                                result = SwingUtil.createImageIcon((String)"building_add.png");
                            }
                            return result;
                        }
                    });
                    matrixPanelComponent.add((Component)addFactorButton, "East");
                }
                paramsUI.getPopulationEffectivesTabbedPane().add((Component)matrixPanelComponent, I18n._((String)"isisfish.params.populationEffectives", (Object[])new Object[]{selectedPopulation.getName()}));
            }
            layout.show(paramsUI.getPopulationEffectivesPanel(), "specific");
        } else {
            layout.show(paramsUI.getPopulationEffectivesPanel(), "default");
        }
    }

    public void addFactorWithComponent(ParamsUI paramsUI, JComponent source) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Event intercepted on " + source));
        }
        Factor selectedFactor = null;
        if (source instanceof RuleChooser) {
            String factorPath = "parameters.rules";
            selectedFactor = this.getFactor(factorPath);
            if (selectedFactor == null) {
                selectedFactor = new Factor(I18n._((String)"isisfish.sensitivity.rulesfactorname", (Object[])new Object[0]));
                selectedFactor.setPath(factorPath);
                selectedFactor.setDomain(new RuleDiscreteDomain());
            }
        } else if (source instanceof MatrixPanelEditor) {
            Population population = (Population)source.getClientProperty("sensitivityPopulation");
            String factorPath = "parameters.population." + population.getName() + ".number";
            selectedFactor = this.getFactor(factorPath);
            if (selectedFactor == null) {
                selectedFactor = new Factor(I18n._((String)"isisfish.sensitivity.populationfactorname", (Object[])new Object[]{population.getName()}));
                selectedFactor.setPath(factorPath);
                MatrixContinuousDomain factorDomain = new MatrixContinuousDomain();
                MatrixND populationEffectives = this.getSimulationParameter().getNumberOf(population);
                factorDomain.setReferenceValue(populationEffectives.copy());
                factorDomain.setCoefficient(0.0);
                selectedFactor.setDomain(factorDomain);
            }
        }
        if (selectedFactor != null) {
            FactorWizardUI wizard = new FactorWizardUI((JAXXContext)paramsUI);
            SensitivityInputHandler handler = wizard.getHandler();
            handler.initExistingFactor(wizard, selectedFactor);
            wizard.pack();
            wizard.setLocationRelativeTo((Component)((Object)paramsUI));
            wizard.setVisible(true);
        }
    }

    public void addRuleParameterFactor(RuleChooser ruleChooser, Rule rule, String paramName) {
        SensitivityInputHandler handler = ruleChooser.getContextValue(SensitivityInputHandler.class);
        int index = ruleChooser.getRulesList().indexOf(rule);
        String factorPath = "parameters.rule." + index + ".parameter." + paramName;
        try {
            Object paramValue = RuleStorage.getParameterValue(rule, paramName);
            if (!handler.canBeContinue(paramValue)) {
                Class paramType = RuleStorage.getParameterType(rule, paramName);
                factorPath = factorPath + "." + paramType.getName();
                paramValue = paramType;
            }
            FactorWizardUI factorWizardUI = new FactorWizardUI((JAXXContext)ruleChooser);
            factorWizardUI.getFactorNameField().setText(I18n._((String)"isisfish.sensitivity.ruleparameterfactorname", (Object[])new Object[]{rule.getClass().getSimpleName(), paramName}));
            factorWizardUI.setFactorPath(factorPath);
            handler.initNewFactorWithValue(factorWizardUI, paramValue);
            factorWizardUI.pack();
            factorWizardUI.setLocationRelativeTo((Component)((Object)ruleChooser));
            factorWizardUI.setVisible(true);
        }
        catch (IsisFishException ex) {
            throw new IsisFishRuntimeException("Can't add factor on rule", ex);
        }
    }
}

