/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.ui.SimulationUI;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellEditor;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellRenderer;
import fr.ifremer.isisfish.ui.models.rule.RuleParametersFactorTableCellEditor;
import fr.ifremer.isisfish.ui.models.rule.RuleParametersFactorTableCellRenderer;
import fr.ifremer.isisfish.ui.simulator.RuleChooser;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import fr.ifremer.isisfish.ui.widget.editor.ScriptParameterDialog;
import jaxx.runtime.JAXXContext;

public class RuleChooserHandler {
    protected void addSelectedRules(RuleChooser ruleChooser) {
        Object[] availableRuleValues;
        for (Object availableRuleValue : availableRuleValues = ruleChooser.getAvailableRuleList().getSelectedValues()) {
            String availableRuleName = (String)availableRuleValue;
            try {
                RuleStorage ruleStorage = RuleStorage.getRule(availableRuleName);
                Rule ruleTmp = ruleStorage.getNewRuleInstance();
                ruleTmp = (Rule)ScriptParameterDialog.displayConfigurationFrame((JAXXContext)ruleChooser, ruleTmp);
                if (ruleTmp == null) continue;
                ruleChooser.getRulesList().add(ruleTmp);
            }
            catch (IsisFishException ex) {
                throw new IsisFishRuntimeException("Can't add rule", ex);
            }
        }
        ruleChooser.getSelectedRulesListModel().setRules(ruleChooser.getRulesList());
    }

    protected void removeSelectedRules(RuleChooser ruleChooser) {
        Object[] selectedRuleValues;
        SimulAction simulAction = ruleChooser.getContextValue(SimulAction.class);
        for (Object selectedRuleValue : selectedRuleValues = ruleChooser.getSelectedRulesList().getSelectedValues()) {
            if (ruleChooser.isShowFactorColumn().booleanValue()) {
                int ruleIndex = ruleChooser.getRulesList().indexOf(selectedRuleValue);
                simulAction.preRemoveRule(ruleIndex);
                ruleChooser.getContextValue(SimulationUI.class, "SimulationUI").refreshFactorTree();
            }
            ruleChooser.getRulesList().remove(selectedRuleValue);
        }
        ruleChooser.getSelectedRulesListModel().setRules(ruleChooser.getRulesList());
        ruleChooser.getSelectedRulesList().clearSelection();
    }

    protected void clearAllRules(RuleChooser ruleChooser) {
        if (ruleChooser.isShowFactorColumn().booleanValue()) {
            SimulAction simulAction = ruleChooser.getContextValue(SimulAction.class);
            for (Rule rule : ruleChooser.getRulesList()) {
                int ruleIndex = ruleChooser.getRulesList().indexOf(rule);
                simulAction.preRemoveRule(ruleIndex);
            }
            ruleChooser.getContextValue(SimulationUI.class, "SimulationUI").refreshFactorTree();
        }
        ruleChooser.getRulesList().clear();
        ruleChooser.getSelectedRulesListModel().setRules(ruleChooser.getRulesList());
        ruleChooser.getSelectedRulesList().clearSelection();
    }

    protected void displayRuleParameters(RuleChooser ruleChooser) {
        Rule selectedRule = (Rule)ruleChooser.getSelectedRulesList().getSelectedValue();
        if (selectedRule != null) {
            ruleChooser.getSelectedRuleParameterTableModel().setScript(selectedRule);
            ScriptParametersTableCellRenderer cellRenderer = new ScriptParametersTableCellRenderer(selectedRule);
            ruleChooser.getSelectedRuleParameterTable().getColumnModel().getColumn(0).setCellRenderer(cellRenderer);
            ScriptParametersTableCellEditor cellEditor = new ScriptParametersTableCellEditor(selectedRule);
            cellEditor.setRegionStorage(ruleChooser.getContextValue(RegionStorage.class));
            ruleChooser.getSelectedRuleParameterTable().getColumnModel().getColumn(1).setCellEditor(cellEditor);
            if (ruleChooser.isShowFactorColumn().booleanValue()) {
                RuleParametersFactorTableCellRenderer sensitivityRenderer = new RuleParametersFactorTableCellRenderer(ruleChooser, selectedRule);
                ruleChooser.getSelectedRuleParameterTable().getColumnModel().getColumn(2).setCellRenderer(sensitivityRenderer);
                RuleParametersFactorTableCellEditor sensitivityEditor = new RuleParametersFactorTableCellEditor(ruleChooser, selectedRule);
                ruleChooser.getSelectedRuleParameterTable().getColumnModel().getColumn(2).setCellEditor(sensitivityEditor);
            }
        } else {
            ruleChooser.getSelectedRuleParameterTableModel().setScript(null);
        }
    }
}

