/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.sensitivity.model;

import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.MatrixContinuousDomain;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;

public class FactorTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1686424876690392268L;
    protected Map<String, Icon> iconCache = new HashMap<String, Icon>();

    public FactorTreeCellRenderer() {
        this.iconCache.put("c", Resource.getIcon((String)"/icons/factors/c.png"));
        this.iconCache.put("ce", Resource.getIcon((String)"/icons/factors/ce.png"));
        this.iconCache.put("cm", Resource.getIcon((String)"/icons/factors/cm.png"));
        this.iconCache.put("d", Resource.getIcon((String)"/icons/factors/d.png"));
        this.iconCache.put("dg", Resource.getIcon((String)"/icons/factors/dgroup.png"));
        this.iconCache.put("cg", Resource.getIcon((String)"/icons/factors/cgroup.png"));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel c = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        String icon = null;
        String text = null;
        if (value instanceof Factor) {
            Factor factor = (Factor)value;
            if (value instanceof FactorGroup) {
                FactorGroup factorGroup = (FactorGroup)value;
                if (factorGroup == tree.getModel().getRoot()) {
                    text = I18n._((String)"isisfish.sensitivity.factors", (Object[])new Object[0]);
                } else {
                    if (factorGroup.isDiscrete()) {
                        icon = "d";
                    } else if (factorGroup.isContinuous()) {
                        icon = "c";
                    }
                    icon = icon + "g";
                    text = factor.getName();
                }
            } else {
                Domain domain = factor.getDomain();
                icon = domain instanceof ContinuousDomain ? "c" : "d";
                if (domain instanceof EquationContinuousDomain) {
                    icon = icon + "e";
                } else if (domain instanceof MatrixContinuousDomain) {
                    icon = icon + "m";
                }
                text = factor.getName();
            }
        }
        c.setIcon(this.iconCache.get(icon));
        c.setText(text);
        return c;
    }
}

