/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Formule;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.ui.input.InputOneEquationUI;
import fr.ifremer.isisfish.ui.sensitivity.ContinuousPanelContainerUI;
import fr.ifremer.isisfish.ui.sensitivity.equation.EquationDomainListModel;
import fr.ifremer.isisfish.ui.sensitivity.equation.EquationDomainRenderer;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntityContextable;

public class EquationContinuousPanelUI
extends ContinuousPanelContainerUI {
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_BEAN_PROPERTY = "beanProperty";
    public static final String PROPERTY_CLAZZ = "clazz";
    public static final String PROPERTY_FORMULE = "formule";
    public static final String PROPERTY_FORMULE_CATEGORY = "formuleCategory";
    public static final String PROPERTY_PERCENTAGE_TYPE_DOMAIN = "percentageTypeDomain";
    public static final String PROPERTY_SELECTED_DOMAIN = "selectedDomain";
    public static final String PROPERTY_SELECTED_EQUATION = "selectedEquation";
    public static final String PROPERTY_TEXT = "text";
    public static final String BINDING_ADD_VISIBLE = "add.visible";
    public static final String BINDING_COEFFICIENT_FIELD_ENABLED = "coefficientField.enabled";
    public static final String BINDING_EDITOR_BEAN = "editor.bean";
    public static final String BINDING_EDITOR_BEAN_PROPERTY = "editor.beanProperty";
    public static final String BINDING_EDITOR_CLAZZ = "editor.clazz";
    public static final String BINDING_EDITOR_FORMULE = "editor.formule";
    public static final String BINDING_EDITOR_FORMULE_CATEGORY = "editor.formuleCategory";
    public static final String BINDING_EDITOR_SELECTED_EQUATION = "editor.selectedEquation";
    public static final String BINDING_EDITOR_TEXT = "editor.text";
    public static final String BINDING_EDITOR_VISIBLE = "editor.visible";
    public static final String BINDING_MAX_BOUND_FIELD_ENABLED = "maxBoundField.enabled";
    public static final String BINDING_MIN_BOUND_FIELD_ENABLED = "minBoundField.enabled";
    public static final String BINDING_MIN_MAX_BUTTON_ENABLED = "minMaxButton.enabled";
    public static final String BINDING_MIN_MAX_BUTTON_SELECTED = "minMaxButton.selected";
    public static final String BINDING_PERCENTAGE_TYPE_BUTTON_ENABLED = "percentageTypeButton.enabled";
    public static final String BINDING_PERCENTAGE_TYPE_BUTTON_SELECTED = "percentageTypeButton.selected";
    public static final String BINDING_REFERENCE_VALUE_FIELD_ENABLED = "referenceValueField.enabled";
    public static final String BINDING_REMOVE_ENABLED = "remove.enabled";
    public static final String BINDING_REMOVE_VISIBLE = "remove.visible";
    public static final String BINDING_VARIABLE_NAME_FIELD_ENABLED = "variableNameField.enabled";
    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";
    private static final String BINDING_$JLABEL4_ENABLED = "$JLabel4.enabled";
    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVYz28bRRSeuHV+tGmTJiUEEVAKhgpU1m1TcUkoaZIabBxS4iQULARj7ziear2znZ117BwQNy4gceYEdy5IvXFCHDhz4IL4FxDiwIEL4s3setcbbzYrJoe1M++9773vvTczz/vdHyjvcnTtEe71DO7ZgnaIUbn38OFO4xFpii3iNjl1BOPI/xvLoVwdXTTDdVegF+tVaV4MzIubrOMwm9hD1qtVdMEVfYu4bUKEQM/FLZquW6yF4tWe4/EBahhUEuo3f/2Z+8r87NscQj0HorsOVJbPsoqYnK+iHDUFmgNPXVy0sH0IYXBqH0K8l+TapoVd913cIY/Rp2iiisYdzAFMoBeyU1YYyr7nCLRU2GRgY3vMcx9gm1jyX0xtwvfLNwVaa3GDtjjpEPh0qduibtvwqOES26WCdqnoG/cfe1hQZp8A2i87jvIzLtB5QXoQ5azkYEhehs9rSKNBsC3QCuOHhu1RwWxDMIdiwyEc/ApiN4mxJ1fugxfRl84AEzcsEoFMS5AHnIGN6Mu1y5Es37Tw8bFAM1EMKhORxkyL8Y4HCcKCHDJ+EmDWJRa0IDEHfAV6KSk7RMZHiRvmJYKYCDwIVEi1LPlqkeHlge8t1oHiCHQlYrHBmAW0I+WrQL8JWPiQ7PUd4ptI2bVIZ75QU31RtsEjtugx4VDtl1WvNqF5qAWB+a1jjGgOEWrKMsgGnJMB9Qz3CKpqVFQDRGqXChUAYZYl18HP0zHlSCTVr0fghT1ZXtBfjO0h30zJpOaryW5uycUb8vFaqDDXxZxKO7cKLbXNTGIJtJmhxUlQyrCmflJDlCGqMRdBoUKqck0q3oyKVZBrNVVewFVowPj5YbNRDedkkhTbYpxtILodilZD0WShUsUN5SleOLUqld4Ida8MGMlzp0SJBSfUQsxoDzaiEsQNpzvU3sa9DU8IuVkWYza72KTMF8VDO9G9kcpbcb3pNjVlVKrV5NorcXnAfiVkXxlhr5J2Tz6qUf0g6A3m2WZIaCuuMDC+nWgMdNOMg6DupAS1EuIeRLuVkxbh8gg8wJZH4ugHIxB3EiBmm4y0WrRJIbWn2U8VKn66oS3mY9VKKtQ5bCqQRrzrxmEnsS5JkhATznUuUPGUHUdtxxNGWT53bDLYavvlAIajZ2PnANzSRnRLR9foWB3lORyfMAos1kcv9l0Q+Vf64okrXQIq6b8L87/+8PuT0uAevwG+n0pUHRpD4H51/KuHStcz/iXuCWoVt7GzWkdT/iGuZpSlhMBqgRiCA3/+CS/Njbex2waI/MRvP/608Mkv51CuhC5YDJslLPXLaEq0OWSBWWbPeXNdRTR9NAnPWRkb9KWjGogTswbnN1wnayYWeLlBbRPKe7cHuVhKyEUYUGPq57/na9+vD/IxBvE9c6p6lJP8h2ic2hZME2qyCYaWxEnmouMSz2TRcJI0rozJz1tOcPox9XSTCE83iWXtEtuEXcOlVrfnyY8jFbz81ldYr2fAynfkiasJMkFsufHNFJj1DDDBHDW35md1GQsYoxqeIHf/L6Zc/jwlqk1thFIGXpOD+UYLRy5/IR9f6iCkcSlnQvhaGyGNxdkIcNRauM88kRLHO1lQGoybqftnWzujO9r5yIaQFsN72gg1bRbZENJi2M+E8CQF4X3tGD7QzkM2hLQY6toIH2mzyIaQFsPH2ghYm4U+gpnlauzCDBj8ljuFytkwZyWjpU0lG8I/WjHAkQsTHfWn51PiaGdAuYo9wWq4S+DHIoWhX83RmpjqBU0KuywYI+9nNLD89zmaIIMXMpowSW+ONOBG3jRp4YWNrYWQ1tgS4T84vIVzuRUAAA==";
    private static final Log log = LogFactory.getLog(EquationContinuousPanelUI.class);
    private static final long serialVersionUID = 1L;
    private boolean allComponentsCreated;
    protected JButton add;
    protected TopiaEntityContextable bean;
    protected String beanProperty;
    protected Class clazz;
    protected JTextField coefficientField;
    protected InputOneEquationUI editor;
    protected Formule formule;
    protected String formuleCategory;
    protected JPanel hidablePanel;
    protected JTextField maxBoundField;
    protected JTextField minBoundField;
    protected JRadioButton minMaxButton;
    protected JRadioButton percentageTypeButton;
    protected Boolean percentageTypeDomain;
    protected JTextField referenceValueField;
    protected JButton remove;
    protected Boolean selectedDomain;
    protected Equation selectedEquation;
    protected String text;
    protected JTextField variableNameField;
    protected JList variablesList;
    protected EquationDomainListModel variablesListModel;
    private EquationContinuousPanelUI $ContinuousPanelContainerUI0 = this;
    private JScrollPane $JScrollPane0;
    private Table $Table0;
    private JScrollPane $JScrollPane1;
    private ListSelectionModel $ListSelectionModel0;
    private Table $Table1;
    private Table $Table2;
    private JLabel $JLabel0;
    private Table $Table3;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private Table $Table4;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JButton $JButton0;
    protected List<EquationContinuousDomain> domains;

    public List<EquationContinuousDomain> getDomains() {
        return this.domains;
    }

    protected void addDomain(EquationContinuousDomain domain) {
        this.domains.add(domain);
        this.variablesListModel.setDomains(this.domains);
    }

    protected void validSelectedDomain() {
        EquationContinuousDomain selectedDomain = (EquationContinuousDomain)this.variablesList.getSelectedValue();
        selectedDomain.setVariableName(this.variableNameField.getText().trim());
        if (this.isPercentageTypeDomain().booleanValue()) {
            selectedDomain.setPercentageType(true);
            selectedDomain.setReferenceValue(Double.parseDouble(this.referenceValueField.getText()));
            selectedDomain.setCoefficient(Double.parseDouble(this.coefficientField.getText()) / 100.0);
        } else {
            selectedDomain.setPercentageType(false);
            selectedDomain.setMinBound(Double.parseDouble(this.minBoundField.getText()));
            selectedDomain.setMaxBound(Double.parseDouble(this.maxBoundField.getText()));
        }
        String variableName = selectedDomain.getVariableName();
        String[] lines = this.editor.getEditor().getText().split("\n");
        String result = "";
        for (String line : lines) {
            Pattern p = Pattern.compile("(^.*\\s+" + variableName + "\\s*\\=\\s*)([\\d\\.]+).*\\;$");
            Matcher matcher = p.matcher(line);
            if (matcher.find()) {
                String fullVariableName = this.bean.toString() + "." + StringUtils.uncapitalize((String)this.beanProperty) + "." + variableName;
                line = matcher.group(1) + "context.getValueAndCompute(\"" + fullVariableName + "\", " + matcher.group(2) + ");";
            }
            result = result + line + "\n";
        }
        this.editor.getEditor().setText(result);
        this.variablesListModel.setDomains(this.domains);
    }

    protected void addNewVariable() {
        EquationContinuousDomain domain = new EquationContinuousDomain();
        domain.setVariableName("X");
        this.addDomain(domain);
        this.variablesList.setSelectedValue(domain, true);
    }

    protected void displaySelectedDomain() {
        EquationContinuousDomain selectedDomain = (EquationContinuousDomain)this.variablesList.getSelectedValue();
        if (selectedDomain != null) {
            this.setSelectedDomain(true);
            this.variableNameField.setText(selectedDomain.getVariableName());
            this.setPercentageTypeDomain(selectedDomain.getCoefficient() != null);
            if (selectedDomain.getCoefficient() != null) {
                this.coefficientField.setText(String.valueOf(selectedDomain.getCoefficient() * 100.0));
            } else {
                this.coefficientField.setText("");
            }
            if (selectedDomain.getReferenceValue() != null) {
                this.referenceValueField.setText(selectedDomain.getReferenceValue().toString());
            } else {
                this.referenceValueField.setText("");
            }
            if (selectedDomain.getMinBound() != null) {
                this.minBoundField.setText(selectedDomain.getMinBound().toString());
            } else {
                this.minBoundField.setText("");
            }
            if (selectedDomain.getMaxBound() != null) {
                this.maxBoundField.setText(selectedDomain.getMaxBound().toString());
            } else {
                this.maxBoundField.setText("");
            }
        } else {
            this.setSelectedDomain(false);
        }
    }

    protected void removeSelectedVariable() {
        int selectedIndex = this.variablesList.getSelectedIndex();
        this.domains.remove(selectedIndex);
        this.variablesList.clearSelection();
        this.variablesListModel.setDomains(this.domains);
    }

    @Override
    public boolean isFactorValid() {
        boolean valid = true;
        try {
            for (EquationContinuousDomain domain : this.domains) {
                if (StringUtils.isBlank((CharSequence)domain.getVariableName())) {
                    valid = false;
                    continue;
                }
                if (domain.getCoefficient() == null) {
                    valid = domain.getMinBound() != null && domain.getMaxBound() != null;
                    continue;
                }
                valid = domain.getReferenceValue() != null;
            }
        }
        catch (NumberFormatException ex) {
            valid = false;
        }
        return valid;
    }

    protected void $afterCompleteSetup() {
        this.addPropertyChangeListener(PROPERTY_PERCENTAGE_TYPE_DOMAIN, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (((Boolean)evt.getNewValue()).booleanValue()) {
                    ((CardLayout)EquationContinuousPanelUI.this.hidablePanel.getLayout()).show(EquationContinuousPanelUI.this.hidablePanel, "percentageType");
                } else {
                    ((CardLayout)EquationContinuousPanelUI.this.hidablePanel.getLayout()).show(EquationContinuousPanelUI.this.hidablePanel, "minMaxType");
                }
            }
        });
    }

    public EquationContinuousPanelUI(LayoutManager param0, boolean param1) {
        super(param0, param1);
        this.$initialize();
    }

    public EquationContinuousPanelUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0, param1, param2);
        this.$initialize();
    }

    public EquationContinuousPanelUI(LayoutManager param0) {
        super(param0);
        this.$initialize();
    }

    public EquationContinuousPanelUI(JAXXContext param0, LayoutManager param1) {
        super(param0, param1);
        this.$initialize();
    }

    public EquationContinuousPanelUI(boolean param0) {
        super(param0);
        this.$initialize();
    }

    public EquationContinuousPanelUI(JAXXContext param0, boolean param1) {
        super(param0, param1);
        this.$initialize();
    }

    public EquationContinuousPanelUI() {
        this.$initialize();
    }

    public EquationContinuousPanelUI(JAXXContext param0) {
        super(param0);
        this.$initialize();
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.validSelectedDomain();
    }

    public void doActionPerformed__on__add(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.addNewVariable();
    }

    public void doActionPerformed__on__minMaxButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.setPercentageTypeDomain(!this.minMaxButton.isSelected());
    }

    public void doActionPerformed__on__percentageTypeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.setPercentageTypeDomain(this.percentageTypeButton.isSelected());
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.removeSelectedVariable();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.displaySelectedDomain();
        this.setSelectedDomain(this.variablesList.getSelectedIndex() != -1);
    }

    public JButton getAdd() {
        return this.add;
    }

    public TopiaEntityContextable getBean() {
        return this.bean;
    }

    public String getBeanProperty() {
        return this.beanProperty;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public JTextField getCoefficientField() {
        return this.coefficientField;
    }

    public InputOneEquationUI getEditor() {
        return this.editor;
    }

    public Formule getFormule() {
        return this.formule;
    }

    public String getFormuleCategory() {
        return this.formuleCategory;
    }

    public JPanel getHidablePanel() {
        return this.hidablePanel;
    }

    public JTextField getMaxBoundField() {
        return this.maxBoundField;
    }

    public JTextField getMinBoundField() {
        return this.minBoundField;
    }

    public JRadioButton getMinMaxButton() {
        return this.minMaxButton;
    }

    public JRadioButton getPercentageTypeButton() {
        return this.percentageTypeButton;
    }

    public Boolean getPercentageTypeDomain() {
        return this.percentageTypeDomain;
    }

    public JTextField getReferenceValueField() {
        return this.referenceValueField;
    }

    public JButton getRemove() {
        return this.remove;
    }

    public Boolean getSelectedDomain() {
        return this.selectedDomain;
    }

    public Equation getSelectedEquation() {
        return this.selectedEquation;
    }

    public String getText() {
        return this.text;
    }

    public JTextField getVariableNameField() {
        return this.variableNameField;
    }

    public JList getVariablesList() {
        return this.variablesList;
    }

    public EquationDomainListModel getVariablesListModel() {
        return this.variablesListModel;
    }

    public Boolean isPercentageTypeDomain() {
        return this.percentageTypeDomain != null && this.percentageTypeDomain != false;
    }

    public Boolean isSelectedDomain() {
        return this.selectedDomain != null && this.selectedDomain != false;
    }

    public void setBean(TopiaEntityContextable bean) {
        TopiaEntityContextable oldValue = this.bean;
        this.bean = bean;
        this.firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setBeanProperty(String beanProperty) {
        String oldValue = this.beanProperty;
        this.beanProperty = beanProperty;
        this.firePropertyChange(PROPERTY_BEAN_PROPERTY, oldValue, beanProperty);
    }

    public void setClazz(Class clazz) {
        Class oldValue = this.clazz;
        this.clazz = clazz;
        this.firePropertyChange(PROPERTY_CLAZZ, oldValue, clazz);
    }

    public void setFormule(Formule formule) {
        Formule oldValue = this.formule;
        this.formule = formule;
        this.firePropertyChange(PROPERTY_FORMULE, oldValue, formule);
    }

    public void setFormuleCategory(String formuleCategory) {
        String oldValue = this.formuleCategory;
        this.formuleCategory = formuleCategory;
        this.firePropertyChange(PROPERTY_FORMULE_CATEGORY, oldValue, formuleCategory);
    }

    public void setPercentageTypeDomain(Boolean percentageTypeDomain) {
        Boolean oldValue = this.percentageTypeDomain;
        this.percentageTypeDomain = percentageTypeDomain;
        this.firePropertyChange(PROPERTY_PERCENTAGE_TYPE_DOMAIN, oldValue, percentageTypeDomain);
    }

    public void setSelectedDomain(Boolean selectedDomain) {
        Boolean oldValue = this.selectedDomain;
        this.selectedDomain = selectedDomain;
        this.firePropertyChange(PROPERTY_SELECTED_DOMAIN, oldValue, selectedDomain);
    }

    public void setSelectedEquation(Equation selectedEquation) {
        Equation oldValue = this.selectedEquation;
        this.selectedEquation = selectedEquation;
        this.firePropertyChange(PROPERTY_SELECTED_EQUATION, oldValue, selectedEquation);
    }

    public void setText(String text) {
        String oldValue = this.text;
        this.text = text;
        this.firePropertyChange(PROPERTY_TEXT, oldValue, text);
    }

    protected JScrollPane get$JScrollPane0() {
        return this.$JScrollPane0;
    }

    protected Table get$Table0() {
        return this.$Table0;
    }

    protected JScrollPane get$JScrollPane1() {
        return this.$JScrollPane1;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return this.$ListSelectionModel0;
    }

    protected Table get$Table1() {
        return this.$Table1;
    }

    protected Table get$Table2() {
        return this.$Table2;
    }

    protected JLabel get$JLabel0() {
        return this.$JLabel0;
    }

    protected Table get$Table3() {
        return this.$Table3;
    }

    protected JLabel get$JLabel1() {
        return this.$JLabel1;
    }

    protected JLabel get$JLabel2() {
        return this.$JLabel2;
    }

    protected Table get$Table4() {
        return this.$Table4;
    }

    protected JLabel get$JLabel3() {
        return this.$JLabel3;
    }

    protected JLabel get$JLabel4() {
        return this.$JLabel4;
    }

    protected JButton get$JButton0() {
        return this.$JButton0;
    }

    protected void addChildrenToContent() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.content.add((Component)this.$JScrollPane0, "Center");
    }

    protected void addChildrenToHidablePanel() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.hidablePanel.add((Component)this.$Table3, "minMaxType");
        this.hidablePanel.add((Component)this.$Table4, "percentageType");
    }

    protected void createAdd() {
        this.add = new JButton();
        this.$objectMap.put("add", this.add);
        this.add.setName("add");
        this.add.setText(I18n._((String)"isisfish.common.add", (Object[])new Object[0]));
        this.add.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__add"));
    }

    protected void createBean() {
        this.bean = null;
        this.$objectMap.put(PROPERTY_BEAN, null);
    }

    protected void createBeanProperty() {
        this.beanProperty = null;
        this.$objectMap.put(PROPERTY_BEAN_PROPERTY, null);
    }

    protected void createClazz() {
        this.clazz = null;
        this.$objectMap.put(PROPERTY_CLAZZ, null);
    }

    protected void createCoefficientField() {
        this.coefficientField = new JTextField();
        this.$objectMap.put("coefficientField", this.coefficientField);
        this.coefficientField.setName("coefficientField");
        this.coefficientField.setColumns(15);
    }

    @Override
    protected void createContent() {
        super.createContent();
        this.content.setName("content");
    }

    protected void createEditor() {
        this.editor = new InputOneEquationUI((JAXXContext)this);
        this.$objectMap.put("editor", this.editor);
        this.editor.setName("editor");
        this.editor.setActive(true);
        this.editor.setAutoSaveModification(false);
    }

    protected void createFormule() {
        this.formule = null;
        this.$objectMap.put(PROPERTY_FORMULE, null);
    }

    protected void createFormuleCategory() {
        this.formuleCategory = null;
        this.$objectMap.put(PROPERTY_FORMULE_CATEGORY, null);
    }

    protected void createHidablePanel() {
        this.hidablePanel = new JPanel();
        this.$objectMap.put("hidablePanel", this.hidablePanel);
        this.hidablePanel.setName("hidablePanel");
        this.hidablePanel.setLayout(new CardLayout());
    }

    protected void createMaxBoundField() {
        this.maxBoundField = new JTextField();
        this.$objectMap.put("maxBoundField", this.maxBoundField);
        this.maxBoundField.setName("maxBoundField");
        this.maxBoundField.setColumns(15);
    }

    protected void createMinBoundField() {
        this.minBoundField = new JTextField();
        this.$objectMap.put("minBoundField", this.minBoundField);
        this.minBoundField.setName("minBoundField");
        this.minBoundField.setColumns(15);
    }

    protected void createMinMaxButton() {
        this.minMaxButton = new JRadioButton();
        this.$objectMap.put("minMaxButton", this.minMaxButton);
        this.minMaxButton.setName("minMaxButton");
        this.minMaxButton.setText(I18n._((String)"isisfish.sensitivity.continuousminmaxtype", (Object[])new Object[0]));
        this.minMaxButton.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__minMaxButton"));
    }

    protected void createPercentageTypeButton() {
        this.percentageTypeButton = new JRadioButton();
        this.$objectMap.put("percentageTypeButton", this.percentageTypeButton);
        this.percentageTypeButton.setName("percentageTypeButton");
        this.percentageTypeButton.setText(I18n._((String)"isisfish.sensitivity.continuouspercentagetype", (Object[])new Object[0]));
        this.percentageTypeButton.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__percentageTypeButton"));
    }

    protected void createPercentageTypeDomain() {
        this.percentageTypeDomain = false;
        this.$objectMap.put(PROPERTY_PERCENTAGE_TYPE_DOMAIN, this.percentageTypeDomain);
    }

    protected void createReferenceValueField() {
        this.referenceValueField = new JTextField();
        this.$objectMap.put("referenceValueField", this.referenceValueField);
        this.referenceValueField.setName("referenceValueField");
        this.referenceValueField.setColumns(15);
    }

    protected void createRemove() {
        this.remove = new JButton();
        this.$objectMap.put("remove", this.remove);
        this.remove.setName("remove");
        this.remove.setText(I18n._((String)"isisfish.common.remove", (Object[])new Object[0]));
        this.remove.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__remove"));
    }

    protected void createSelectedDomain() {
        this.selectedDomain = false;
        this.$objectMap.put(PROPERTY_SELECTED_DOMAIN, this.selectedDomain);
    }

    protected void createSelectedEquation() {
        this.selectedEquation = null;
        this.$objectMap.put(PROPERTY_SELECTED_EQUATION, null);
    }

    protected void createText() {
        this.text = null;
        this.$objectMap.put(PROPERTY_TEXT, null);
    }

    protected void createVariableNameField() {
        this.variableNameField = new JTextField();
        this.$objectMap.put("variableNameField", this.variableNameField);
        this.variableNameField.setName("variableNameField");
        this.variableNameField.setColumns(15);
    }

    protected void createVariablesList() {
        this.variablesList = new JList();
        this.$objectMap.put("variablesList", this.variablesList);
        this.variablesList.setName("variablesList");
    }

    protected void createVariablesListModel() {
        this.variablesListModel = new EquationDomainListModel(this.domains);
        this.$objectMap.put("variablesListModel", this.variablesListModel);
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.addChildrenToContent();
        this.$JScrollPane0.getViewport().add((Component)this.$Table0);
        this.$Table0.add((Component)this.$JScrollPane1, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.$Table1, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.add, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.remove, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.editor, (Object)new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$JScrollPane1.getViewport().add(this.variablesList);
        this.$Table1.add((Component)this.$Table2, (Object)new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.minMaxButton, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.percentageTypeButton, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.hidablePanel, (Object)new GridBagConstraints(0, 2, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.$JButton0, (Object)new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)this.$JLabel0, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)this.variableNameField, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.addChildrenToHidablePanel();
        this.$Table3.add((Component)this.$JLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table3.add((Component)this.minBoundField, (Object)new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table3.add((Component)this.$JLabel2, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table3.add((Component)this.maxBoundField, (Object)new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table4.add((Component)this.$JLabel3, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table4.add((Component)this.referenceValueField, (Object)new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table4.add((Component)this.$JLabel4, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table4.add((Component)this.coefficientField, (Object)new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        JAXXUtil.applyDataBinding((JAXXObject)this, this.$bindings.keySet());
        this.$JScrollPane1.setPreferredSize(new Dimension(200, 150));
        this.variablesList.setCellRenderer(new EquationDomainRenderer());
        this.variablesList.setModel(this.variablesListModel);
        this.$Table3.setBorder((Border)BorderFactory.createTitledBorder(""));
        this.$Table4.setBorder((Border)BorderFactory.createTitledBorder(""));
        this.$afterCompleteSetup();
    }

    private void $initialize() {
        if (this.allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.$objectMap.put("$ContinuousPanelContainerUI0", this.$ContinuousPanelContainerUI0);
        this.createText();
        this.createBean();
        this.createBeanProperty();
        this.createClazz();
        this.createFormuleCategory();
        this.createSelectedEquation();
        this.createFormule();
        this.createSelectedDomain();
        this.createPercentageTypeDomain();
        this.domains = new ArrayList<EquationContinuousDomain>();
        this.$JScrollPane0 = new JScrollPane();
        this.$objectMap.put("$JScrollPane0", this.$JScrollPane0);
        this.$JScrollPane0.setName("$JScrollPane0");
        this.$Table0 = new Table();
        this.$objectMap.put("$Table0", this.$Table0);
        this.$Table0.setName("$Table0");
        this.$JScrollPane1 = new JScrollPane();
        this.$objectMap.put("$JScrollPane1", this.$JScrollPane1);
        this.$JScrollPane1.setName("$JScrollPane1");
        this.createVariablesListModel();
        this.createVariablesList();
        this.$ListSelectionModel0 = this.variablesList.getSelectionModel();
        this.$objectMap.put("$ListSelectionModel0", this.$ListSelectionModel0);
        this.$ListSelectionModel0.addListSelectionListener((ListSelectionListener)JAXXUtil.getEventListener(ListSelectionListener.class, (String)"valueChanged", (Object)this, (String)"doValueChanged__on__$ListSelectionModel0"));
        this.$Table1 = new Table();
        this.$objectMap.put("$Table1", this.$Table1);
        this.$Table1.setName("$Table1");
        this.$Table2 = new Table();
        this.$objectMap.put("$Table2", this.$Table2);
        this.$Table2.setName("$Table2");
        this.$JLabel0 = new JLabel();
        this.$objectMap.put("$JLabel0", this.$JLabel0);
        this.$JLabel0.setName("$JLabel0");
        this.$JLabel0.setText(I18n._((String)"isisfish.sensitivity.equation.variablename", (Object[])new Object[0]));
        this.createVariableNameField();
        this.createMinMaxButton();
        this.createPercentageTypeButton();
        this.createHidablePanel();
        this.$Table3 = new Table();
        this.$objectMap.put("$Table3", this.$Table3);
        this.$Table3.setName("$Table3");
        this.$JLabel1 = new JLabel();
        this.$objectMap.put("$JLabel1", this.$JLabel1);
        this.$JLabel1.setName("$JLabel1");
        this.$JLabel1.setText(I18n._((String)"isisfish.sensitivity.firstValue", (Object[])new Object[0]));
        this.createMinBoundField();
        this.$JLabel2 = new JLabel();
        this.$objectMap.put("$JLabel2", this.$JLabel2);
        this.$JLabel2.setName("$JLabel2");
        this.$JLabel2.setText(I18n._((String)"isisfish.sensitivity.lastValue", (Object[])new Object[0]));
        this.createMaxBoundField();
        this.$Table4 = new Table();
        this.$objectMap.put("$Table4", this.$Table4);
        this.$Table4.setName("$Table4");
        this.$JLabel3 = new JLabel();
        this.$objectMap.put("$JLabel3", this.$JLabel3);
        this.$JLabel3.setName("$JLabel3");
        this.$JLabel3.setText(I18n._((String)"isisfish.sensitivity.referencevalue", (Object[])new Object[0]));
        this.createReferenceValueField();
        this.$JLabel4 = new JLabel();
        this.$objectMap.put("$JLabel4", this.$JLabel4);
        this.$JLabel4.setName("$JLabel4");
        this.$JLabel4.setText(I18n._((String)"isisfish.sensitivity.coefficient", (Object[])new Object[0]));
        this.createCoefficientField();
        this.$JButton0 = new JButton();
        this.$objectMap.put("$JButton0", this.$JButton0);
        this.$JButton0.setName("$JButton0");
        this.$JButton0.setText(I18n._((String)"isisfish.sensitivity.equation.valid", (Object[])new Object[0]));
        this.$JButton0.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__$JButton0"));
        this.createAdd();
        this.createRemove();
        this.createEditor();
        this.setName("$ContinuousPanelContainerUI0");
        this.$registerDefaultBindings();
        this.$completeSetup();
    }

    private void $registerDefaultBindings() {
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true, new String[]{PROPERTY_SELECTED_DOMAIN}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.$JLabel0.setEnabled(EquationContinuousPanelUI.this.isSelectedDomain());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_VARIABLE_NAME_FIELD_ENABLED, true, new String[]{PROPERTY_SELECTED_DOMAIN}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.variableNameField.setEnabled(EquationContinuousPanelUI.this.isSelectedDomain());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_MIN_MAX_BUTTON_ENABLED, true, new String[]{PROPERTY_SELECTED_DOMAIN}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.minMaxButton.setEnabled(EquationContinuousPanelUI.this.isSelectedDomain());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_MIN_MAX_BUTTON_SELECTED, true, new String[]{PROPERTY_PERCENTAGE_TYPE_DOMAIN}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.minMaxButton.setSelected(EquationContinuousPanelUI.this.isPercentageTypeDomain() == false);
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_PERCENTAGE_TYPE_BUTTON_ENABLED, true, new String[]{PROPERTY_SELECTED_DOMAIN}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.percentageTypeButton.setEnabled(EquationContinuousPanelUI.this.isSelectedDomain());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_PERCENTAGE_TYPE_BUTTON_SELECTED, true, new String[]{PROPERTY_PERCENTAGE_TYPE_DOMAIN}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.percentageTypeButton.setSelected(EquationContinuousPanelUI.this.isPercentageTypeDomain());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true, new String[]{PROPERTY_SELECTED_DOMAIN}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.$JLabel1.setEnabled(EquationContinuousPanelUI.this.isSelectedDomain());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_MIN_BOUND_FIELD_ENABLED, true, new String[]{PROPERTY_SELECTED_DOMAIN}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.minBoundField.setEnabled(EquationContinuousPanelUI.this.isSelectedDomain());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true, new String[]{PROPERTY_SELECTED_DOMAIN}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.$JLabel2.setEnabled(EquationContinuousPanelUI.this.isSelectedDomain());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_MAX_BOUND_FIELD_ENABLED, true, new String[]{PROPERTY_SELECTED_DOMAIN}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.maxBoundField.setEnabled(EquationContinuousPanelUI.this.isSelectedDomain());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true, new String[]{PROPERTY_SELECTED_DOMAIN}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.$JLabel3.setEnabled(EquationContinuousPanelUI.this.isSelectedDomain());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_REFERENCE_VALUE_FIELD_ENABLED, true, new String[]{PROPERTY_SELECTED_DOMAIN}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.referenceValueField.setEnabled(EquationContinuousPanelUI.this.isSelectedDomain());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_$JLABEL4_ENABLED, true, new String[]{PROPERTY_SELECTED_DOMAIN}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.$JLabel4.setEnabled(EquationContinuousPanelUI.this.isSelectedDomain());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_COEFFICIENT_FIELD_ENABLED, true, new String[]{PROPERTY_SELECTED_DOMAIN}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.coefficientField.setEnabled(EquationContinuousPanelUI.this.isSelectedDomain());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true, new String[]{PROPERTY_SELECTED_DOMAIN}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.$JButton0.setEnabled(EquationContinuousPanelUI.this.isSelectedDomain());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_ADD_VISIBLE, true, new String[]{"continuePossible"}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.add.setVisible(EquationContinuousPanelUI.this.isContinuePossible());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_REMOVE_ENABLED, true, new String[]{PROPERTY_SELECTED_DOMAIN}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.remove.setEnabled(EquationContinuousPanelUI.this.isSelectedDomain());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_REMOVE_VISIBLE, true, new String[]{"continuePossible"}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.remove.setVisible(EquationContinuousPanelUI.this.isContinuePossible());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_EDITOR_BEAN, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.editor.setBean(EquationContinuousPanelUI.this.getBean());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_EDITOR_BEAN_PROPERTY, true, new String[]{PROPERTY_BEAN_PROPERTY}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.editor.setBeanProperty(EquationContinuousPanelUI.this.getBeanProperty());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_EDITOR_CLAZZ, true, new String[]{PROPERTY_CLAZZ}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.editor.setClazz(EquationContinuousPanelUI.this.getClazz());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_EDITOR_FORMULE, true, new String[]{PROPERTY_FORMULE}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.editor.setFormule(EquationContinuousPanelUI.this.getFormule());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_EDITOR_FORMULE_CATEGORY, true, new String[]{PROPERTY_FORMULE_CATEGORY}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.editor.setFormuleCategory(EquationContinuousPanelUI.this.getFormuleCategory());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_EDITOR_SELECTED_EQUATION, true, new String[]{PROPERTY_SELECTED_EQUATION}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.editor.setSelectedEquation(EquationContinuousPanelUI.this.getSelectedEquation());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_EDITOR_TEXT, true, new String[]{PROPERTY_TEXT}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.editor.setText(I18n._((String)EquationContinuousPanelUI.this.getText(), (Object[])new Object[0]));
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_EDITOR_VISIBLE, true, new String[]{"continuePossible"}){

            public void processDataBinding() {
                EquationContinuousPanelUI.this.editor.setVisible(EquationContinuousPanelUI.this.isContinuePossible());
            }
        });
    }
}

