/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.script.model;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.vcs.VCS;
import fr.ifremer.isisfish.vcs.VCSException;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;

public class ScriptTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 807570061868454777L;
    private static Log log = LogFactory.getLog(ScriptTreeCellRenderer.class);
    protected static final Icon VCS_ICON = Resource.getIcon((String)"/icons/database_key.png");

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel c = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value == IsisFish.vcs) {
            c.setText(I18n._((String)"isisfish.ui.script.officialvcs", (Object[])new Object[0]));
            c.setIcon(VCS_ICON);
            c.setFont(c.getFont().deriveFont(1));
        } else if (value == IsisFish.communityVcs) {
            c.setText(I18n._((String)"isisfish.ui.script.communityvcs", (Object[])new Object[0]));
            c.setIcon(VCS_ICON);
            c.setFont(c.getFont().deriveFont(1));
        } else if (value instanceof File) {
            File file;
            block19: {
                file = (File)value;
                try {
                    if (file.isFile()) {
                        if (IsisFish.vcs.getLocalStatus(file) == VCS.Status.STATUS_MODIFIED) {
                            if (selected) {
                                c.setForeground(new Color(188, 188, 255));
                            } else {
                                c.setForeground(Color.BLUE);
                            }
                        } else if (IsisFish.vcs.getLocalStatus(file) == VCS.Status.STATUS_ADDED) {
                            if (selected) {
                                c.setForeground(Color.GREEN.brighter());
                            } else {
                                c.setForeground(Color.GREEN.darker());
                            }
                        }
                    }
                }
                catch (VCSException e) {
                    if (!log.isErrorEnabled()) break block19;
                    log.error((Object)"Can't get file status", (Throwable)e);
                }
            }
            c.setText(file.getName());
            if (leaf) {
                c.setIcon(this.leafIcon);
            } else if (expanded) {
                c.setIcon(this.openIcon);
            } else {
                c.setIcon(this.closedIcon);
            }
            c.setFont(c.getFont().deriveFont(0));
        }
        return c;
    }
}

