/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.sensitivityexport;

import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.ui.util.TooltipHelper;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.nuiton.i18n.I18n;

public class SensitivityExportNameListRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -4070846632975105788L;
    protected Map<String, SensitivityExport> sensitivityExportCache = new HashMap<String, SensitivityExport>();

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        String exportName = (String)value;
        c.setText(exportName);
        try {
            SensitivityExport export = this.sensitivityExportCache.get(exportName);
            if (export == null) {
                SensitivityExportStorage storage = SensitivityExportStorage.getSensitivityExport(exportName);
                export = storage.getNewSensitivityExportInstance();
                this.sensitivityExportCache.put(exportName, export);
            }
            c.setToolTipText(export.getDescription());
        }
        catch (Exception e) {
            String errorTooltip = TooltipHelper.getErrorTooltip(I18n._((String)"isisfish.error.compile.fileerror", (Object[])new Object[]{exportName}));
            c.setToolTipText(errorTooltip);
        }
        return c;
    }
}

