/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.tree;

import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.Port;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.TripType;
import fr.ifremer.isisfish.entities.VesselType;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.ui.input.tree.FisheryDataProvider;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeNode;
import fr.ifremer.isisfish.ui.input.tree.loadors.CellsNodeLoador;
import fr.ifremer.isisfish.ui.input.tree.loadors.FisheryTreeNodeLoador;
import fr.ifremer.isisfish.ui.input.tree.loadors.GearsNodeLoador;
import fr.ifremer.isisfish.ui.input.tree.loadors.MetiersNodeLoador;
import fr.ifremer.isisfish.ui.input.tree.loadors.PortsNodeLoador;
import fr.ifremer.isisfish.ui.input.tree.loadors.SetOfVesselsNodeLoador;
import fr.ifremer.isisfish.ui.input.tree.loadors.SpeciesNodeLoador;
import fr.ifremer.isisfish.ui.input.tree.loadors.StrategiesNodeLoador;
import fr.ifremer.isisfish.ui.input.tree.loadors.TripTypesNodeLoador;
import fr.ifremer.isisfish.ui.input.tree.loadors.VesselTypesNodeLoador;
import fr.ifremer.isisfish.ui.input.tree.loadors.ZonesNodeLoador;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import jaxx.runtime.swing.nav.tree.NavTreeHelper;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;

public class FisheryTreeHelper
extends NavTreeHelper<FisheryTreeNode> {
    public Map<Class, FisheryTreeNodeLoador<? extends TopiaEntity>> loadorCache = new HashMap<Class, FisheryTreeNodeLoador<? extends TopiaEntity>>();

    public <T extends TopiaEntity> FisheryTreeNodeLoador<? extends TopiaEntity> getLoadorFor(Class<T> type) {
        return this.loadorCache.get(type);
    }

    public TreeModel createTreeModel(FisheryRegion fisheryRegion) {
        FisheryDataProvider provider = new FisheryDataProvider(fisheryRegion);
        this.setDataProvider(provider);
        FisheryTreeNode root = new FisheryTreeNode(FisheryRegion.class, fisheryRegion.getTopiaId(), null, null);
        this.loadorCache.put(Cell.class, new CellsNodeLoador());
        this.loadorCache.put(Zone.class, new ZonesNodeLoador());
        this.loadorCache.put(Port.class, new PortsNodeLoador());
        this.loadorCache.put(Species.class, new SpeciesNodeLoador());
        this.loadorCache.put(Gear.class, new GearsNodeLoador());
        this.loadorCache.put(Metier.class, new MetiersNodeLoador());
        this.loadorCache.put(TripType.class, new TripTypesNodeLoador());
        this.loadorCache.put(VesselType.class, new VesselTypesNodeLoador());
        this.loadorCache.put(SetOfVessels.class, new SetOfVesselsNodeLoador());
        this.loadorCache.put(Strategy.class, new StrategiesNodeLoador());
        CellsNodeLoador cellsNodeLoador = new CellsNodeLoador();
        FisheryTreeNode cellsChild = new FisheryTreeNode(Cell.class, I18n.n_((String)"isisfish.input.tree.cells", (Object[])new Object[0]), null, cellsNodeLoador);
        this.loadorCache.put(Cell.class, cellsNodeLoador);
        ZonesNodeLoador zonesNodeLoador = new ZonesNodeLoador();
        FisheryTreeNode zonesChild = new FisheryTreeNode(Zone.class, I18n.n_((String)"isisfish.input.tree.zones", (Object[])new Object[0]), null, zonesNodeLoador);
        this.loadorCache.put(Zone.class, zonesNodeLoador);
        PortsNodeLoador portsNodeLoador = new PortsNodeLoador();
        FisheryTreeNode portsChild = new FisheryTreeNode(Port.class, I18n.n_((String)"isisfish.input.tree.ports", (Object[])new Object[0]), null, portsNodeLoador);
        this.loadorCache.put(Port.class, portsNodeLoador);
        SpeciesNodeLoador speciesNodeLoador = new SpeciesNodeLoador();
        FisheryTreeNode speciesChild = new FisheryTreeNode(Species.class, I18n.n_((String)"isisfish.input.tree.species", (Object[])new Object[0]), null, speciesNodeLoador);
        this.loadorCache.put(Species.class, speciesNodeLoador);
        GearsNodeLoador gearsNodeLoador = new GearsNodeLoador();
        FisheryTreeNode gearsChild = new FisheryTreeNode(Gear.class, I18n.n_((String)"isisfish.input.tree.gears", (Object[])new Object[0]), null, gearsNodeLoador);
        this.loadorCache.put(Gear.class, gearsNodeLoador);
        MetiersNodeLoador metiersNodeLoador = new MetiersNodeLoador();
        FisheryTreeNode metiersChild = new FisheryTreeNode(Metier.class, I18n.n_((String)"isisfish.input.tree.metiers", (Object[])new Object[0]), null, metiersNodeLoador);
        this.loadorCache.put(Metier.class, metiersNodeLoador);
        TripTypesNodeLoador tripTypesNodeLoador = new TripTypesNodeLoador();
        FisheryTreeNode tripTypesChild = new FisheryTreeNode(TripType.class, I18n.n_((String)"isisfish.input.tree.triptypes", (Object[])new Object[0]), null, tripTypesNodeLoador);
        this.loadorCache.put(TripType.class, tripTypesNodeLoador);
        VesselTypesNodeLoador vesselTypesNodeLoador = new VesselTypesNodeLoador();
        FisheryTreeNode vesselTypesChild = new FisheryTreeNode(VesselType.class, I18n.n_((String)"isisfish.input.tree.vesseltypes", (Object[])new Object[0]), null, vesselTypesNodeLoador);
        this.loadorCache.put(VesselType.class, vesselTypesNodeLoador);
        SetOfVesselsNodeLoador setOfVesselsNodeLoador = new SetOfVesselsNodeLoador();
        FisheryTreeNode setOfVesselsChild = new FisheryTreeNode(SetOfVessels.class, I18n.n_((String)"isisfish.input.tree.setofvessels", (Object[])new Object[0]), null, setOfVesselsNodeLoador);
        this.loadorCache.put(SetOfVessels.class, setOfVesselsNodeLoador);
        StrategiesNodeLoador strategiesNodeLoador = new StrategiesNodeLoador();
        FisheryTreeNode strategiesChild = new FisheryTreeNode(Strategy.class, I18n.n_((String)"isisfish.input.tree.strategies", (Object[])new Object[0]), null, strategiesNodeLoador);
        this.loadorCache.put(Strategy.class, strategiesNodeLoador);
        root.add(cellsChild);
        root.add(zonesChild);
        root.add(portsChild);
        root.add(speciesChild);
        root.add(gearsChild);
        root.add(metiersChild);
        root.add(tripTypesChild);
        root.add(vesselTypesChild);
        root.add(setOfVesselsChild);
        root.add(strategiesChild);
        DefaultTreeModel model = this.createModel(root, new Object[0]);
        return model;
    }
}

