/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.sensitivity;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityAnalysis;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityException;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.RException;
import org.nuiton.j2r.RProxy;
import org.nuiton.util.FileUtil;

public abstract class AbstractSensitivityAnalysis
implements SensitivityAnalysis {
    private static Log log = LogFactory.getLog(AbstractSensitivityAnalysis.class);

    public void setIsisFactorsR(DesignPlan plan, File outputdirectory) throws SensitivityException {
        String nomFacteur = "nomFacteur<-c(%s)";
        String factorNames = "";
        String nominal = "Nominal<-c(%s)";
        String nominalValues = "";
        String continu = "Continu<-c(%s)";
        String continuValues = "";
        String binf = "Binf<-c(%s)";
        String binfValues = "";
        String bsup = "Bsup<-c(%s)";
        String bsupValues = "";
        String attribute = "attr(isis.factors,\"%s\")<-\"%s\"";
        String isisfactors = "isis.factors<-data.frame(\"nomFacteur\"=nomFacteur,\"Nominal\"=Nominal,\"Continu\"=Continu,\"Binf\"=Binf,\"Bsup\"=Bsup)";
        List<Factor> factors = plan.getFactors();
        for (Factor factor : factors) {
            if (!(factor instanceof FactorGroup) || !((FactorGroup)factor).isDiscrete()) continue;
            System.out.println("Discrete group");
            List<Factor> subfactors = ((FactorGroup)factor).getFactors();
            int cardinality = subfactors.get(0).getCardinality();
            for (Factor subfactor : subfactors) {
                if (subfactor.getCardinality() == cardinality) continue;
                throw new SensitivityException("All the factors of group " + factor.getName() + " do not have the same cardinality");
            }
        }
        for (int i = 0; i < factors.size(); ++i) {
            Factor factor;
            factor = factors.get(i);
            if (i != 0) {
                factorNames = factorNames + ",";
                nominalValues = nominalValues + ",";
                continuValues = continuValues + ",";
                binfValues = binfValues + ",";
                bsupValues = bsupValues + ",";
            }
            factorNames = factorNames + "\"" + factor.getName() + "\"";
            if (factor.getDomain() instanceof ContinuousDomain) {
                nominalValues = nominalValues + "\"" + factor.getNominalValue() + "\"";
                continuValues = continuValues + "TRUE";
                binfValues = binfValues + ((ContinuousDomain)factor.getDomain()).getCalculatorMinBound();
                bsupValues = bsupValues + ((ContinuousDomain)factor.getDomain()).getCalculatorMaxBound();
                continue;
            }
            nominalValues = nominalValues + "\"" + factor.getNominalValue() + "\"";
            continuValues = continuValues + "FALSE";
            binfValues = binfValues + "0.0";
            bsupValues = bsupValues + ((DiscreteDomain)factor.getDomain()).getValues().size();
        }
        try {
            RProxy engine = new RProxy();
            engine.clearSession();
            String Rcall = String.format(nomFacteur, factorNames);
            engine.voidEval(Rcall);
            Rcall = String.format(nominal, nominalValues);
            engine.voidEval(Rcall);
            Rcall = String.format(continu, continuValues);
            engine.voidEval(Rcall);
            Rcall = String.format(binf, binfValues);
            engine.voidEval(Rcall);
            Rcall = String.format(bsup, bsupValues);
            engine.voidEval(Rcall);
            engine.voidEval(isisfactors);
            Rcall = String.format(attribute, "nomModel", "isis-fish-externeR");
            engine.voidEval(Rcall);
            for (Factor factor : factors) {
                if (!(factor.getDomain() instanceof DiscreteDomain)) continue;
                String attributeValues = "list(";
                Collection<Object> values = ((DiscreteDomain)factor.getDomain()).getValues().values();
                for (Object j : values) {
                    attributeValues = attributeValues + j + ",";
                }
                attributeValues = attributeValues.substring(0, attributeValues.length() - 1);
                attributeValues = attributeValues + ")";
                Rcall = String.format(attribute, factor.getName(), attributeValues);
                engine.voidEval(Rcall);
            }
            engine.saveRData(outputdirectory.getParentFile(), outputdirectory.getName());
        }
        catch (RException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"R evaluation failed", (Throwable)eee);
            }
            throw new SensitivityException("R evaluation failed", eee);
        }
    }

    protected String editRInstruction(String rCall) {
        JLabel label = new JLabel("Modifier le code R envoy\u00e9 si vous le souhaitez");
        JTextPane text = new JTextPane();
        text.setText(rCall);
        text.setSize(400, 400);
        text.setPreferredSize(text.getSize());
        Box box = Box.createVerticalBox();
        box.add(label);
        box.add(new JScrollPane(text));
        JOptionPane.showMessageDialog(null, box, "R modif", 3);
        return text.getText();
    }

    protected void testNoDiscrete(List<Factor> factors) throws SensitivityException {
        for (Factor factor : factors) {
            if (!(factor.getDomain() instanceof DiscreteDomain)) continue;
            throw new SensitivityException(factor.getName() + " has a discrete domain, this is not acceptable for " + "this method.");
        }
    }

    protected String createImportInstruction(SensitivityExport export, List<SimulationStorage> simulationStorages) {
        String name = export.getExportFilename();
        String extension = export.getExtensionFilename();
        String rInstruction = name + "<-c(";
        for (int l = 0; l < simulationStorages.size(); ++l) {
            SimulationStorage simulationStorage = simulationStorages.get(l);
            File directory = simulationStorage.getDirectory();
            String directoryPath = directory.toString() + File.separator + "resultExports";
            File importFile = new File(directoryPath, name + extension);
            String simulResult = "";
            try {
                simulResult = FileUtil.readAsString((File)importFile);
            }
            catch (IOException ioe) {
                log.error((Object)("An error occured trying to read a result file : " + ioe.getMessage()));
            }
            double simulationResult = Double.valueOf(simulResult);
            rInstruction = l < simulationStorages.size() - 1 ? rInstruction + simulationResult + "," : rInstruction + simulationResult;
        }
        rInstruction = rInstruction + ")";
        return rInstruction;
    }

    protected void renameObjects(REngine engine, String simulationName) throws RException {
        String renameIsisSimule = "%s.isis.simule<-isis.simule";
        String renameIsisFactorDistribution = "%s.isis.factor.distribution<-isis.factor.distribution";
        String renameIsisFactor = "%s.isis.factor<-isis.factors";
        String renameIsisMethodExp = "%s.isis.methodExp<-isis.MethodExp";
        engine.voidEval(String.format(renameIsisSimule, simulationName));
        engine.voidEval(String.format(renameIsisFactorDistribution, simulationName));
        engine.voidEval(String.format(renameIsisFactor, simulationName));
        engine.voidEval(String.format(renameIsisMethodExp, simulationName));
    }
}

