/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.launcher;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.launcher.SimulationItem;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulatorLauncher;
import fr.ifremer.isisfish.util.CompileHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;

public class SubProcessSimulationLauncher
implements SimulatorLauncher {
    protected static Log log = LogFactory.getLog(SubProcessSimulationLauncher.class);

    public String toString() {
        return I18n._((String)"isisfish.simulator.launcher.subprocess", (Object[])new Object[0]);
    }

    @Override
    public void simulate(SimulationService simulationService, SimulationItem simulationItem) throws RemoteException {
        block3: {
            SimulationControl control = simulationItem.getControl();
            File simulationZip = simulationItem.getSimulationZip();
            String simulationPrescript = simulationItem.getSimulationPrescriptContent();
            String simulationId = control.getId();
            SimulationStorage simulation = null;
            try {
                simulation = this.subProcessSimulate(control, simulationZip, simulationPrescript);
            }
            catch (Exception eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)I18n._((String)"Can't do simulation %s", (Object[])new Object[]{simulationId}), (Throwable)eee);
                }
                if (simulation == null) break block3;
                simulation.getInformation().setException(eee);
            }
        }
    }

    @Override
    public int maxSimulationThread() {
        int result = Runtime.getRuntime().availableProcessors();
        return result;
    }

    @Override
    public int getCheckProgressionInterval() {
        int interval = 5;
        return interval;
    }

    protected void message(SimulationControl control, String message) {
        log.info((Object)message);
        if (control != null) {
            control.setText(message);
        }
    }

    public SimulationStorage subProcessSimulate(SimulationControl control, File simulationZip, String simulationPrescript) throws Exception {
        String rType;
        this.message(control, I18n._((String)"isisfish.message.simulation.prepare", (Object[])new Object[0]));
        String simulationId = control.getId();
        File tempPrescriptFile = null;
        if (!StringUtils.isEmpty((CharSequence)simulationPrescript)) {
            tempPrescriptFile = File.createTempFile("isis", ".prescript");
            tempPrescriptFile.deleteOnExit();
            FileUtil.writeString((File)tempPrescriptFile, (String)simulationPrescript);
        }
        String java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        String classpath = CompileHelper.getClassPathAsString(new ArrayList<File>());
        if (classpath == null) {
            String pathSep = File.pathSeparator;
            ClassLoader loader = IsisFish.class.getClassLoader();
            if (loader instanceof URLClassLoader) {
                URLClassLoader urlLoader = (URLClassLoader)loader;
                StringBuilder buffer = new StringBuilder();
                for (URL url : urlLoader.getURLs()) {
                    buffer.append(pathSep).append(url.getPath());
                }
                classpath = buffer.substring(1);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("classpath to use : " + classpath));
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(java);
        command.add("-Xmx1024M");
        String libraryPath = System.getProperty("java.library.path");
        if (StringUtils.isNotBlank((CharSequence)libraryPath)) {
            command.add("-Djava.library.path=\"" + libraryPath + "\"");
        }
        if (StringUtils.isNotBlank((CharSequence)(rType = System.getProperty("R.type")))) {
            command.add("-DR.type=\"" + rType + "\"");
        }
        command.add("-classpath");
        command.add(classpath);
        command.add(IsisFish.class.getName());
        command.add("--option");
        command.add("launch.ui");
        command.add("false");
        ProcessBuilder processBuilder = null;
        if (tempPrescriptFile != null) {
            command.add("--simulateWithSimulationAndScript");
            command.add(simulationId);
            command.add(simulationZip.getAbsolutePath());
            command.add(tempPrescriptFile.getAbsolutePath());
        } else {
            command.add("--simulateWithSimulation");
            command.add(simulationId);
            command.add(simulationZip.getAbsolutePath());
        }
        processBuilder = new ProcessBuilder(command);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        if (log.isInfoEnabled()) {
            log.info((Object)I18n._((String)"SubProcess start: %s %s", (Object[])new Object[]{process, processBuilder.command()}));
        }
        SimulationCheckpointExternalProcessThread monitor = new SimulationCheckpointExternalProcessThread(control, simulationId, process);
        monitor.start();
        int status = process.waitFor();
        if (log.isInfoEnabled()) {
            log.info((Object)("SubProcess finished (status = " + status + ")"));
        }
        SimulationStorage result = SimulationStorage.getSimulation(simulationId);
        return result;
    }

    @Override
    public SimulationStorage getSimulationStorage(SimulationService simulationService, SimulationControl control) throws RemoteException {
        String simulationId = control.getId();
        SimulationStorage result = SimulationStorage.getSimulation(simulationId);
        return result;
    }

    @Override
    public void updateControl(SimulationService simulationService, SimulationControl control) throws RemoteException {
        String simulationId = control.getId();
        SimulationStorage.readControl(simulationId, control, "stop");
    }

    @Override
    public void simulationStopRequest(SimulationJob job) {
    }

    protected class SimulationCheckpointExternalProcessThread
    extends Thread {
        protected SimulationControl control = null;
        protected String simulationId = null;
        protected Process process = null;
        protected InputStream out = null;

        public SimulationCheckpointExternalProcessThread(SimulationControl control, String simulationId, Process process) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Lancement du thread de surveillance des simulations externes");
            }
            this.control = control;
            this.simulationId = simulationId;
            this.process = process;
            this.out = process.getInputStream();
        }

        @Override
        public void run() {
            block5: {
                InputStreamReader osr = new InputStreamReader(this.out);
                BufferedReader br = new BufferedReader(osr);
                String line = null;
                try {
                    while ((line = br.readLine()) != null) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)(SubProcessSimulationLauncher.this.toString() + ">" + line));
                        }
                        if (this.control.isStopSimulationRequest()) {
                            this.process.destroy();
                            this.control.stopSimulation();
                        }
                        if (this.control.isRunning()) continue;
                        return;
                    }
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)I18n._((String)"isisfish.simulator.subprocess.readoutput.error", (Object[])new Object[0]), (Throwable)e);
                }
            }
        }
    }
}

