/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.launcher;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.SimulationInformation;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationParameterImpl;
import fr.ifremer.isisfish.simulator.launcher.SimulationItem;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulatorLauncher;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityAnalysis;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SimulationMonitor
extends Thread {
    private static Log log = LogFactory.getLog(SimulationMonitor.class);
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected static final String PROPERTIES_FILE = "monitoring.properties";
    protected static final String PROPERTY_LAUNCHER = "simulation.launcher";
    protected static final String PROPERTY_DATE = "simulation.date";
    protected static final String PROPERTY_ZIP = "simulation.zip";
    protected static final String PROPERTY_STANDALONE = "simulation.standalone";
    protected static final String PROPERTY_LASTSIMULATION = "simulation.last";
    protected static SimulationMonitor instance = new SimulationMonitor();
    protected File monitorFolder = IsisFish.config.getMonitoringDirectory();
    protected SortedSet<AbstractMap.SimpleEntry<Date, SimulationJob>> checkSet = new TreeSet<AbstractMap.SimpleEntry<Date, SimulationJob>>(new Comparator<AbstractMap.SimpleEntry<Date, SimulationJob>>(){

        @Override
        public int compare(AbstractMap.SimpleEntry<Date, SimulationJob> o1, AbstractMap.SimpleEntry<Date, SimulationJob> o2) {
            int result = o1.getKey().compareTo(o2.getKey());
            if (result == 0) {
                result = o1.getValue().compareTo(o2.getValue());
            }
            return result;
        }
    });
    protected Timer checkScheduler = new Timer();

    protected SimulationMonitor() {
        super("monitor-thread");
    }

    public static SimulationMonitor getInstance() {
        return instance;
    }

    public void reloadConfig(final SimulationService service) {
        new Thread(){

            @Override
            public void run() {
                SimulationMonitor.this.restartSimulationProgression(service);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restartSimulationProgression(SimulationService service) {
        File[] files;
        for (File file : files = this.monitorFolder.listFiles()) {
            File propertiesFile;
            if (!file.isDirectory()) continue;
            String simulationId = file.getName();
            if (log.isInfoEnabled()) {
                log.info((Object)("Restart monitoring of " + simulationId));
            }
            if ((propertiesFile = new File(file, PROPERTIES_FILE)).isFile()) {
                BufferedInputStream propertiesFileIS = null;
                try {
                    propertiesFileIS = new BufferedInputStream(new FileInputStream(propertiesFile));
                    Properties simulationProperties = new Properties();
                    simulationProperties.load(propertiesFileIS);
                    this.restartSimulation(service, file, simulationId, simulationProperties);
                }
                catch (IOException e) {
                    block7: {
                        try {
                            if (!log.isErrorEnabled()) break block7;
                            log.error((Object)"Can't get launcher for this simulation", (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(propertiesFileIS);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)propertiesFileIS);
                    continue;
                }
                IOUtils.closeQuietly((InputStream)propertiesFileIS);
                continue;
            }
            if (!log.isWarnEnabled()) continue;
            log.warn((Object)("No monitoring.properties found in " + file.getAbsolutePath() + "(skipping restarting)"));
        }
    }

    protected void restartSimulation(SimulationService service, File simulationFolder, String simulationId, Properties propertiesFile) throws IOException {
        block6: {
            try {
                String simulationLauncher = propertiesFile.getProperty(PROPERTY_LAUNCHER);
                SimulatorLauncher launcher = (SimulatorLauncher)Class.forName(simulationLauncher).newInstance();
                String zipFileName = propertiesFile.getProperty(PROPERTY_ZIP);
                File zipFile = new File(simulationFolder, zipFileName);
                File tempZipFile = File.createTempFile("simulation-" + simulationId, ".zip");
                FileUtils.copyFile((File)zipFile, (File)tempZipFile);
                tempZipFile.deleteOnExit();
                SimulationParameterImpl params = new SimulationParameterImpl();
                SimulationControl control = new SimulationControl(simulationId);
                SimulationItem item = new SimulationItem(control, params);
                item.setSimulationZip(tempZipFile);
                String standalone = propertiesFile.getProperty(PROPERTY_STANDALONE);
                item.setStandaloneSimulation(!"false".equalsIgnoreCase(standalone));
                String lastSimulation = propertiesFile.getProperty(PROPERTY_LASTSIMULATION);
                item.setLastSimulation("true".equalsIgnoreCase(lastSimulation));
                SimulationJob job = new SimulationJob(service, item, 0);
                job.setLauncher(launcher);
                service.submitForCheckOnly(job);
            }
            catch (ClassNotFoundException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't found launcher for this simulation", (Throwable)e);
                }
            }
            catch (InstantiationException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't get launcher for this simulation", (Throwable)e);
                }
            }
            catch (IllegalAccessException e) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Can't get launcher for this simulation", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void simulationStart(SimulationJob job) {
        block17: {
            block15: {
                Properties simulationProperties;
                File simulationPropertiesFile;
                SimulationItem simulationItem;
                String simulationId;
                block13: {
                    simulationId = job.getId();
                    simulationItem = job.getItem();
                    File simulationMonitoringFolder = new File(this.monitorFolder, simulationId);
                    if (!simulationMonitoringFolder.exists()) {
                        simulationMonitoringFolder.mkdirs();
                    }
                    if ((simulationPropertiesFile = new File(simulationMonitoringFolder, PROPERTIES_FILE)).exists()) break block15;
                    simulationProperties = new Properties();
                    SimulatorLauncher launcher = job.getLauncher();
                    String launcherName = launcher.getClass().getName();
                    simulationProperties.setProperty(PROPERTY_LAUNCHER, launcherName);
                    String simulationDate = dateFormat.format(new Date());
                    simulationProperties.setProperty(PROPERTY_DATE, simulationDate);
                    File zipFile = simulationItem.getSimulationZip();
                    try {
                        if (simulationItem.isStandaloneSimulationZip()) {
                            FileUtils.copyFileToDirectory((File)zipFile, (File)simulationMonitoringFolder);
                            simulationProperties.setProperty(PROPERTY_ZIP, zipFile.getName());
                        } else {
                            String shortSimulationId = simulationId.substring(0, simulationId.lastIndexOf(95));
                            File savedZipFile = new File(simulationMonitoringFolder.getParent(), shortSimulationId + ".zip");
                            if (simulationItem.getSimulationNumber() == 0) {
                                FileUtils.copyFile((File)zipFile, (File)savedZipFile);
                            }
                            simulationProperties.setProperty(PROPERTY_ZIP, ".." + File.separator + savedZipFile.getName());
                        }
                    }
                    catch (IOException e) {
                        if (!log.isErrorEnabled()) break block13;
                        log.error((Object)"Can't copy simulation zip", (Throwable)e);
                    }
                }
                simulationProperties.setProperty(PROPERTY_STANDALONE, String.valueOf(simulationItem.isStandaloneSimulation()));
                simulationProperties.setProperty(PROPERTY_LASTSIMULATION, String.valueOf(simulationItem.isLastSimulation()));
                BufferedOutputStream out = null;
                try {
                    out = new BufferedOutputStream(new FileOutputStream(simulationPropertiesFile));
                    simulationProperties.store(out, "Simulation added : " + simulationId);
                }
                catch (IOException e) {
                    block14: {
                        try {
                            if (!log.isErrorEnabled()) break block14;
                            log.error((Object)"Can't save monitor file", (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(out);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                }
                IOUtils.closeQuietly((OutputStream)out);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Saving simulation " + simulationId + " as started"));
                }
                break block17;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"We already know information about this simulation");
                log.debug((Object)"Skip simulation information saving");
            }
        }
        Date checkDate = new Date();
        this.checkSet.add(new AbstractMap.SimpleEntry<Date, SimulationJob>(checkDate, job));
        if (!this.isAlive()) {
            this.start();
        }
    }

    public synchronized void simulationStop(SimulationJob job) {
        String simulationId;
        block3: {
            simulationId = job.getId();
            File simulationMonitoringFolder = new File(this.monitorFolder, simulationId);
            try {
                FileUtils.deleteDirectory((File)simulationMonitoringFolder);
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't remove simulation informations", (Throwable)e);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Saving simulation " + simulationId + " as stopped"));
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.waitAndCheckProgression();
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"An exception occurs durring monitoring", (Throwable)e);
                continue;
            }
            break;
        }
    }

    protected void waitAndCheckProgression() {
        block10: {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                if (!log.isErrorEnabled()) break block10;
                log.error((Object)"Monitor thread has been interrupted", (Throwable)e);
            }
        }
        if (!this.checkSet.isEmpty()) {
            Date now;
            AbstractMap.SimpleEntry<Date, SimulationJob> firstEntry = this.checkSet.first();
            Date date = firstEntry.getKey();
            if (date.before(now = new Date())) {
                SimulationJob job = firstEntry.getValue();
                SimulatorLauncher launcher = job.getLauncher();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Check simulation progression : " + job.getId()));
                }
                boolean jobIsFinished = this.checkProgression(job, launcher);
                this.checkSet.remove(firstEntry);
                if (jobIsFinished) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Job " + job.getId() + " finished"));
                    }
                    this.doPostSimulationOperation(job, launcher);
                } else {
                    long nextJobTimeMs = date.getTime() + (long)(launcher.getCheckProgressionInterval() * 1000);
                    Date nextJobDate = new Date(nextJobTimeMs);
                    this.checkSet.add(new AbstractMap.SimpleEntry<Date, SimulationJob>(nextJobDate, job));
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("Time to check not reached, skip check, " + date + " < " + now));
            }
        }
    }

    protected boolean checkProgression(SimulationJob job, SimulatorLauncher launcher) {
        boolean simulationEnded;
        block9: {
            simulationEnded = false;
            SimulationService service = SimulationService.getService();
            SimulationControl control = job.getItem().getControl();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking simulation progression : " + control.getId()));
                log.debug((Object)(" with launcher = " + launcher));
            }
            try {
                if (control.isStopSimulationRequest()) {
                    launcher.simulationStopRequest(job);
                    simulationEnded = true;
                } else {
                    launcher.updateControl(service, control);
                    File simulationRoot = SimulationStorage.getSimulationDirectory(control.getId());
                    if (simulationRoot.isDirectory()) {
                        if (control.getProgress() > 0L && control.getProgress() >= control.getProgressMax()) {
                            simulationEnded = true;
                        } else {
                            File informationFile = SimulationStorage.getSimulationInformationFile(simulationRoot);
                            SimulationInformation information = new SimulationInformation(informationFile);
                            if (StringUtils.isNotEmpty((CharSequence)information.getException())) {
                                simulationEnded = true;
                            }
                        }
                    }
                }
            }
            catch (RemoteException e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Progression thread update error", (Throwable)e);
            }
        }
        return simulationEnded;
    }

    protected boolean doPostSimulationOperation(SimulationJob job, SimulatorLauncher launcher) {
        boolean result;
        block11: {
            result = false;
            SimulationService service = SimulationService.getService();
            SimulationControl control = job.getItem().getControl();
            if (log.isInfoEnabled()) {
                log.info((Object)("Do post simulation operation for " + control.getId()));
            }
            try {
                SimulationStorage simulation = launcher.getSimulationStorage(service, control);
                if (simulation != null) {
                    if (!control.isStopSimulationRequest()) {
                        boolean simulationAvailable = true;
                        for (SimulationJob.PostAction action : job.getPostActions()) {
                            try {
                                action.finished(job, simulation);
                            }
                            catch (Exception eee) {
                                if (!log.isErrorEnabled()) continue;
                                log.error((Object)I18n._((String)"Can't do post action %s", (Object[])new Object[]{action}), (Throwable)eee);
                            }
                        }
                        if (simulationAvailable) {
                            this.analyzeSensitivityResult(job, simulation);
                        }
                    }
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"Check null simulation check (launcher return null simulation)");
                }
                this.simulationStop(job);
                service.fireStopEvent(job);
                result = true;
            }
            catch (RemoteException e) {
                if (!log.isErrorEnabled()) break block11;
                log.error((Object)"Can't get simulation results after simulation end", (Throwable)e);
            }
        }
        return result;
    }

    protected void analyzeSensitivityResult(SimulationJob job, SimulationStorage simulation) {
        block6: {
            SimulationParameter params = simulation.getParameter();
            int numberOfSimulation = params.getNumberOfSensitivitySimulation();
            if (numberOfSimulation > 0) {
                SimulationControl control = job.getItem().getControl();
                control.setText(I18n._((String)"isisfish.simulation.message.lookingforlast", (Object[])new Object[0]));
                String simulationId = job.getId();
                String simulationCommonPrefix = simulationId.substring(0, simulationId.lastIndexOf("_"));
                int numberFinished = this.getNumberOfFinishedSimulation(simulationCommonPrefix, numberOfSimulation);
                if (numberFinished == numberOfSimulation) {
                    control.setText(I18n._((String)"isisfish.simulation.message.analyzeResults", (Object[])new Object[0]));
                    SensitivityAnalysis sensitivityAnalysis = params.getSensitivityAnalysis();
                    if (sensitivityAnalysis != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Call analyzeResult on sensitivity script " + sensitivityAnalysis.getClass().getSimpleName()));
                        }
                        try {
                            List<SimulationStorage> simulationStorageForAnalyze = this.getStorageListForSecondPass(simulationCommonPrefix, numberOfSimulation);
                            File masterExportDirectory = new File(SimulationStorage.getSensitivityResultsDirectory(), simulationCommonPrefix);
                            sensitivityAnalysis.analyzeResult(simulationStorageForAnalyze, masterExportDirectory);
                        }
                        catch (SensitivityException e) {
                            if (!log.isErrorEnabled()) break block6;
                            log.error((Object)"Can't call analyse result", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    protected int getNumberOfFinishedSimulation(String asPrefixName, int numberOfSimulation) {
        String currentId;
        int numberOfFinishedSimulation = 0;
        for (int simulationIndex = numberOfSimulation - 1; simulationIndex >= 0 && SimulationStorage.localyExists(currentId = asPrefixName + "_" + simulationIndex); --simulationIndex) {
            SimulationControl currentSimulationControl = new SimulationControl(currentId);
            SimulationStorage.readControl(currentId, currentSimulationControl, new String[0]);
            if (currentSimulationControl.getProgress() > 0L && currentSimulationControl.getProgress() >= currentSimulationControl.getProgressMax()) {
                ++numberOfFinishedSimulation;
                continue;
            }
            if (!log.isDebugEnabled()) break;
            log.debug((Object)("Miss simulation number = " + simulationIndex));
            break;
        }
        return numberOfFinishedSimulation;
    }

    protected List<SimulationStorage> getStorageListForSecondPass(String asPrefixName, int numberOfSimulation) {
        LinkedList<SimulationStorage> simulationStorageForAnalyze = new LinkedList<SimulationStorage>();
        for (int simulationIndex = 0; simulationIndex < numberOfSimulation; ++simulationIndex) {
            String currentId = asPrefixName + "_" + simulationIndex;
            SimulationStorage storage = SimulationStorage.getSimulation(currentId);
            simulationStorageForAnalyze.add(storage);
        }
        return simulationStorageForAnalyze;
    }
}

