/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.launcher;

import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationParameterCache;
import java.io.File;

public class SimulationItem {
    protected SimulationControl control;
    protected SimulationParameter parameter;
    protected File simulationZip;
    protected boolean standaloneSimulationZip = true;
    protected String simulationPrescriptContent;
    protected boolean standaloneSimulation = true;
    protected int simulationNumber = -1;
    protected boolean lastSimulation;

    public SimulationItem(SimulationControl control, SimulationParameter param) {
        this.control = control;
        if (param != null) {
            this.parameter = new SimulationParameterCache(param);
        }
    }

    public SimulationControl getControl() {
        return this.control;
    }

    public SimulationParameter getParameter() {
        return this.parameter;
    }

    public void setSimulationZip(File simulationZip) {
        this.simulationZip = simulationZip;
    }

    public File getSimulationZip() {
        return this.simulationZip;
    }

    public boolean isStandaloneSimulationZip() {
        return this.standaloneSimulationZip;
    }

    public void setStandaloneSimulationZip(boolean standaloneSimulationZip) {
        this.standaloneSimulationZip = standaloneSimulationZip;
    }

    public String getSimulationPrescriptContent() {
        String preScript = this.simulationPrescriptContent;
        if (preScript == null && this.parameter != null && this.parameter.getUsePreScript()) {
            preScript = this.parameter.getPreScript();
        }
        return preScript;
    }

    public void setSimulationPrescriptContent(String simulationPrescriptContent) {
        this.simulationPrescriptContent = simulationPrescriptContent;
    }

    public boolean isStandaloneSimulation() {
        return this.standaloneSimulation;
    }

    public void setStandaloneSimulation(boolean standaloneSimulation) {
        this.standaloneSimulation = standaloneSimulation;
    }

    public int getSimulationNumber() {
        return this.simulationNumber;
    }

    public void setSimulationNumber(int simulationNumber) {
        this.simulationNumber = simulationNumber;
    }

    public boolean isLastSimulation() {
        return this.lastSimulation;
    }

    public void setLastSimulation(boolean lastSimulation) {
        this.lastSimulation = lastSimulation;
    }
}

