/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.export.ExportHelper;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationListener;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimulationExportResultWrapper
implements SimulationListener {
    private static Log log = LogFactory.getLog(SimulationExportResultWrapper.class);

    @Override
    public void afterSimulation(SimulationContext context) {
        List<SensitivityExport> sensitivityExports;
        SimulationStorage simulation = context.getSimulationStorage();
        SimulationParameter parameters = simulation.getParameter();
        File rootDirectory = simulation.getDirectory();
        ArrayList<Export> allExports = new ArrayList<Export>();
        if (parameters.getExportNames() != null) {
            for (String exportName : parameters.getExportNames()) {
                try {
                    ExportStorage storage = ExportStorage.getExport(exportName);
                    Export export = storage.getNewExportInstance();
                    allExports.add(export);
                }
                catch (IsisFishException e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("Can't get export instance " + exportName), (Throwable)e);
                }
            }
        }
        if ((sensitivityExports = parameters.getSensitivityExport()) != null) {
            allExports.addAll(sensitivityExports);
        }
        if (!allExports.isEmpty()) {
            File exportDir = SimulationStorage.getResultExportDirectory(rootDirectory);
            exportDir.mkdirs();
            ExportHelper.doExport(simulation, exportDir, allExports, rootDirectory);
        }
    }

    @Override
    public void beforeSimulation(SimulationContext context) {
    }
}

