/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.types.TimeStep;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimulationControl
implements PropertyChangeListener {
    private static Log log = LogFactory.getLog(SimulationControl.class);
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    protected boolean inUpdateFromProperties = false;
    protected transient SimulationStorage simulation = null;
    protected String id = null;
    protected boolean started = false;
    protected boolean running = true;
    protected boolean stop = false;
    protected TimeStep step;
    protected long progressMax = 0L;
    protected long progress = 0L;
    protected String text = "";
    protected transient boolean autoSaveState = false;

    public SimulationControl(String id) {
        this.id = id;
        this.addPropertyChangeListener(this);
    }

    public void setAutoSaveState(boolean autoSaveState) {
        this.autoSaveState = autoSaveState;
    }

    public boolean isAutoSaveState() {
        return this.autoSaveState;
    }

    public void reset() {
        this.started = false;
        this.running = true;
        this.stop = false;
        this.step = null;
        this.progressMax = 0L;
        this.progress = 0L;
    }

    public SimulationStorage getSimulation() {
        if (this.simulation == null) {
            this.simulation = SimulationStorage.getSimulation(this.id);
        }
        return this.simulation;
    }

    public void addPropertyChangeListener(String propName, PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(propName, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String propName, PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(propName, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        boolean oldValue = this.started;
        this.started = started;
        this.listeners.firePropertyChange("started", oldValue, this.started);
    }

    public boolean isRunning() {
        return this.running;
    }

    private void setRunning(boolean running) {
        boolean oldValue = this.running;
        this.running = running;
        this.listeners.firePropertyChange("running", oldValue, this.running);
    }

    public void startSimulation() {
        this.setRunning(true);
    }

    public void stopSimulation() {
        this.setRunning(false);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (log.isInfoEnabled()) {
            log.info((Object)text);
        }
        String oldValue = this.text;
        this.text = text;
        this.listeners.firePropertyChange("text", oldValue, this.text);
    }

    public long getProgressMax() {
        return this.progressMax;
    }

    public void setProgressMax(long progressMax) {
        long oldValue = this.progressMax;
        this.progressMax = progressMax;
        this.listeners.firePropertyChange("progressMax", oldValue, this.progressMax);
    }

    public long getProgress() {
        return this.progress;
    }

    public void setProgress(long progress) {
        long oldValue = this.progress;
        this.progress = progress;
        if (log.isTraceEnabled()) {
            log.trace((Object)("control fire event 'progress' (" + oldValue + "/" + this.progress));
        }
        this.listeners.firePropertyChange("progress", oldValue, this.progress);
    }

    public void setStopSimulationRequest(boolean val) {
        boolean oldValue = this.stop;
        this.stop = val;
        this.listeners.firePropertyChange("stop", oldValue, this.stop);
    }

    public boolean isStopSimulationRequest() {
        return this.stop;
    }

    public String getId() {
        return this.id;
    }

    public TimeStep getStep() {
        return this.step;
    }

    public void setStep(TimeStep t) {
        int oldValue = 0;
        if (this.step != null) {
            oldValue = this.step.getStep();
        }
        this.step = t;
        this.listeners.firePropertyChange("step", oldValue, this.step.getStep());
    }

    public Properties getProperties() {
        Properties result = new Properties();
        result.setProperty("id", this.id);
        result.setProperty("started", String.valueOf(this.started));
        result.setProperty("running", String.valueOf(this.running));
        result.setProperty("stop", String.valueOf(this.stop));
        if (this.step != null) {
            result.setProperty("step", String.valueOf(this.step.getStep()));
        }
        result.setProperty("progressMax", String.valueOf(this.progressMax));
        result.setProperty("progress", String.valueOf(this.progress));
        result.setProperty("text", this.text);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFromProperties(Properties props) {
        this.inUpdateFromProperties = true;
        if (log.isTraceEnabled()) {
            log.trace((Object)("updateFromProperties properties = " + props.toString()));
        }
        try {
            if (props.containsKey("started")) {
                boolean started = "true".equalsIgnoreCase(props.getProperty("started"));
                this.setStarted(started);
            }
            if (props.containsKey("running")) {
                boolean running = "true".equalsIgnoreCase(props.getProperty("running"));
                this.setRunning(running);
            }
            if (props.containsKey("stop")) {
                boolean stop = "true".equalsIgnoreCase(props.getProperty("stop"));
                this.setStopSimulationRequest(stop);
            }
            if (props.containsKey("step")) {
                TimeStep step = new TimeStep(Integer.parseInt(props.getProperty("step")));
                this.setStep(step);
            }
            if (props.containsKey("progressMax")) {
                long progressMax = Long.parseLong(props.getProperty("progressMax"));
                this.setProgressMax(progressMax);
            }
            if (props.containsKey("progress")) {
                long progress = Long.parseLong(props.getProperty("progress"));
                this.setProgress(progress);
            }
            if (props.containsKey("text")) {
                String text = props.getProperty("text");
                this.setText(text);
            }
        }
        finally {
            this.inUpdateFromProperties = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (!this.inUpdateFromProperties && this.isAutoSaveState() && this.getSimulation() != null) {
            this.getSimulation().saveControl(this);
        }
    }
}

