/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.simulator.SimulationResultGetter;
import fr.ifremer.isisfish.simulator.SimulationResultListener;
import fr.ifremer.isisfish.types.TimeStep;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;

public class ResultManager {
    private static Log log = LogFactory.getLog(ResultManager.class);
    protected SimulationContext context = null;
    protected Set<SimulationResultListener> listeners = new LinkedHashSet<SimulationResultListener>();
    protected SimulationResultGetter getter = null;
    protected transient Set<String> enabledResult = null;

    public ResultManager(SimulationContext context) {
        this.context = context;
    }

    protected void addSimulationResultListener(SimulationResultListener l) {
        this.listeners.add(l);
        if (l instanceof SimulationResultGetter) {
            this.getter = (SimulationResultGetter)((Object)l);
        }
    }

    protected void removeSimulationResultListener(SimulationResultListener l) {
        this.listeners.remove(l);
        if (l == this.getter) {
            this.getter = null;
            for (SimulationResultListener i : this.listeners) {
                if (!(i instanceof SimulationResultGetter)) continue;
                this.getter = (SimulationResultGetter)((Object)i);
                break;
            }
        }
    }

    public boolean isEnabled(String name) {
        name = name.trim();
        if (this.enabledResult == null) {
            List<SimulationPlan> plans;
            List<Rule> rules;
            SimulationParameter param = this.context.getSimulationStorage().getParameter();
            this.enabledResult = new HashSet<String>();
            Collection<String> resultEnabled = param.getResultEnabled();
            this.enabledResult.addAll(resultEnabled);
            List<String> exportNames = param.getExportNames();
            if (exportNames != null) {
                for (String exportName : exportNames) {
                    ExportStorage storage = ExportStorage.getExport(exportName);
                    try {
                        Export export = storage.getNewExportInstance();
                        for (String resultName : export.getNecessaryResult()) {
                            this.enabledResult.add(resultName);
                        }
                    }
                    catch (IsisFishException eee) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)I18n._((String)"Can't instanciate export %1$s", (Object[])new Object[]{exportName}), (Throwable)eee);
                    }
                }
            }
            if ((rules = param.getRules()) != null) {
                for (Rule rule : rules) {
                    for (String resultName : rule.getNecessaryResult()) {
                        this.enabledResult.add(resultName);
                    }
                }
            }
            if ((plans = param.getSimulationPlans()) != null) {
                for (SimulationPlan plan : plans) {
                    for (String resultName : plan.getNecessaryResult()) {
                        this.enabledResult.add(resultName);
                    }
                }
            }
            log.info((Object)("Enabled result: " + this.enabledResult));
        }
        boolean result = this.enabledResult.contains(name);
        return result;
    }

    public void addActiveRule(TimeStep step, Rule rule) throws IsisFishException {
        log.warn((Object)"addActiveRule not implemented");
    }

    public void addResult(TimeStep step, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, mat.getName(), mat);
    }

    public void addResult(TimeStep step, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, mat.getName(), pop, mat);
    }

    public void addResult(boolean force, TimeStep step, MatrixND mat) throws IsisFishException {
        this.addResult(force, step, mat.getName(), mat);
    }

    public void addResult(boolean force, TimeStep step, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(force, step, mat.getName(), pop, mat);
    }

    public void addResult(TimeStep step, String name, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, name, pop, mat);
    }

    public void addResult(TimeStep step, String name, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, name, mat);
    }

    public void addResult(boolean force, TimeStep step, String name, Population pop, MatrixND mat) throws IsisFishException {
        if (force || this.isEnabled(name)) {
            for (SimulationResultListener l : this.listeners) {
                l.addResult(this.context, step, name + " " + pop, mat);
            }
        }
    }

    public void addResult(boolean force, TimeStep step, String name, MatrixND mat) throws IsisFishException {
        if (force || this.isEnabled(name)) {
            for (SimulationResultListener l : this.listeners) {
                l.addResult(this.context, step, name, mat);
            }
        }
    }

    public MatrixND getMatrix(TimeStep step, Population pop, String name) {
        name = name + " " + pop;
        return this.getMatrix(step, name);
    }

    public MatrixND getMatrix(TimeStep step, String name) {
        MatrixND result = null;
        if (this.getter != null) {
            result = this.getter.getMatrix(this.context, step, name);
        }
        return result;
    }

    public MatrixND getMatrix(Population pop, String name) {
        name = name + " " + pop;
        return this.getMatrix(name);
    }

    public MatrixND getMatrix(String name) {
        MatrixND result = null;
        if (this.getter != null) {
            result = this.getter.getMatrix(this.context, name);
        }
        return result;
    }
}

