/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.mexico.xml;

import fr.ifremer.isisfish.mexico.MexicoHelper;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationDiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.MatrixContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.RuleDiscreteDomain;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.dom4j.Element;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;

public class DomXMLParser {
    public static final String DISCRETE = "discrete";
    public static final String ENUMERATION = "enumeration";
    public static final String DOMAIN = "domain";
    public static final String FIXED = "fixed";
    public static final String VALUE = "value";
    public static final String RULE = "rule";
    public static final String RULES = "rules";
    public static final String VERSION = "version";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String PROPERTY = "property";
    public static final String TARGET = "target";
    public static final String CONTINUOUS = "continuous";
    public static final String MATRIXCONTINUOUS = "matrixcontinuous";
    public static final String COEFFICIENT = "coefficient";
    public static final String EQUATIONCONTINUOUS = "equationcontinuous";
    public static final String EQUATION = "equation";
    public static final String VARIABLE = "variable";
    public static final String PERCENTAGE = "percentage";
    public static final String REFERENCE = "reference";
    public static final String RANGE = "range";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String CARDINALITY = "cardinality";
    public static final String INTEGER = "integer";
    public static final String MX = "mx";

    public static DesignPlan parseDesignPlan(Element rootElement, TopiaContext topiaContext) {
        DesignPlan plan = new DesignPlan();
        String version = rootElement.attributeValue(VERSION);
        List factorGroupElements = rootElement.selectNodes("child::factors");
        FactorGroup factorGroup = null;
        if (!factorGroupElements.isEmpty()) {
            factorGroup = "2".equals(version) ? DomXMLParser.parseFactorGroupV2((Element)factorGroupElements.get(0), topiaContext) : DomXMLParser.parseFactorGroup((Element)factorGroupElements.get(0), topiaContext);
        }
        plan.setFactorGroup(factorGroup);
        return plan;
    }

    @Deprecated
    protected static FactorGroup parseFactorGroup(Element fgElement, TopiaContext topiaContext) {
        String factorGroupName = fgElement.attributeValue(NAME);
        String factorGroupType = fgElement.attributeValue(TYPE);
        boolean continuous = CONTINUOUS.equalsIgnoreCase(factorGroupType);
        FactorGroup factorGroup = new FactorGroup(factorGroupName, continuous);
        List factorGroupElements = fgElement.selectNodes("child::factors");
        for (Element factorGroupElement : factorGroupElements) {
            FactorGroup subFactorGroup = DomXMLParser.parseFactorGroup(factorGroupElement, topiaContext);
            factorGroup.addFactor(subFactorGroup);
        }
        List factorElements = fgElement.selectNodes("child::factor");
        for (Element factorElement : factorElements) {
            List valueElements;
            Element percentageElement;
            Element equationElement;
            EquationContinuousDomain edomain;
            Domain domain;
            MatrixND matrix;
            Element matrixElement;
            MatrixContinuousDomain mdomain;
            Element fixedElement;
            Factor factor;
            String type = factorElement.attributeValue(TYPE);
            String name = factorElement.attributeValue(NAME);
            String property = factorElement.attributeValue(PROPERTY);
            String path = factorElement.element(TARGET).getText().trim();
            if ("real".equals(type)) {
                factor = new Factor(name);
                factor.setPath(path);
                fixedElement = factorElement.element(DOMAIN).element(FIXED);
                if (property.endsWith(CONTINUOUS)) {
                    if (property.equals(MATRIXCONTINUOUS)) {
                        mdomain = new MatrixContinuousDomain(true);
                        Element coefficientElement = fixedElement.element(COEFFICIENT);
                        mdomain.setCoefficient(Double.valueOf(coefficientElement.attributeValue(VALUE)));
                        matrixElement = fixedElement.element(MX);
                        matrix = MexicoHelper.getMatrixFromXml(matrixElement, topiaContext);
                        mdomain.setReferenceValue(matrix);
                        domain = mdomain;
                    } else if (property.equals(EQUATIONCONTINUOUS)) {
                        edomain = new EquationContinuousDomain(true);
                        Element coefficientElement = fixedElement.element(COEFFICIENT);
                        edomain.setCoefficient(Double.valueOf(coefficientElement.attributeValue(VALUE)));
                        equationElement = fixedElement.element(EQUATION);
                        edomain.setReferenceValue(Double.valueOf(equationElement.attributeValue(REFERENCE)));
                        edomain.setVariableName(equationElement.attributeValue(VARIABLE));
                        domain = edomain;
                    } else {
                        domain = new ContinuousDomain();
                        percentageElement = fixedElement.element(PERCENTAGE);
                        if (percentageElement != null) {
                            ((ContinuousDomain)domain).setCoefficient(Double.valueOf(percentageElement.attributeValue(COEFFICIENT)));
                            ((ContinuousDomain)domain).setReferenceValue(Double.valueOf(percentageElement.attributeValue(REFERENCE)));
                            ((ContinuousDomain)domain).setPercentageType(true);
                        } else {
                            Element rangeElement = fixedElement.element(RANGE);
                            ((ContinuousDomain)domain).setMinBound(Double.valueOf(rangeElement.attributeValue(MIN)));
                            ((ContinuousDomain)domain).setMaxBound(Double.valueOf(rangeElement.attributeValue(MAX)));
                        }
                    }
                    factor.setCardinality(Integer.valueOf(fixedElement.attributeValue(CARDINALITY)));
                    factor.setDomain(domain);
                } else if (DISCRETE.equals(property)) {
                    domain = new DiscreteDomain();
                    valueElements = fixedElement.element(ENUMERATION).elements(VALUE);
                    int label = 0;
                    for (Element valueElement : valueElements) {
                        ((DiscreteDomain)domain).getValues().put(label, Double.valueOf(valueElement.getTextTrim()));
                        ++label;
                    }
                    factor.setDomain(domain);
                }
                factorGroup.addFactor(factor);
                continue;
            }
            if (INTEGER.equals(type)) {
                factor = new Factor(name);
                factor.setPath(path);
                fixedElement = factorElement.element(DOMAIN).element(FIXED);
                if (CONTINUOUS.equals(property)) {
                    if (property.equals(MATRIXCONTINUOUS)) {
                        mdomain = new MatrixContinuousDomain(true);
                        Element coefficientElement = fixedElement.element(COEFFICIENT);
                        mdomain.setCoefficient(Double.valueOf(coefficientElement.attributeValue(VALUE)));
                        matrixElement = fixedElement.element(MX);
                        matrix = MexicoHelper.getMatrixFromXml(matrixElement, topiaContext);
                        mdomain.setReferenceValue(matrix);
                        domain = mdomain;
                    } else if (property.equals(EQUATIONCONTINUOUS)) {
                        edomain = new EquationContinuousDomain(true);
                        Element coefficientElement = fixedElement.element(COEFFICIENT);
                        edomain.setCoefficient(Double.valueOf(coefficientElement.attributeValue(VALUE)));
                        equationElement = fixedElement.element(EQUATION);
                        edomain.setReferenceValue(Double.valueOf(equationElement.attributeValue(REFERENCE)));
                        edomain.setVariableName(equationElement.attributeValue(VARIABLE));
                        domain = edomain;
                    } else {
                        domain = new ContinuousDomain();
                        percentageElement = fixedElement.element(PERCENTAGE);
                        if (percentageElement != null) {
                            ((ContinuousDomain)domain).setCoefficient(Double.valueOf(percentageElement.attributeValue(COEFFICIENT)));
                            ((ContinuousDomain)domain).setReferenceValue(Double.valueOf(percentageElement.attributeValue(REFERENCE)));
                            ((ContinuousDomain)domain).setPercentageType(true);
                        } else {
                            Element rangeElement = fixedElement.element(RANGE);
                            ((ContinuousDomain)domain).setMinBound(Integer.valueOf(rangeElement.attributeValue(MIN)));
                            ((ContinuousDomain)domain).setMaxBound(Integer.valueOf(rangeElement.attributeValue(MAX)));
                        }
                    }
                    factor.setCardinality(Integer.valueOf(fixedElement.attributeValue(CARDINALITY)));
                    factor.setDomain(domain);
                } else if (DISCRETE.equals(property)) {
                    domain = new DiscreteDomain();
                    valueElements = fixedElement.element(ENUMERATION).elements(VALUE);
                    int label = 0;
                    for (Element valueElement : valueElements) {
                        ((DiscreteDomain)domain).getValues().put(label, Integer.valueOf(valueElement.getTextTrim()));
                        ++label;
                    }
                    factor.setDomain(domain);
                }
                factorGroup.addFactor(factor);
                continue;
            }
            if (!RULE.equals(type)) continue;
            factor = new Factor(name);
            factor.setPath(path);
            fixedElement = factorElement.element(DOMAIN).element(FIXED);
            if (DISCRETE.equals(property)) {
                domain = new RuleDiscreteDomain();
                valueElements = fixedElement.element(ENUMERATION).elements(VALUE);
                int label = 0;
                for (Element valueElement : valueElements) {
                    Element rulesElement = valueElement.element(RULES);
                    List<Rule> rulesValue = MexicoHelper.getRulesFromXml(rulesElement, topiaContext);
                    ((DiscreteDomain)domain).getValues().put(label, rulesValue);
                    ++label;
                }
                factor.setDomain(domain);
            }
            factorGroup.addFactor(factor);
        }
        return factorGroup;
    }

    protected static FactorGroup parseFactorGroupV2(Element fgElement, TopiaContext topiaContext) {
        String factorGroupName = fgElement.attributeValue(NAME);
        String factorGroupType = fgElement.attributeValue(TYPE);
        boolean continuous = CONTINUOUS.equalsIgnoreCase(factorGroupType);
        FactorGroup factorGroup = new FactorGroup(factorGroupName, continuous);
        List factorGroupElements = fgElement.selectNodes("child::factors");
        for (Element factorGroupElement : factorGroupElements) {
            FactorGroup subFactorGroup = DomXMLParser.parseFactorGroupV2(factorGroupElement, topiaContext);
            factorGroup.addFactor(subFactorGroup);
        }
        List factorElements = fgElement.selectNodes("child::factor");
        for (Element factorElement : factorElements) {
            String content;
            List valueElements;
            Element maxElement;
            Element minElement;
            Element referenceElement;
            EquationContinuousDomain edomain;
            Domain domain;
            MatrixND maxMatrix;
            MatrixND minMatrix;
            Element maxElement2;
            Element minElement2;
            Element rangeElement;
            MatrixND matrix;
            Element matrixElement;
            MatrixContinuousDomain mdomain;
            Element fixedElement;
            Factor factor;
            String type = factorElement.attributeValue(TYPE);
            String name = factorElement.attributeValue(NAME);
            String property = factorElement.attributeValue(PROPERTY);
            String path = factorElement.element(TARGET).getText().trim();
            String cardinalityString = factorElement.attributeValue(CARDINALITY);
            Integer cardinality = 0;
            if (StringUtils.isNotEmpty((String)cardinalityString)) {
                cardinality = Integer.valueOf(cardinalityString);
            }
            if ("real".equals(type)) {
                factor = new Factor(name);
                factor.setPath(path);
                fixedElement = factorElement.element(DOMAIN).element(FIXED);
                if (property.endsWith(CONTINUOUS)) {
                    if (property.equals(MATRIXCONTINUOUS)) {
                        mdomain = new MatrixContinuousDomain();
                        Element referenceElement2 = fixedElement.element(REFERENCE);
                        if (referenceElement2 != null) {
                            mdomain.setCoefficient(Double.valueOf(referenceElement2.attributeValue(COEFFICIENT)));
                            matrixElement = referenceElement2.element(MX);
                            matrix = MexicoHelper.getMatrixFromXml(matrixElement, topiaContext);
                            mdomain.setReferenceValue(matrix);
                            mdomain.setPercentageType(true);
                        } else {
                            rangeElement = fixedElement.element(RANGE);
                            minElement2 = rangeElement.element(MIN);
                            maxElement2 = rangeElement.element(MAX);
                            minMatrix = MexicoHelper.getMatrixFromXml(minElement2.element(MX), topiaContext);
                            maxMatrix = MexicoHelper.getMatrixFromXml(maxElement2.element(MX), topiaContext);
                            mdomain.setMinBound(minMatrix);
                            mdomain.setMaxBound(maxMatrix);
                        }
                        domain = mdomain;
                    } else if (property.equals(EQUATIONCONTINUOUS)) {
                        edomain = new EquationContinuousDomain();
                        edomain.setVariableName(fixedElement.attributeValue(VARIABLE));
                        Element referenceElement3 = fixedElement.element(REFERENCE);
                        if (referenceElement3 != null) {
                            edomain.setCoefficient(Double.valueOf(referenceElement3.attributeValue(COEFFICIENT)));
                            edomain.setReferenceValue(Double.valueOf(referenceElement3.getTextTrim()));
                            edomain.setPercentageType(true);
                        } else {
                            rangeElement = fixedElement.element(RANGE);
                            minElement2 = rangeElement.element(MIN);
                            maxElement2 = rangeElement.element(MAX);
                            edomain.setMinBound(Double.valueOf(minElement2.getTextTrim()));
                            edomain.setMaxBound(Double.valueOf(maxElement2.getTextTrim()));
                        }
                        domain = edomain;
                    } else {
                        domain = new ContinuousDomain();
                        referenceElement = fixedElement.element(REFERENCE);
                        if (referenceElement != null) {
                            ((ContinuousDomain)domain).setCoefficient(Double.valueOf(referenceElement.attributeValue(COEFFICIENT)));
                            ((ContinuousDomain)domain).setReferenceValue(Double.valueOf(referenceElement.getTextTrim()));
                            ((ContinuousDomain)domain).setPercentageType(true);
                        } else {
                            Element rangeElement2 = fixedElement.element(RANGE);
                            minElement = rangeElement2.element(MIN);
                            maxElement = rangeElement2.element(MAX);
                            ((ContinuousDomain)domain).setMinBound(Double.valueOf(minElement.getTextTrim()));
                            ((ContinuousDomain)domain).setMaxBound(Double.valueOf(maxElement.getTextTrim()));
                        }
                    }
                    factor.setDomain(domain);
                } else if (DISCRETE.equals(property)) {
                    domain = new DiscreteDomain();
                    valueElements = fixedElement.element(ENUMERATION).elements(VALUE);
                    int label = 0;
                    for (Element valueElement : valueElements) {
                        ((DiscreteDomain)domain).getValues().put(label, Double.valueOf(valueElement.getTextTrim()));
                        ++label;
                    }
                    factor.setDomain(domain);
                }
                factor.setCardinality(cardinality);
                factorGroup.addFactor(factor);
                continue;
            }
            if (INTEGER.equals(type)) {
                factor = new Factor(name);
                factor.setPath(path);
                fixedElement = factorElement.element(DOMAIN).element(FIXED);
                if (CONTINUOUS.equals(property)) {
                    if (property.equals(MATRIXCONTINUOUS)) {
                        mdomain = new MatrixContinuousDomain();
                        Element referenceElement4 = fixedElement.element(REFERENCE);
                        if (referenceElement4 != null) {
                            mdomain.setCoefficient(Double.valueOf(referenceElement4.attributeValue(COEFFICIENT)));
                            matrixElement = referenceElement4.element(MX);
                            matrix = MexicoHelper.getMatrixFromXml(matrixElement, topiaContext);
                            mdomain.setReferenceValue(matrix);
                            mdomain.setPercentageType(true);
                        } else {
                            rangeElement = fixedElement.element(RANGE);
                            minElement2 = rangeElement.element(MIN);
                            maxElement2 = rangeElement.element(MAX);
                            minMatrix = MexicoHelper.getMatrixFromXml(minElement2.element(MX), topiaContext);
                            maxMatrix = MexicoHelper.getMatrixFromXml(maxElement2.element(MX), topiaContext);
                            mdomain.setMinBound(minMatrix);
                            mdomain.setMaxBound(maxMatrix);
                        }
                        domain = mdomain;
                    } else if (property.equals(EQUATIONCONTINUOUS)) {
                        edomain = new EquationContinuousDomain();
                        edomain.setVariableName(fixedElement.attributeValue(VARIABLE));
                        Element referenceElement5 = fixedElement.element(REFERENCE);
                        if (referenceElement5 != null) {
                            edomain.setCoefficient(Double.valueOf(referenceElement5.attributeValue(COEFFICIENT)));
                            edomain.setReferenceValue(Double.valueOf(referenceElement5.getTextTrim()));
                            edomain.setPercentageType(true);
                        } else {
                            rangeElement = fixedElement.element(RANGE);
                            minElement2 = rangeElement.element(MIN);
                            maxElement2 = rangeElement.element(MAX);
                            edomain.setMinBound(Double.valueOf(minElement2.getTextTrim()));
                            edomain.setMaxBound(Double.valueOf(maxElement2.getTextTrim()));
                        }
                        domain = edomain;
                    } else {
                        domain = new ContinuousDomain();
                        referenceElement = fixedElement.element(REFERENCE);
                        if (referenceElement != null) {
                            ((ContinuousDomain)domain).setCoefficient(Double.valueOf(referenceElement.attributeValue(COEFFICIENT)));
                            ((ContinuousDomain)domain).setReferenceValue(Double.valueOf(referenceElement.getTextTrim()));
                            ((ContinuousDomain)domain).setPercentageType(true);
                        } else {
                            Element rangeElement3 = fixedElement.element(RANGE);
                            minElement = rangeElement3.element(MIN);
                            maxElement = rangeElement3.element(MAX);
                            ((ContinuousDomain)domain).setMinBound(Integer.valueOf(minElement.getTextTrim()));
                            ((ContinuousDomain)domain).setMaxBound(Integer.valueOf(maxElement.getTextTrim()));
                        }
                    }
                    factor.setDomain(domain);
                } else if (DISCRETE.equals(property)) {
                    domain = new DiscreteDomain();
                    valueElements = fixedElement.element(ENUMERATION).elements(VALUE);
                    int label = 0;
                    for (Element valueElement : valueElements) {
                        ((DiscreteDomain)domain).getValues().put(label, Integer.valueOf(valueElement.getTextTrim()));
                        ++label;
                    }
                    factor.setDomain(domain);
                }
                factor.setCardinality(cardinality);
                factorGroup.addFactor(factor);
                continue;
            }
            if (RULE.equals(type)) {
                factor = new Factor(name);
                factor.setPath(path);
                fixedElement = factorElement.element(DOMAIN).element(FIXED);
                if (DISCRETE.equals(property)) {
                    domain = new RuleDiscreteDomain();
                    valueElements = fixedElement.element(ENUMERATION).elements(VALUE);
                    int label = 0;
                    for (Element valueElement : valueElements) {
                        Element rulesElement = valueElement.element(RULES);
                        List<Rule> rulesValue = MexicoHelper.getRulesFromXml(rulesElement, topiaContext);
                        ((DiscreteDomain)domain).getValues().put(label, rulesValue);
                        ++label;
                    }
                    factor.setDomain(domain);
                }
                factor.setCardinality(cardinality);
                factorGroup.addFactor(factor);
                continue;
            }
            if (EQUATION.equals(type)) {
                factor = new Factor(name);
                factor.setPath(path);
                fixedElement = factorElement.element(DOMAIN).element(FIXED);
                if (DISCRETE.equals(property)) {
                    domain = new EquationDiscreteDomain();
                    valueElements = fixedElement.element(ENUMERATION).elements(VALUE);
                    int label = 0;
                    for (Element valueElement : valueElements) {
                        content = StringEscapeUtils.unescapeXml((String)valueElement.getText());
                        ((DiscreteDomain)domain).getValues().put(label, content);
                        ++label;
                    }
                    factor.setDomain(domain);
                }
                factor.setCardinality(cardinality);
                factorGroup.addFactor(factor);
                continue;
            }
            if (!"string".equals(type)) continue;
            factor = new Factor(name);
            factor.setPath(path);
            fixedElement = factorElement.element(DOMAIN).element(FIXED);
            if (DISCRETE.equals(property)) {
                domain = new DiscreteDomain();
                valueElements = fixedElement.element(ENUMERATION).elements(VALUE);
                int label = 0;
                for (Element valueElement : valueElements) {
                    content = valueElement.getText();
                    Object object = MexicoHelper.getObjectFromString(content, topiaContext);
                    ((DiscreteDomain)domain).getValues().put(label, object);
                    ++label;
                }
                factor.setDomain(domain);
            }
            factor.setCardinality(cardinality);
            factorGroup.addFactor(factor);
        }
        return factorGroup;
    }
}

