/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.map;

import com.bbn.openmap.BufferedMapBean;
import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.event.LayerListener;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.NavMouseMode;
import com.bbn.openmap.layer.GraticuleLayer;
import com.bbn.openmap.layer.dted.DTEDLayer;
import com.bbn.openmap.layer.e00.E00Layer;
import com.bbn.openmap.layer.mif.MIFLayer;
import com.bbn.openmap.layer.rpf.RpfLayer;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.layer.vpf.VPFLayer;
import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.CellDAO;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.map.CellSelectionLayer;
import fr.ifremer.isisfish.map.ResultatLayer;
import fr.ifremer.isisfish.map.ZoneDelimiterLayer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class IsisMapBean
extends BufferedMapBean {
    private static final long serialVersionUID = -4162103384132928473L;
    private static Log log = LogFactory.getLog(IsisMapBean.class);
    protected FisheryRegion fisheryRegion = null;
    protected float pasMailleLatitude;
    protected float pasMailleLongitude;
    protected float minLatitude;
    protected float maxLatitude;
    protected float minLongitude;
    protected float maxLongitude;
    protected List<MapMouseListener> orderedListener = new ArrayList<MapMouseListener>();
    protected LayerHandler layerHandler = new LayerHandler();
    protected MapMouseMode currentMouseMode;
    protected MouseDelegator md;
    protected CellSelectionLayer activeSelectionLayer = null;
    protected int selectionMode = 2;
    protected static final float SCALE = 9500000.0f;

    public IsisMapBean() {
        this.init();
        this.setActiveMouseMode((MapMouseMode)new NavMouseMode());
    }

    protected void init() {
        this.setScale(9500000.0f);
        this.layerHandler.addLayerListener((LayerListener)this);
        this.md = new MouseDelegator((MapBean)this);
        this.md.setDefaultMouseModes();
    }

    public void setActiveMouseMode(MapMouseMode mode) {
        this.md.setActiveMouseMode(mode);
        this.currentMouseMode = mode;
        for (MapMouseListener l : this.orderedListener) {
            this.currentMouseMode.addMapMouseListener(l);
        }
    }

    public void addMapMouseListener(MapMouseListener mml) {
        if (mml instanceof CellSelectionLayer || mml instanceof ResultatLayer) {
            this.orderedListener.add(0, mml);
            this.currentMouseMode.removeAllMapMouseListeners();
            for (MapMouseListener l : this.orderedListener) {
                this.currentMouseMode.addMapMouseListener(l);
            }
        } else {
            this.orderedListener.add(mml);
            this.currentMouseMode.addMapMouseListener(mml);
        }
    }

    public void removeMapMouseListener(MapMouseListener mml) {
        this.currentMouseMode.removeMapMouseListener(mml);
    }

    public FisheryRegion getFisheryRegion() {
        return this.fisheryRegion;
    }

    public void setFisheryRegion(FisheryRegion fisheryRegion) {
        block6: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("current fishery is now: " + fisheryRegion + " old was: " + this.fisheryRegion));
            }
            try {
                FisheryRegion oldFisheryRegion = this.fisheryRegion;
                this.fisheryRegion = fisheryRegion;
                if (fisheryRegion == null) {
                    this.layerHandler.removeAll();
                } else if (!fisheryRegion.equals(oldFisheryRegion)) {
                    this.pasMailleLatitude = fisheryRegion.getCellLengthLatitude();
                    this.pasMailleLongitude = fisheryRegion.getCellLengthLongitude();
                    this.minLatitude = fisheryRegion.getMinLatitude();
                    this.minLongitude = fisheryRegion.getMinLongitude();
                    this.maxLatitude = fisheryRegion.getMaxLatitude();
                    this.maxLongitude = fisheryRegion.getMaxLongitude();
                    this.initMap();
                }
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Impossible d'initialiser la Region", (Throwable)eee);
            }
        }
    }

    protected TopiaContext getTopiaContext() {
        TopiaContext result = this.getFisheryRegion().getTopiaContext();
        if (result == null) {
            throw new IsisFishRuntimeException("Can't get topiaContext from FisheryRegion");
        }
        return result;
    }

    protected CellDAO getCellDAO() throws TopiaException {
        return IsisFishDAOHelper.getCellDAO(this.getTopiaContext());
    }

    public List<Cell> getSelectedCells() {
        try {
            ArrayList<Cell> result = new ArrayList<Cell>();
            List<LatLonPoint> pts = this.activeSelectionLayer.getSelected();
            for (LatLonPoint llp : pts) {
                List cells = null;
                try {
                    cells = this.getCellDAO().findAllByProperties("latitude", Float.valueOf(llp.getLatitude()), new Object[]{"longitude", Float.valueOf(llp.getLongitude())});
                }
                catch (TopiaException eee) {
                    log.warn((Object)("Can't find cell for this point: " + llp), (Throwable)eee);
                }
                if (cells == null || cells.size() <= 0) continue;
                result.add((Cell)cells.get(0));
            }
            return result;
        }
        catch (RuntimeException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't find selected cells", (Throwable)eee);
            }
            throw eee;
        }
    }

    public void setSelectedCells(List<Cell> cells) {
        if (cells != null) {
            this.setSelectedCells(cells.toArray(new Cell[cells.size()]));
        } else {
            this.setSelectedCells(new Cell[0]);
        }
    }

    public void setSelectedCells(Cell ... cells) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Select cells: " + Arrays.toString(cells)));
        }
        this.activeSelectionLayer.unSelectAll();
        this.addSelectedCells(cells);
    }

    public void addSelectedCells(Cell ... cells) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("add select cells: " + Arrays.toString(cells)));
        }
        for (Cell cell : cells) {
            if (cell == null) continue;
            this.activeSelectionLayer.select((cell.getLatitude() + cell.getLatitude() + this.pasMailleLatitude) / 2.0f, (cell.getLongitude() + cell.getLongitude() + this.pasMailleLongitude) / 2.0f);
        }
    }

    public void removeSelectedCells(Cell ... cells) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("remove select cells: " + Arrays.toString(cells)));
        }
        for (Cell cell : cells) {
            this.activeSelectionLayer.unSelect((cell.getLatitude() + cell.getLatitude() + this.pasMailleLatitude) / 2.0f, (cell.getLongitude() + cell.getLongitude() + this.pasMailleLongitude) / 2.0f);
        }
    }

    public LayerHandler getLayerHandler() {
        return this.layerHandler;
    }

    public void addResultatLayer(String id, ResultatLayer layer) {
        layer.setName(id);
        this.addMapMouseListener(layer);
        this.layerHandler.addLayer((Layer)layer);
    }

    public void removeAllResultatLayer() {
        Layer[] layers = this.layerHandler.getLayers();
        for (int i = 0; i < layers.length; ++i) {
            if (!(layers[i] instanceof ResultatLayer)) continue;
            this.removeMapMouseListener((MapMouseListener)layers[i]);
            this.layerHandler.removeLayer(layers[i]);
        }
    }

    protected void addLayer(String layerId, String mapFile, String lineColor, String fillColor) {
        Layer layer = null;
        if (mapFile.endsWith(".shp")) {
            layer = this.getShapeLayer(layerId, mapFile, lineColor, fillColor);
        } else if (mapFile.endsWith(".e00")) {
            layer = this.getE00Layer(layerId, mapFile, lineColor, fillColor);
        } else if (mapFile.endsWith(".mif")) {
            layer = this.getMIFLayer(layerId, mapFile, lineColor, fillColor);
        } else if (mapFile.endsWith(".rpf") || mapFile.endsWith(".cadrg") || mapFile.endsWith(".cib")) {
            layer = this.getRPFLayer(layerId, mapFile, lineColor, fillColor);
        } else if (mapFile.endsWith(".vmap") || mapFile.endsWith(".dcw") || mapFile.endsWith(".vpf")) {
            layer = this.getVPFLayer(layerId, mapFile, lineColor, fillColor);
        } else if (log.isErrorEnabled()) {
            log.error((Object)("Can't find layer for " + mapFile + " (unknown type)"));
        }
        if (layer != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add layer " + layer));
            }
            this.layerHandler.addLayer(layer);
        }
    }

    protected Layer getShapeLayer(String layerId, String mapFile, String lineColor, String fillColor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get ShapeLayer with filename : " + mapFile));
        }
        ShapeLayer shapeLayer = new ShapeLayer();
        Properties p = new Properties();
        p.setProperty(layerId + "." + "shapeFile", mapFile);
        p.setProperty(layerId + "." + "lineColor", lineColor);
        p.setProperty(layerId + "." + "fillColor", fillColor);
        shapeLayer.setProperties(layerId, p);
        shapeLayer.setName(layerId);
        return shapeLayer;
    }

    protected Layer getE00Layer(String layerId, String mapFile, String lineColor, String fillColor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get E00Layer with filename : " + mapFile));
        }
        E00Layer e00Layer = new E00Layer();
        Properties p = new Properties();
        p.setProperty(layerId + ".FileName", mapFile);
        p.setProperty(layerId + "." + "lineColor", lineColor);
        p.setProperty(layerId + "." + "fillColor", fillColor);
        e00Layer.setProperties(layerId, p);
        e00Layer.setName(layerId);
        return e00Layer;
    }

    protected Layer getDTEDLayer(String layerId, String mapFile, String lineColor, String fillColor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get DTEDLayer with filename : " + mapFile));
        }
        File mapFileFile = new File(mapFile);
        String parentFolder = mapFileFile.getParent();
        DTEDLayer dtedLayer = new DTEDLayer();
        Properties p = new Properties();
        p.setProperty(layerId + ".dted.paths", parentFolder);
        p.setProperty(layerId + "." + "lineColor", lineColor);
        p.setProperty(layerId + "." + "fillColor", fillColor);
        dtedLayer.setProperties(layerId, p);
        dtedLayer.setName(layerId);
        return dtedLayer;
    }

    protected Layer getMIFLayer(String layerId, String mapFile, String lineColor, String fillColor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get MIFLayer with filename : " + mapFile));
        }
        MIFLayer mifLayer = new MIFLayer();
        Properties p = new Properties();
        p.setProperty(layerId + "." + "mifFile", mapFile);
        p.setProperty(layerId + "." + "pointVisible", "true");
        p.setProperty(layerId + "." + "lineColor", lineColor);
        p.setProperty(layerId + "." + "fillColor", fillColor);
        mifLayer.setProperties(layerId, p);
        mifLayer.setName(layerId);
        return mifLayer;
    }

    protected Layer getRPFLayer(String layerId, String mapFile, String lineColor, String fillColor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get RpfLayer with filename : " + mapFile));
        }
        File mapFileFile = new File(mapFile);
        String parentFolder = mapFileFile.getParent();
        RpfLayer rpfLayer = new RpfLayer();
        Properties p = new Properties();
        p.setProperty(layerId + ".rpf.paths", parentFolder);
        p.setProperty(layerId + "." + "pointVisible", "true");
        p.setProperty(layerId + "." + "lineColor", lineColor);
        p.setProperty(layerId + "." + "fillColor", fillColor);
        rpfLayer.setProperties(layerId, p);
        rpfLayer.setName(layerId);
        return rpfLayer;
    }

    protected Layer getVPFLayer(String layerId, String mapFile, String lineColor, String fillColor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get vpfLayer with filename : " + mapFile));
        }
        VPFLayer vpfLayer = new VPFLayer();
        Properties p = new Properties();
        p.setProperty(layerId + "." + "vpfPath", mapFile);
        p.setProperty(layerId + "." + "defaultLayer", "vmapCoastline");
        p.setProperty(layerId + "." + "lineColor", lineColor);
        p.setProperty(layerId + "." + "fillColor", fillColor);
        vpfLayer.setProperties(layerId, p);
        vpfLayer.setName(layerId);
        return vpfLayer;
    }

    protected void addGraticuleLayer() {
        GraticuleLayer layer = new GraticuleLayer();
        Properties p = new Properties();
        p.setProperty(".showRuler", "true");
        p.setProperty(".show1And5Lines", "true");
        p.setProperty(".threshold", "5");
        p.setProperty(".10DegreeColor", "FF000000");
        p.setProperty(".5DegreeColor", "C7009900");
        p.setProperty(".1DegreeColor", "FF003300");
        p.setProperty(".equatorColor", "FFFF0000");
        p.setProperty(".datelineColor", "FF000099");
        p.setProperty(".specialLineColor", "FF000000");
        p.setProperty(".textColor", "FF000000");
        layer.setProperties("", p);
        this.layerHandler.addLayer((Layer)layer);
    }

    protected void addZoneDelimiterLayer() throws TopiaException {
        ZoneDelimiterLayer layer = new ZoneDelimiterLayer(this.fisheryRegion);
        this.layerHandler.addLayer((Layer)layer);
    }

    protected void addSpecificLayer() {
        block2: {
            try {
                this.addSelectionLayer();
                this.addZoneDelimiterLayer();
            }
            catch (TopiaException eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Can't add specific layer", (Throwable)eee);
            }
        }
    }

    protected void initMap() {
        block6: {
            try {
                float centerLat = (this.maxLatitude + this.minLatitude) / 2.0f;
                float centerLong = (this.maxLongitude + this.minLongitude) / 2.0f;
                this.layerHandler.removeAll();
                this.setCenter(new LatLonPoint(centerLat, centerLong));
                this.addSpecificLayer();
                this.addGraticuleLayer();
                boolean shapeLoaded = false;
                for (String filename : this.getFisheryRegion().getMapFilePath()) {
                    if (StringUtils.isEmpty((CharSequence)filename)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)I18n._((String)"isisfish.message.load.map", (Object[])new Object[]{filename}));
                    }
                    this.addLayer(filename, filename, "ff000000", "ffbdde83");
                    shapeLoaded = true;
                }
                if (!shapeLoaded) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Can't load custom map, load default one");
                    }
                    String filename = IsisFish.config.getDefaultMapFilename();
                    this.addLayer(filename, filename, "ff000000", "ffbdde83");
                }
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)I18n._((String)"isisfish.error.init.map", (Object[])new Object[0]), (Throwable)eee);
            }
        }
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(int v) {
        this.selectionMode = v;
        if (this.activeSelectionLayer != null) {
            this.activeSelectionLayer.setSelectionMode(v);
        }
    }

    public void addSelectionLayer() {
        block2: {
            try {
                this.activeSelectionLayer = new CellSelectionLayer(this.fisheryRegion, this.getSelectionMode());
                this.addMapMouseListener(this.activeSelectionLayer);
                this.layerHandler.addLayer((Layer)this.activeSelectionLayer);
            }
            catch (TopiaException eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Can't add selection layer", (Throwable)eee);
            }
        }
    }
}

