/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.EquationDAO;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.SelectivityAbstract;
import fr.ifremer.isisfish.equation.SelectivityEquation;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;

public class SelectivityImpl
extends SelectivityAbstract {
    private static final long serialVersionUID = 1L;

    @Override
    public double getCoefficient(Population pop, PopulationGroup group, Metier metier) {
        Equation eq = this.getEquation();
        double result = eq.evaluate("pop", pop, "group", group, "metier", metier);
        return result;
    }

    @Override
    public Equation getEquation() {
        if (super.getEquation() == null) {
            Equation eq;
            try {
                EquationDAO dao = IsisFishDAOHelper.getEquationDAO(this.getTopiaContext());
                eq = (Equation)dao.create(new Object[0]);
                eq.setCategory("Selectivity");
                eq.setLanguage("java");
                eq.setJavaInterface(SelectivityEquation.class);
                eq.update();
            }
            catch (TopiaException eee) {
                throw new IsisFishRuntimeException("Can't create equation");
            }
            super.setEquation(eq);
        }
        return super.getEquation();
    }

    public void setEquationContent(String content) {
        try {
            Equation eq = this.getEquation();
            String _oldValue = eq.getContent();
            this.fireOnPreWrite("content", _oldValue, content);
            eq.setContent(content);
            eq.update();
            this.fireOnPostWrite("content", _oldValue, content);
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.change.equation", (Object[])new Object[0]), eee);
        }
    }

    @Override
    public void setGear(Gear value) {
        super.setGear(value);
        this.setEquationName(this.getEquation());
    }

    @Override
    public void setPopulation(Population value) {
        super.setPopulation(value);
        this.setEquationName(this.getEquation());
    }

    protected void setEquationName(Equation eq) {
        if (this.getGear() != null && this.getPopulation() != null) {
            eq.setName(this.getGear().getName() + " - " + this.getPopulation().getName() + "(" + this.getPopulation().getSpecies().getName() + ")");
        }
    }

    @Override
    public String toString() {
        String result = "" + this.getEquation();
        return result;
    }
}

