/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.simulator.Simulator;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;

public class SimulatorStorage
extends JavaSourceStorage {
    public static final String SIMULATOR_PATH = "simulators";
    public static final String SIMULATOR_TEMPLATE = "templates/script/simulator.ftl";
    private static Map<String, SimulatorStorage> simulatorsCache = new ReferenceMap();

    protected SimulatorStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    public static File getSimulatorDirectory() {
        File result = new File(SimulatorStorage.getContextDatabaseDirectory(), SIMULATOR_PATH);
        result.mkdirs();
        return result;
    }

    public static File getCommunitySimulatorDirectory() {
        File result = new File(SimulatorStorage.getCommunityDatabaseDirectory(), SIMULATOR_PATH);
        result.mkdirs();
        return result;
    }

    public Simulator getNewSimulatorInstance() throws IsisFishException {
        Simulator result = (Simulator)this.getNewInstance();
        return result;
    }

    public static SimulatorStorage getSimulator(String name) {
        String cacheName = SimulatorStorage.getContextDatabaseCacheKey(name);
        SimulatorStorage result = simulatorsCache.get(cacheName);
        if (result == null) {
            result = new SimulatorStorage(SimulatorStorage.getContextDatabaseDirectory(), SimulatorStorage.getSimulatorDirectory(), name);
            simulatorsCache.put(cacheName, result);
        }
        return result;
    }

    public static SimulatorStorage getCommunitySimulator(String name) {
        String cacheName = SimulatorStorage.getContextDatabaseCacheKey(name);
        SimulatorStorage result = simulatorsCache.get(cacheName);
        if (result == null) {
            result = new SimulatorStorage(SimulatorStorage.getCommunityDatabaseDirectory(), SimulatorStorage.getCommunitySimulatorDirectory(), name);
            simulatorsCache.put(cacheName, result);
        }
        return result;
    }

    public static void checkout() throws VCSException {
        SimulatorStorage.checkout(IsisFish.config.getDatabaseDirectory(), SIMULATOR_PATH);
    }

    public static List<String> getSimulatorNames() {
        List<String> result = SimulatorStorage.getStorageNames(SimulatorStorage.getSimulatorDirectory());
        result.addAll(SimulatorStorage.getStorageNames(SimulatorStorage.getCommunitySimulatorDirectory()));
        return result;
    }

    public static List<String> getNewSimulatorNames() {
        List<String> result = SimulatorStorage.getSimulatorNames();
        result.removeAll(SimulatorStorage.getRemoteSimulatorNames());
        return result;
    }

    public static List<String> getRemoteSimulatorNames() {
        File dir = SimulatorStorage.getSimulatorDirectory();
        List<String> result = SimulatorStorage.getRemoteStorageNames(dir);
        return result;
    }

    public static List<String> getNewRemoteSimulatorNames() {
        List<String> result = SimulatorStorage.getRemoteSimulatorNames();
        result.removeAll(SimulatorStorage.getSimulatorNames());
        return result;
    }
}

