/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityAnalysis;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SensitivityAnalysisStorage
extends JavaSourceStorage {
    private static Log log = LogFactory.getLog(SensitivityAnalysisStorage.class);
    public static final String SENSITIVITY_ANALYSIS_PATH = "sensitivityanalysis";
    public static final String SENSITIVITY_ANALYSIS_TEMPLATE = "templates/script/sensitivityanalysis.ftl";
    protected static Map<String, SensitivityAnalysisStorage> sensitivityCache = new ReferenceMap();

    protected SensitivityAnalysisStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    public static File getSensitivityAnalysisDirectory() {
        File result = new File(SensitivityAnalysisStorage.getContextDatabaseDirectory(), SENSITIVITY_ANALYSIS_PATH);
        result.mkdirs();
        return result;
    }

    public static File getCommunitySensitivityAnalysisDirectory() {
        File result = new File(SensitivityAnalysisStorage.getCommunityDatabaseDirectory(), SENSITIVITY_ANALYSIS_PATH);
        result.mkdirs();
        return result;
    }

    public static List<String> getSensitivityAnalysisNames() {
        List<String> result = SensitivityAnalysisStorage.getStorageNames(SensitivityAnalysisStorage.getSensitivityAnalysisDirectory());
        result.addAll(SensitivityAnalysisStorage.getStorageNames(SensitivityAnalysisStorage.getCommunitySensitivityAnalysisDirectory()));
        return result;
    }

    public static SensitivityAnalysisStorage getSensitivityAnalysis(String name) {
        String cacheName = SensitivityAnalysisStorage.getContextDatabaseCacheKey(name);
        SensitivityAnalysisStorage result = sensitivityCache.get(cacheName);
        if (result == null) {
            result = new SensitivityAnalysisStorage(SensitivityAnalysisStorage.getContextDatabaseDirectory(), SensitivityAnalysisStorage.getSensitivityAnalysisDirectory(), name);
            sensitivityCache.put(cacheName, result);
        }
        return result;
    }

    public static SensitivityAnalysisStorage getCommunitySensitivityAnalysis(String name) {
        String cacheName = SensitivityAnalysisStorage.getCommunityDatabaseCacheKey(name);
        SensitivityAnalysisStorage result = sensitivityCache.get(cacheName);
        if (result == null) {
            result = new SensitivityAnalysisStorage(SensitivityAnalysisStorage.getCommunityDatabaseDirectory(), SensitivityAnalysisStorage.getCommunitySensitivityAnalysisDirectory(), name);
            sensitivityCache.put(cacheName, result);
        }
        return result;
    }

    public SensitivityAnalysis getNewSensitivityAnalysisInstance() throws IsisFishException {
        Object result = this.getNewInstance();
        return (SensitivityAnalysis)result;
    }

    public static void checkout() throws VCSException {
        SensitivityAnalysisStorage.checkout(IsisFish.config.getDatabaseDirectory(), SENSITIVITY_ANALYSIS_PATH);
    }

    public static List<String> getNewSensitivityAnalysisNames() {
        List<String> result = SensitivityAnalysisStorage.getSensitivityAnalysisNames();
        result.removeAll(SensitivityAnalysisStorage.getRemoteSensitivityAnalysisNames());
        return result;
    }

    public static List<String> getRemoteSensitivityAnalysisNames() {
        File dir = SensitivityAnalysisStorage.getSensitivityAnalysisDirectory();
        return SensitivityAnalysisStorage.getRemoteStorageNames(dir);
    }

    public static List<String> getNewRemoteSensitivityAnalysisNames() throws VCSException {
        List<String> result = SensitivityAnalysisStorage.getRemoteSensitivityAnalysisNames();
        result.removeAll(SensitivityAnalysisStorage.getSensitivityAnalysisNames());
        return result;
    }

    @Override
    public String getDescription() {
        String result = null;
        try {
            SensitivityAnalysis sensitivityAnalysis = this.getNewSensitivityAnalysisInstance();
            result = sensitivityAnalysis == null ? null : sensitivityAnalysis.getDescription();
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"isisfish.error.not.found.description", (Object[])new Object[]{this}));
        }
        return result;
    }
}

