/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.util.Docable;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class RuleStorage
extends JavaSourceStorage
implements Docable {
    private static Log log = LogFactory.getLog(RuleStorage.class);
    public static final String RULE_PATH = "rules";
    public static final String RULE_TEMPLATE = "templates/script/rule.ftl";
    private static Map<String, RuleStorage> rulesCache = new ReferenceMap();

    protected RuleStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    public static File getRuleDirectory() {
        File result = new File(RuleStorage.getContextDatabaseDirectory(), RULE_PATH);
        result.mkdirs();
        return result;
    }

    public static File getCommunityRuleDirectory() {
        File result = new File(RuleStorage.getCommunityDatabaseDirectory(), RULE_PATH);
        result.mkdirs();
        return result;
    }

    public static List<String> getRuleNames() {
        List<String> rules = RuleStorage.getStorageNames(RuleStorage.getRuleDirectory());
        rules.addAll(RuleStorage.getStorageNames(RuleStorage.getCommunityRuleDirectory()));
        return rules;
    }

    public static RuleStorage getRule(String name) {
        String cacheName = RuleStorage.getContextDatabaseCacheKey(name);
        RuleStorage result = rulesCache.get(cacheName);
        if (result == null) {
            result = new RuleStorage(RuleStorage.getContextDatabaseDirectory(), RuleStorage.getRuleDirectory(), name);
            rulesCache.put(cacheName, result);
        }
        return result;
    }

    public static RuleStorage getCommunityRule(String name) {
        String cacheName = RuleStorage.getCommunityDatabaseCacheKey(name);
        RuleStorage result = rulesCache.get(cacheName);
        if (result == null) {
            result = new RuleStorage(RuleStorage.getCommunityDatabaseDirectory(), RuleStorage.getCommunityRuleDirectory(), name);
            rulesCache.put(cacheName, result);
        }
        return result;
    }

    public Rule getNewRuleInstance() throws IsisFishException {
        Object result = this.getNewInstance();
        return (Rule)result;
    }

    public static void checkout() throws VCSException {
        RuleStorage.checkout(IsisFish.config.getDatabaseDirectory(), RULE_PATH);
    }

    public static List<String> getNewRuleNames() {
        List<String> result = RuleStorage.getRuleNames();
        result.removeAll(RuleStorage.getRemoteRuleNames());
        return result;
    }

    public static List<String> getRemoteRuleNames() {
        File dir = RuleStorage.getRuleDirectory();
        return RuleStorage.getRemoteStorageNames(dir);
    }

    public static List<String> getNewRemoteRuleNames() {
        List<String> result = RuleStorage.getRemoteRuleNames();
        result.removeAll(RuleStorage.getRuleNames());
        return result;
    }

    @Override
    public String getDescription() {
        String result = null;
        try {
            Rule rule = this.getNewRuleInstance();
            result = rule == null ? null : rule.getDescription();
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"isisfish.error.not.found.description", (Object[])new Object[]{this}));
        }
        return result;
    }
}

