/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportStorage
extends JavaSourceStorage {
    private static Log log = LogFactory.getLog(ExportStorage.class);
    public static final String EXPORT_PATH = "exports";
    public static final String EXPORT_TEMPLATE = "templates/script/export.ftl";
    private static Map<String, ExportStorage> scriptsCache = new ReferenceMap();

    protected ExportStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    public static File getExportDirectory() {
        File result = new File(ExportStorage.getContextDatabaseDirectory(), EXPORT_PATH);
        result.mkdirs();
        return result;
    }

    public static File getCommunityExportDirectory() {
        File result = new File(ExportStorage.getCommunityDatabaseDirectory(), EXPORT_PATH);
        result.mkdirs();
        return result;
    }

    public Export getNewExportInstance() throws IsisFishException {
        Object result = this.getNewInstance();
        return (Export)result;
    }

    public static ExportStorage getExport(String name) {
        String cacheName = ExportStorage.getContextDatabaseCacheKey(name);
        ExportStorage result = scriptsCache.get(cacheName);
        if (result == null) {
            result = new ExportStorage(ExportStorage.getContextDatabaseDirectory(), ExportStorage.getExportDirectory(), name);
            scriptsCache.put(cacheName, result);
        }
        return result;
    }

    public static ExportStorage getCommunityExport(String name) {
        String cacheName = ExportStorage.getCommunityDatabaseCacheKey(name);
        ExportStorage result = scriptsCache.get(cacheName);
        if (result == null) {
            result = new ExportStorage(ExportStorage.getCommunityDatabaseDirectory(), ExportStorage.getCommunityExportDirectory(), name);
            scriptsCache.put(cacheName, result);
        }
        return result;
    }

    public static List<String> getExportNames() {
        List<String> result = ExportStorage.getStorageNames(ExportStorage.getExportDirectory());
        result.addAll(ExportStorage.getStorageNames(ExportStorage.getCommunityExportDirectory()));
        return result;
    }

    public static void checkout() throws VCSException {
        ExportStorage.checkout(IsisFish.config.getDatabaseDirectory(), EXPORT_PATH);
    }

    @Override
    public String getDescription() {
        String result = null;
        try {
            Export export = this.getNewExportInstance();
            if (export != null) {
                result = export.getDescription();
            }
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"isisfish.error.not.found.description", (Object[])new Object[]{this}));
        }
        return result;
    }
}

