/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.VersionStorage;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.nuiton.util.FileUtil;

public abstract class CodeSourceStorage
extends VersionStorage {
    protected String name = null;
    protected String content = null;
    protected long lastContentUpdate = 0L;
    protected long lastContentLength = 0L;

    protected CodeSourceStorage(File rootSrc, File directory, String name, String suffix) {
        super(rootSrc, name.endsWith(suffix) ? new File(directory, name) : new File(directory, name + suffix));
        this.name = name.endsWith(suffix) ? name : name + suffix;
    }

    @Override
    protected void prepare() {
    }

    @Override
    protected List<File> getFiles(boolean withParent) {
        List<File> result = Collections.singletonList(this.getFile());
        return result;
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        if (this.content == null || this.getFile().lastModified() > this.lastContentUpdate || this.getFile().length() != this.lastContentLength) {
            if (!this.exists()) {
                this.content = "";
            } else {
                try {
                    this.content = FileUtil.readAsString((File)this.getFile());
                    this.lastContentUpdate = System.nanoTime();
                    this.lastContentLength = this.getFile().length();
                }
                catch (IOException eee) {
                    throw new IsisFishRuntimeException("Can't get content", eee);
                }
            }
        }
        return this.content;
    }

    public void setContent(String content) throws IOException {
        this.setContent(content, true);
    }

    public void setContent(String content, boolean saveToFile) throws IOException {
        this.content = content;
        if (saveToFile) {
            FileUtil.writeString((File)this.getFile(), (String)content, (String)"utf-8");
            this.lastContentUpdate = System.nanoTime();
            this.lastContentLength = this.getFile().length();
        }
    }

    public void reload() {
        this.content = null;
    }
}

