/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.aspect;

import fr.ifremer.isisfish.datastore.SimulationInformation;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.SimulationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.aspectwerkz.annotation.Around;
import org.codehaus.aspectwerkz.annotation.Aspect;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;

@Aspect(value="perInstance")
public class RuleAspect {
    private static Log log = LogFactory.getLog(RuleAspect.class);

    @Around(value="execution(* rules.*.init(..))")
    public Object initCall(JoinPoint jp) throws Throwable {
        Object result = this.makeTimedCall(jp, State.INIT);
        return result;
    }

    @Around(value="execution(* rules.*.preAction(..))")
    public Object initPreCall(JoinPoint jp) throws Throwable {
        Object result = this.makeTimedCall(jp, State.PRE);
        return result;
    }

    @Around(value="execution(* rules.*.postAction(..))")
    public Object initPostCall(JoinPoint jp) throws Throwable {
        Object result = this.makeTimedCall(jp, State.POST);
        return result;
    }

    protected Object makeTimedCall(JoinPoint jp, State state) throws Throwable {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Rule aspect called : " + jp.getCalleeClass().getSimpleName()));
        }
        long timeBeforeCall = System.currentTimeMillis();
        Object result = jp.proceed();
        long timeAfterCall = System.currentTimeMillis();
        long timeTaken = timeAfterCall - timeBeforeCall;
        this.registerTime(jp, state, timeTaken);
        return result;
    }

    protected void registerTime(JoinPoint jp, State state, long timeTaken) {
        SimulationContext context = SimulationContext.get();
        SimulationStorage simulation = context.getSimulationStorage();
        if (simulation != null) {
            Class calleeClass = jp.getCalleeClass();
            String ruleName = calleeClass.getSimpleName();
            SimulationInformation info = simulation.getInformation();
            switch (state) {
                case INIT: {
                    info.addRuleInitTime(ruleName, timeTaken);
                    break;
                }
                case PRE: {
                    info.addRulePreTime(ruleName, timeTaken);
                    break;
                }
                case POST: {
                    info.addRulePostTime(ruleName, timeTaken);
                    break;
                }
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Time register called outside a simulation context");
        }
    }

    protected static enum State {
        INIT,
        PRE,
        POST;

    }
}

