/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.actions.ExportAction;
import fr.ifremer.isisfish.actions.ImportAction;
import fr.ifremer.isisfish.actions.OtherAction;
import fr.ifremer.isisfish.actions.SimulationAction;
import fr.ifremer.isisfish.actions.VCSAction;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.launcher.InProcessSimulatorLauncher;
import fr.ifremer.isisfish.simulator.launcher.SSHSimulatorLauncher;
import fr.ifremer.isisfish.simulator.launcher.SubProcessSimulationLauncher;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.StringUtil;
import org.nuiton.util.Version;

public class IsisConfig
extends ApplicationConfig {
    private static Log log = LogFactory.getLog(IsisConfig.class);
    public static final int STEP_AFTER_INIT = 0;
    public static final int STEP_AFTER_INIT_VCS = 1;
    public static final int STEP_AFTER_UI = 2;
    public static final int STEP_BEFORE_EXIT = 3;
    protected static final Version version = new Version(new int[]{4, 0, 0, 0});
    protected static final Version majorVersion = new Version(new int[]{version.getNumber(0)});
    protected static final Version databaseVersion = new Version(new int[]{version.getNumber(0), version.getNumber(1)});
    protected static final Version apiVersion = new Version(new int[]{version.getNumber(0), version.getNumber(1), version.getNumber(2)});
    public static final String COPYRIGHT_TEXT = "Version " + IsisConfig.getVersion() + " IFREMER-MAERHA \u00a9 2000-2011";
    public static final String CONFIG_FILENAME = "isis-config-" + majorVersion.toString();
    public static final String SEP = ",";
    protected transient File backupSessionDirectory = null;
    protected long startingTime = System.currentTimeMillis();

    public static Version getVersionNumber() {
        return version;
    }

    public static String getVersion() {
        String result = version.toString();
        return result;
    }

    public static Version getDatabaseVersion() {
        return databaseVersion;
    }

    public static Version getApiVersion() {
        return apiVersion;
    }

    public IsisConfig() {
        for (Option option : Option.values()) {
            this.setDefaultOption(option.key, option.defaultValue);
        }
        for (Enum enum_ : Action.values()) {
            for (String alias : ((Action)enum_).aliases) {
                this.addActionAlias(alias, ((Action)enum_).action);
            }
        }
    }

    public File getDatabaseDirectory() {
        File result = this.getOptionAsFile(Option.DATABASE_DIRECTORY.key);
        return result;
    }

    public File getCommunityDatabaseDirectory() {
        File result = this.getOptionAsFile(Option.COMMUNITY_DATABASE_DIRECTORY.key);
        return result;
    }

    public File getContextDatabaseDirectory() {
        SimulationContext simContext = SimulationContext.get();
        File scriptDirectory = simContext.getScriptDirectory();
        if (scriptDirectory == null) {
            scriptDirectory = this.getDatabaseDirectory();
        }
        return scriptDirectory;
    }

    public String getDatabaseLockMode() {
        String result = this.getOption(Option.DATABASE_LOCK_MODE.key);
        return result;
    }

    public File getCompileDirectory() {
        File result = this.getOptionAsFile(Option.COMPILATION_DIRECTORY.key);
        SimulationContext simContext = SimulationContext.get();
        SimulationControl control = simContext.getSimulationControl();
        if (control != null) {
            result = new File(result, control.getId());
        }
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public File getMonitoringDirectory() {
        File result = this.getOptionAsFile(Option.MONITORING_DIRECTORY.key);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public File getJavadocDirectory() {
        File result = this.getOptionAsFile(Option.JAVADOC_DIRECTORY.key);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public Locale getLocale() {
        String value = this.getOption(Option.LOCALE.key);
        Locale result = (Locale)ConvertUtils.convert((String)value, Locale.class);
        return result;
    }

    public void setLocale(String locale) {
        this.setOption(Option.LOCALE.key, locale);
    }

    public String getEncoding() {
        String result = this.getOption(Option.ENCODING.key);
        return result;
    }

    public String getSmtpServer() {
        String result = this.getOption(Option.SMTP_SERVER.key);
        return result;
    }

    public String getUserName() {
        String result = this.getOption(Option.USER_NAME.key);
        return result;
    }

    public String getUserMail() {
        String result = this.getOption(Option.USER_MAIL.key);
        return result;
    }

    public String getSimulatorClassfile() {
        String result = this.getOption(Option.SIMULATOR_CLASSFILE.key);
        return result;
    }

    public void setSimulatorClassfile(String value) {
        this.setOption(Option.SIMULATOR_CLASSFILE.key, value);
    }

    public String getSimulatorSshServer() {
        String result = this.getOption(Option.SIMULATOR_SSH_SERVER.key);
        return result;
    }

    public void setSimulatorSshServer(String sshServer) {
        this.setOption(Option.SIMULATOR_SSH_SERVER.key, sshServer);
    }

    public String getSimulatorSshUsername() {
        String result = this.getOption(Option.SIMULATOR_SSH_USER_NAME.key);
        return result;
    }

    public void setSimulatorSshUsername(String username) {
        this.setOption(Option.SIMULATOR_SSH_USER_NAME.key, username);
    }

    public String getSimulatorSshDataPath() {
        String result = this.getOption(Option.SIMULATOR_SSH_DATAPATH.key);
        return result;
    }

    public void setSimulatorSshDataPath(String datapath) {
        this.setOption(Option.SIMULATOR_SSH_DATAPATH.key, datapath);
    }

    public String getSimulatorSshUserHome() {
        String result = this.getOption(Option.SIMULATOR_SSH_USER_HOME.key);
        return result;
    }

    public void setSimulatorSshUserHome(String userhome) {
        this.setOption(Option.SIMULATOR_SSH_USER_HOME.key, userhome);
    }

    public String getSimulatorSshIsisHome() {
        String result = this.getOption(Option.SIMULATOR_SSH_ISIS_HOME.key);
        return result;
    }

    public void setSimulatorSshIsisHome(String isishome) {
        this.setOption(Option.SIMULATOR_SSH_ISIS_HOME.key, isishome);
    }

    public String getSimulatorSshTmpPath() {
        String result = this.getOption(Option.SIMULATOR_SSH_TMPPATH.key);
        return result;
    }

    public void setSimulatorSshTmpPath(String sshtemppath) {
        this.setOption(Option.SIMULATOR_SSH_TMPPATH.key, sshtemppath);
    }

    public String getSimulatorSshPbsBinPath() {
        String result = this.getOption(Option.SIMULATOR_SSH_PBSBINPATH.key);
        return result;
    }

    public void setSimulatorSshPbsBinPath(String path) {
        this.setOption(Option.SIMULATOR_SSH_PBSBINPATH.key, path);
    }

    public String getSimulatorSshPbsQsubOptions() {
        String result = this.getOption(Option.SIMULATOR_SSH_PBSQSUBOPTIONS.key);
        return result;
    }

    public void setSimulatorSshPbsQsubOptions(String options) {
        this.setOption(Option.SIMULATOR_SSH_PBSQSUBOPTIONS.key, options);
    }

    public String getSimulatorSshJavaPath() {
        String result = this.getOption(Option.SIMULATOR_SSH_JAVAPATH.key);
        return result;
    }

    public void setSimulatorSshJavaPath(String path) {
        this.setOption(Option.SIMULATOR_SSH_JAVAPATH.key, path);
    }

    public int getSimulatorSshControlCheckInterval() {
        int result = this.getOptionAsInt(Option.SIMULATOR_SSH_CONTROLCHECKINTERVAL.key);
        return result;
    }

    public void setSimulatorSshControlCheckInterval(int interval) {
        this.setOption(Option.SIMULATOR_SSH_CONTROLCHECKINTERVAL.key, String.valueOf(interval));
    }

    public int getSimulatorSshMaxThreads() {
        int result = this.getOptionAsInt(Option.SIMULATOR_SSH_MAXTHREADS.key);
        return result;
    }

    public void setSimulatorSshMaxThreads(int max) {
        this.setOption(Option.SIMULATOR_SSH_MAXTHREADS.key, String.valueOf(max));
    }

    public File getSSHPrivateKeyFilePath() {
        File result = this.getOptionAsFile(Option.SSH_KEY_FILE.key);
        return result;
    }

    public void setSSHPrivateKeyFilePath(File sshFile) {
        this.setOption(Option.SSH_KEY_FILE.key, sshFile.getAbsolutePath());
    }

    public boolean isLaunchUI() {
        boolean result = this.getOptionAsBoolean(Option.LAUNCH_UI.key);
        return result;
    }

    public boolean isPerformMigration() {
        boolean result = this.getOptionAsBoolean(Option.PERFORM_MIGRATION.key);
        return result;
    }

    public boolean isPerformVcsUpdate() {
        boolean result = this.getOptionAsBoolean(Option.PERFORM_VCS_UPDATE.key);
        return result;
    }

    public boolean isPerformCron() {
        boolean result = this.getOptionAsBoolean(Option.PERFORM_CRON.key);
        return result;
    }

    public boolean isScriptAutoconfig() {
        boolean result = this.getOptionAsBoolean(Option.SIMULATION_SCRIPT_AUTOCONFIG.key);
        return result;
    }

    public void setSimulatorLauncher(String value) {
        this.setOption(Option.SIMULATOR_LAUNCHER.key, value);
    }

    public boolean isSimulationShowOnlyError() {
        Boolean result = this.getOptionAsBoolean(Option.SIMULATION_SHOW_ONLY_ERROR.key);
        return result;
    }

    public String getDefaultExportNames() {
        String result = this.getOption(Option.DEFAULT_EXPORT_NAMES.key);
        return result;
    }

    public void setDefaultExportNames(List<String> exportNames) {
        StringBuilder sb = new StringBuilder();
        for (String exportName : exportNames) {
            sb.append(SEP).append(exportName);
        }
        String value = sb.toString();
        if (value.length() > 0) {
            value = value.substring(1);
        }
        this.setOption(Option.DEFAULT_EXPORT_NAMES.key, value);
        this.saveForUser(new String[0]);
    }

    public List<String> getDefaultExportNamesAsList() {
        ArrayList<String> result = null;
        String exportNamesList = this.getDefaultExportNames();
        if (exportNamesList != null) {
            result = new ArrayList<String>();
            String[] exportNames = StringUtil.split((String)exportNamesList, (String)SEP);
            result.addAll(Arrays.asList(exportNames));
        }
        return result;
    }

    public String getDefaultMapFilename() {
        String result = this.getOption(Option.DEFAULT_MAP_FILENAME.key);
        return result;
    }

    public String getDefaultResultNames() {
        String result = this.getOption(Option.DEFAULT_RESULT_NAMES.key);
        return result;
    }

    public void setDefaultResultNames(List<String> resultNames) {
        StringBuilder sb = new StringBuilder();
        for (String resultName : resultNames) {
            sb.append(SEP).append(resultName);
        }
        String value = sb.toString();
        if (value.length() > 0) {
            value = value.substring(1);
        }
        this.setOption(Option.DEFAULT_RESULT_NAMES.key, value);
        this.saveForUser(new String[0]);
    }

    public List<String> getDefaultResultNamesAsList() {
        ArrayList<String> result = null;
        String resultNamesList = this.getDefaultResultNames();
        if (resultNamesList != null) {
            result = new ArrayList<String>();
            String[] resultNames = StringUtil.split((String)resultNamesList, (String)SEP);
            result.addAll(Arrays.asList(resultNames));
        }
        return result;
    }

    public String getDefaultTagValue() {
        String result = this.getOption(Option.DEFAULT_TAG_VALUE.key);
        return result;
    }

    public void setDefaultTagValues(Map<String, String> tagValues) {
        StringBuilder sb = new StringBuilder(" ");
        for (Map.Entry<String, String> entry : tagValues.entrySet()) {
            sb.append(SEP).append('\"').append(entry.getKey()).append("\":\"").append(entry.getValue()).append('\"');
        }
        String value = sb.toString().trim();
        this.setOption(Option.DEFAULT_TAG_VALUE.key, value.isEmpty() ? "" : value.substring(1));
        this.saveForUser(new String[0]);
    }

    public Map<String, String> getDefaultTagValueAsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        String tagValuesList = this.getDefaultTagValue();
        if (tagValuesList != null) {
            String[] tagValues;
            for (String tagValue : tagValues = StringUtil.split((String)tagValuesList, (String)SEP)) {
                String[] tagAndValue = StringUtil.split((String)tagValue, (String)":");
                String tag = tagAndValue[0].trim();
                tag = tag.substring(1, tag.length() - 1);
                String value = tagAndValue[1].trim();
                value = value.substring(1, value.length() - 1);
                result.put(tag, value);
            }
        }
        return result;
    }

    public String getJavadocURL() {
        String result = this.getOption(Option.JAVADOC_URL.key);
        return result;
    }

    public File getBackupDirectory() {
        File result = this.getOptionAsFile(Option.BACKUP_DIRECTORY.key);
        return result;
    }

    public long getStartingTime() {
        return this.startingTime;
    }

    public String getElapsedTimeAsString() {
        long diff = System.currentTimeMillis() - this.getStartingTime();
        String result = DurationFormatUtils.formatDuration((long)diff, (String)"s'.'S");
        return result;
    }

    public File getBackupSessionDirectory() {
        if (this.backupSessionDirectory == null) {
            long time = this.getStartingTime();
            String path = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date(time));
            this.backupSessionDirectory = new File(this.getBackupDirectory(), path);
            if (!this.backupSessionDirectory.exists()) {
                this.backupSessionDirectory.mkdirs();
            }
        }
        return this.backupSessionDirectory;
    }

    public ClassLoader getScriptClassLoader() {
        SimulationContext simContext = SimulationContext.get();
        ClassLoader result = simContext.getClassLoader();
        if (result == null) {
            File f = this.getCompileDirectory();
            try {
                URL[] cp = new URL[]{f.toURI().toURL()};
                ClassLoader parent = Thread.currentThread().getContextClassLoader();
                result = new URLClassLoader(cp, parent);
            }
            catch (MalformedURLException eee) {
                throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.load.classloader", (Object[])new Object[]{f, eee.getMessage()}), eee);
            }
        }
        return result;
    }

    public static enum Action {
        HELP(I18n.n_((String)"Show help", (Object[])new Object[0]), OtherAction.class.getName() + "#help", "-h", "--help"),
        VERSION(I18n.n_((String)"Show version", (Object[])new Object[0]), OtherAction.class.getName() + "#version", "-v", "--version"),
        IMPORT_EXPORT(I18n.n_((String)"", (Object[])new Object[0]), ImportAction.class.getName() + "#importExport", "--importExport"),
        IMPORT_RULE(I18n.n_((String)"", (Object[])new Object[0]), ImportAction.class.getName() + "#importRule", "--importRule"),
        IMPORT_SCRIPT(I18n.n_((String)"Import one java file script source", (Object[])new Object[0]), ImportAction.class.getName() + "#importScript", "--importScript"),
        IMPORT_SIMULATION_PLAN(I18n.n_((String)"", (Object[])new Object[0]), ImportAction.class.getName() + "#importSimulationPlan", "--importSimulationPlan"),
        IMPORT_SIMULATOR(I18n.n_((String)"", (Object[])new Object[0]), ImportAction.class.getName() + "#importSimulator", "--importSimulator"),
        IMPORT_FORMULA(I18n.n_((String)"", (Object[])new Object[0]), ImportAction.class.getName() + "#importFormula", "--importFormula"),
        IMPORT_REGION(I18n.n_((String)"", (Object[])new Object[0]), ImportAction.class.getName() + "#importRegion", "--importRegion"),
        IMPORT_REGION_AND_RENAME(I18n.n_((String)"", (Object[])new Object[0]), ImportAction.class.getName() + "#importRegionAndRename", "--importRegionAndRename"),
        IMPORT_SIMULATION(I18n.n_((String)"", (Object[])new Object[0]), ImportAction.class.getName() + "#importSimulation", "--importSimulation"),
        IMPORT_SCRIPT_MODULE(I18n.n_((String)"Import zipped file containing all scripts directory structure", (Object[])new Object[0]), ImportAction.class.getName() + "#importScriptModule", "--importScriptModule"),
        LIST_EXPORT(I18n.n_((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#listExport", "--listExport"),
        LIST_RULE(I18n.n_((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#listRule", "--listRule"),
        LIST_SCRIPT(I18n.n_((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#listScript", "--listScript"),
        LIST_SIMULATION_PLAN(I18n.n_((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#listSimulationPlan", "--listSimulationPlan"),
        LIST_SIMULATOR(I18n.n_((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#listSimulator", "--listSimulator"),
        LIST_FORMULA(I18n.n_((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#listFormula", "--listFormula"),
        LIST_REGION(I18n.n_((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#listRegion", "--listRegion"),
        LIST_SIMULATION(I18n.n_((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#listSimulation", "--listSimulation"),
        EXPORT_EXPORT(I18n.n_((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#exportExport", "--exportExport"),
        EXPORT_RULE(I18n.n_((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#exportRule", "--exportRule"),
        EXPORT_SCRIPT(I18n.n_((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#exportScript", "--exportScript"),
        EXPORT_SIMULATION_PLAN(I18n.n_((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#exportSimulationPlan", "--exportSimulationPlan"),
        EXPORT_SIMULATOR(I18n.n_((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#exportSimulator", "--exportSimulator"),
        EXPORT_FORMULA(I18n.n_((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#exportFormula", "--exportFormula"),
        EXPORT_REGION(I18n.n_((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#exportRegion", "--exportRegion"),
        EXPORT_SIMULATION(I18n.n_((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#exportSimulation", "--exportSimulation"),
        VCS_SSH_CREATE_KEY(I18n.n_((String)"", (Object[])new Object[0]), VCSAction.class.getName() + "#sshCreateKey", "--sshCreateKey"),
        VCS_UPDATE(I18n.n_((String)"", (Object[])new Object[0]), VCSAction.class.getName() + "#vcsUpdate", "--vcsUpdate"),
        VCS_ADD(I18n.n_((String)"", (Object[])new Object[0]), VCSAction.class.getName() + "#vcsAdd", "--vcsAdd"),
        VCS_REMOVE(I18n.n_((String)"", (Object[])new Object[0]), VCSAction.class.getName() + "#vcsRemove", "--vcsRemove"),
        VCS_COMMIT(I18n.n_((String)"", (Object[])new Object[0]), VCSAction.class.getName() + "#vcsCommit", "--vcsCommit"),
        SIMULATE_WITH_REGION(I18n.n_((String)"", (Object[])new Object[0]), SimulationAction.class.getName() + "#simulateWithRegion", "--simulateWithRegion"),
        SIMULATE_WITH_SIMULATION(I18n.n_((String)"", (Object[])new Object[0]), SimulationAction.class.getName() + "#simulateWithSimulation", "--simulateWithSimulation"),
        SIMULATE_WITH_SIMULATION_AND_SCRIPT(I18n.n_((String)"", (Object[])new Object[0]), SimulationAction.class.getName() + "#simulateWithSimulationAndScript", "--simulateWithSimulationAndScript"),
        SIMULATE_REMOTELLY(I18n.n_((String)"", (Object[])new Object[0]), SimulationAction.class.getName() + "#simulateRemotelly", "--simulateRemotelly"),
        SIMULATE_REMOTELLY_WITH_PRESCRIPT(I18n.n_((String)"", (Object[])new Object[0]), SimulationAction.class.getName() + "#simulateRemotellyWithPreScript", "--simulateRemotellyWithPreScript");

        protected String description;
        protected String action;
        protected String[] aliases;

        private Action(String description, String action, String ... aliases) {
            this.description = description;
            this.action = action;
            this.aliases = aliases;
        }

        public String getDescription() {
            return I18n._((String)this.description, (Object[])new Object[0]);
        }

        public String getAction() {
            return this.action;
        }

        public String[] getAliases() {
            return this.aliases;
        }
    }

    public static enum Option implements ApplicationConfig.OptionDef
    {
        CONFIG_FILE("config.file", I18n.n_((String)"isisfish.config.main.configFileName.description", (Object[])new Object[0]), CONFIG_FILENAME),
        ISIS_HOME_DIRECTORY("isis.home.directory", I18n.n_((String)"isisfish.config.main.compileDirectory.description", (Object[])new Object[0]), ApplicationConfig.getUserHome() + File.separator + "isis-fish-" + majorVersion.toString()),
        COMPILATION_DIRECTORY("compilation.directory", I18n.n_((String)"isisfish.config.main.compileDirectory.description", (Object[])new Object[0]), "${isis.home.directory}" + File.separator + "isis-build"),
        MONITORING_DIRECTORY("monitoring.directory", I18n.n_((String)"isisfish.config.main.monitoringDirectory.description", (Object[])new Object[0]), "${isis.home.directory}" + File.separator + "isis-monitoring"),
        JAVADOC_DIRECTORY("javadoc.directory", I18n.n_((String)"isisfish.config.main.javadocDirectory.description", (Object[])new Object[0]), "${isis.home.directory}" + File.separator + "isis-docs"),
        BACKUP_DIRECTORY("backup.directory", I18n.n_((String)"isisfish.config.main.defaultBackupDirectory.description", (Object[])new Object[0]), "${isis.home.directory}" + File.separator + "isis-backup"),
        DEFAULT_EXPORT_NAMES("default.export.names", I18n.n_((String)"isisfish.config.main.defaultExportNames.description", (Object[])new Object[0]), ""),
        DEFAULT_RESULT_NAMES("default.result.names", I18n.n_((String)"isisfish.config.main.defaultResultNames.description", (Object[])new Object[0]), ""),
        DEFAULT_MAP_FILENAME("default.map.filename", I18n.n_((String)"isisfish.config.main.defaultMapFile.description", (Object[])new Object[0]), "maps/vmap_area_thin.shp"),
        DEFAULT_TAG_VALUE("default.tagvalue", I18n.n_((String)"isisfish.config.main.defaultTagValue.description", (Object[])new Object[0]), ""),
        ENCODING("encoding", I18n.n_((String)"isisfish.config.main.encoding.description", (Object[])new Object[0]), "UTF-8"),
        JAVADOC_URL("javadoc.url", I18n.n_((String)"isisfish.config.main.javadocURL.description", (Object[])new Object[0]), "http://www.isis-fish.org/apidocs/"),
        SIMULATOR_CLASSFILE("simulator.classfile", I18n.n_((String)"isisfish.config.main.defaultSimulator.description", (Object[])new Object[0]), "DefaultSimulator.java"),
        SIMULATOR_LAUNCHER("simulation.launcher.3", I18n.n_((String)"isisfish.config.main.localSimulator.description", (Object[])new Object[0]), InProcessSimulatorLauncher.class.getName()),
        SIMULATOR_LAUNCHER2("simulation.launcher.1", I18n.n_((String)"isisfish.config.main.subSimulator.description", (Object[])new Object[0]), SubProcessSimulationLauncher.class.getName()),
        SIMULATOR_LAUNCHER_REMOTE("simulation.launcher.2", I18n.n_((String)"isisfish.config.main.remoteCaparmor.description", (Object[])new Object[0]), SSHSimulatorLauncher.class.getName()),
        SIMULATOR_SSH_SERVER("simulation.ssh.server", I18n.n_((String)"isisfish.config.main.simulation.ssh.server.description", (Object[])new Object[0]), "caparmor"),
        SIMULATOR_SSH_USER_NAME("simulation.ssh.username", I18n.n_((String)"isisfish.config.main.simulation.ssh.username.description", (Object[])new Object[0]), ""),
        SIMULATOR_SSH_USER_HOME("simulation.ssh.userhome", I18n.n_((String)"isisfish.config.main.simulation.ssh.userhome.description", (Object[])new Object[0]), ""),
        SIMULATOR_SSH_DATAPATH("simulation.ssh.datapath", I18n.n_((String)"isisfish.config.main.simulation.ssh.datapath.description", (Object[])new Object[0]), "isis-fish" + majorVersion.toString() + "/isis-database"),
        SIMULATOR_SSH_ISIS_HOME("simulation.ssh.isis.home", I18n.n_((String)"isisfish.config.main.simulation.ssh.isis.home.description", (Object[])new Object[0]), "/home3/caparmor/poussin/isis-fish-" + IsisConfig.getApiVersion()),
        SIMULATOR_SSH_TMPPATH("simulation.ssh.tmppath", I18n.n_((String)"isisfish.config.main.simulation.ssh.tmppath.description", (Object[])new Object[0]), "isis-tmp"),
        SIMULATOR_SSH_JAVAPATH("simulation.ssh.javapath", I18n.n_((String)"isisfish.config.main.simulation.ssh.javapath.description", (Object[])new Object[0]), "/home3/caparmor/poussin/jdk/bin/java"),
        SIMULATOR_SSH_PBSBINPATH("simulation.ssh.pbsbinpath", I18n.n_((String)"isisfish.config.main.simulation.ssh.pbsbinpath.description", (Object[])new Object[0]), "/usr/pbs/bin"),
        SIMULATOR_SSH_PBSQSUBOPTIONS("simulation.ssh.pbsqsuboptions", I18n.n_((String)"isisfish.config.main.simulation.ssh.pbsqsuboptions.description", (Object[])new Object[0]), "-m n"),
        SIMULATOR_SSH_CONTROLCHECKINTERVAL("simulation.ssh.control.check.interval", I18n.n_((String)"isisfish.config.main.simulation.ssh.control.check.interval.description", (Object[])new Object[0]), "120"),
        SIMULATOR_SSH_MAXTHREADS("simulation.ssh.max.threads", I18n.n_((String)"isisfish.config.main.simulation.ssh.max.threads.description", (Object[])new Object[0]), "1"),
        LOCALE("locale", I18n.n_((String)"isisfish.config.main.locale.description", (Object[])new Object[0]), "fr_FR"),
        SIMULATION_SHOW_ONLY_ERROR("simulationShowOnlyError", I18n.n_((String)"isisfish.config.main.simulationShowOnlyError.description", (Object[])new Object[0]), "false"),
        LAUNCH_UI("launch.ui", I18n.n_((String)"isisfish.config.main.launchUI.description", (Object[])new Object[0]), "true"),
        PERFORM_MIGRATION("perform.migration", I18n.n_((String)"isisfish.config.main.performmigration.description", (Object[])new Object[0]), "true"),
        PERFORM_VCS_UPDATE("perform.vcsupdate", I18n.n_((String)"isisfish.config.main.performvcsupdate.description", (Object[])new Object[0]), "true"),
        PERFORM_CRON("perform.cron", I18n.n_((String)"isisfish.config.main.performcron.description", (Object[])new Object[0]), "true"),
        SIMULATION_SCRIPT_AUTOCONFIG("script.autoconfig", I18n.n_((String)"isisfish.config.main.script.autoconfig.description", (Object[])new Object[0]), "true"),
        DATABASE_LOCK_MODE("database.lockmode", I18n.n_((String)"isisfish.config.database.lockmode.description", (Object[])new Object[0]), "file"),
        SSH_KEY_FILE("ssh.key.file", I18n.n_((String)"isisfish.config.ssh.key.file.description", (Object[])new Object[0]), ApplicationConfig.getUserHome() + File.separator + ".ssh" + File.separator + "isis_rsa"),
        DATABASE_DIRECTORY("database.directory", I18n.n_((String)"isisfish.config.vcs.localDatabasePath.description", (Object[])new Object[0]), "${isis.home.directory}" + File.separator + "isis-database"),
        VCS_TYPE("vcs.type", I18n.n_((String)"isisfish.config.vcs.type.description", (Object[])new Object[0]), "svn"),
        VCS_PROTOCOL("vcs.protocol", I18n.n_((String)"isisfish.config.vcs.protocol.description", (Object[])new Object[0]), "http"),
        VCS_USER_NAME("vcs.username", I18n.n_((String)"isisfish.config.vcs.userName.description", (Object[])new Object[0]), ""),
        VCS_USER_PASSWORD("vcs.password", I18n.n_((String)"isisfish.config.vcs.userPassword.description", (Object[])new Object[0]), ""),
        VCS_HOST_NAME("vcs.hostName", I18n.n_((String)"isisfish.config.vcs.hostName.description", (Object[])new Object[0]), "svn.forge.codelutin.com"),
        VCS_PATH("vcs.path", I18n.n_((String)"isisfish.config.vcs.remotePath.description", (Object[])new Object[0]), "/svn/isis-fish-data"),
        COMMUNITY_DATABASE_DIRECTORY("community.database.directory", I18n.n_((String)"isisfish.config.vcs.localCommunityDatabasePath.description", (Object[])new Object[0]), "${isis.home.directory}" + File.separator + "isis-community-database"),
        VCS_COMMUNITY_TYPE("vcs.community.type", I18n.n_((String)"isisfish.config.vcs.community.type.description", (Object[])new Object[0]), "svn"),
        VCS_COMMUNITY_PROTOCOL("vcs.community.protocole", I18n.n_((String)"isisfish.config.vcs.community.protocol.description", (Object[])new Object[0]), "http"),
        VCS_COMMUNITY_USER_NAME("vcs.community.username", I18n.n_((String)"isisfish.config.vcs.community.username.description", (Object[])new Object[0]), ""),
        VCS_COMMUNITY_PASSWORD("vcs.community.password", I18n.n_((String)"isisfish.config.vcs.community.password.description", (Object[])new Object[0]), ""),
        VCS_COMMUNITY_HOST_NAME("vcs.community.hostname", I18n.n_((String)"isisfish.config.vcs.community.hostname.description", (Object[])new Object[0]), "svn.forge.codelutin.com"),
        VCS_COMMUNITY_PATH("vcs.community.path", I18n.n_((String)"isisfish.config.vcs.community.remotepath.description", (Object[])new Object[0]), "/svn/isis-fish-community"),
        USER_NAME("user.name", I18n.n_((String)"isisfish.config.main.userName.description", (Object[])new Object[0]), System.getProperty("user.name")),
        SMTP_SERVER("smtpServer", I18n.n_((String)"isisfish.config.main.smtpServer.description", (Object[])new Object[0]), "smtp"),
        USER_MAIL("userMail", I18n.n_((String)"isisfish.config.main.userMail.description", (Object[])new Object[0]), Option.USER_NAME.key + "@" + Option.VCS_HOST_NAME.key);

        public String key;
        public String description;
        public String defaultValue;

        private Option(String key, String description, String defaultValue) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDescription() {
            return I18n._((String)this.description, (Object[])new Object[0]);
        }

        public String getKey() {
            return this.key;
        }

        public Class<?> getType() {
            return String.class;
        }

        public boolean isFinal() {
            return false;
        }

        public boolean isTransient() {
            return false;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setTransient(boolean isTransient) {
        }

        public void setFinal(boolean isFinal) {
        }
    }
}

