/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.vcs;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.vcs.VCS;
import fr.ifremer.isisfish.vcs.VCSNone;
import fr.ifremer.isisfish.vcs.VCSSVN;
import java.io.File;
import java.util.Properties;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class VCSFactory {
    private static Log log = LogFactory.getLog(VCSFactory.class);

    private VCSFactory() {
    }

    public static VCS createVCS(IsisConfig config) {
        Properties aliases = new Properties();
        aliases.setProperty("", VCSNone.class.getName());
        aliases.setProperty("none", VCSNone.class.getName());
        aliases.setProperty("svn", VCSSVN.class.getName());
        VCS result = null;
        String type = config.getOption("vcs.type");
        String classname = aliases.getProperty(type, type);
        File dataDir = config.getDatabaseDirectory();
        String protocol = config.getOption("vcs.protocol");
        String host = config.getOption("vcs.hostName");
        String path = config.getOption("vcs.path");
        File sshKeyFile = config.getSSHPrivateKeyFilePath();
        String login = config.getOption("vcs.username");
        String password = config.getOption("vcs.password");
        try {
            Class clazz = (Class)ConvertUtils.convert((String)classname, Class.class);
            result = (VCS)ConstructorUtils.invokeConstructor((Class)clazz, (Object[])new Object[]{dataDir, protocol, host, path, sshKeyFile, login, password});
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n._((String)"isisfish.vcs.factory.cantinstanciate", (Object[])new Object[]{type}), (Throwable)eee);
            }
            result = new VCSNone(dataDir, protocol, host, path, sshKeyFile, login, password);
        }
        return result;
    }
}

