/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Trace {
    private static Log log = LogFactory.getLog(Trace.class);
    public static final int STAT_CALL = 0;
    public static final int STAT_COMPUTATION = 1;
    public static final int STAT_CALL_NEST_METHOD = 2;
    public static final int STAT_TIME_MIN = 3;
    public static final int STAT_TIME_MAX = 4;
    public static final int STAT_TIME_TOTAL = 5;
    public static final int STAT_TIME_TOTAL_NEST_METHOD = 6;
    private static final int STACK_CALL_NEST_METHOD = 0;
    private static final int STACK_TIME_START = 1;
    private static final int STACK_TIME_START_NEST_METHOD = 2;
    protected String name = "";
    protected Map<String, long[]> statistics = new LinkedHashMap<String, long[]>();
    protected Stack<long[]> callStack = new Stack();

    public Trace(String name) {
        this.name = name;
    }

    public long[] getStatistics(Object e) {
        String key = String.valueOf(e);
        long[] result = this.statistics.get(key);
        if (result == null) {
            result = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L};
            this.statistics.put(key, result);
        }
        return result;
    }

    public void traceBefore() {
        long current = System.nanoTime();
        long[] stackItem = new long[]{0L, current, current};
        this.callStack.push(stackItem);
    }

    public void traceAfterCall(Object e) {
        this.traceAfter(e, false);
    }

    public void traceAfterComputation(Object e) {
        this.traceAfter(e, true);
    }

    protected void traceAfter(Object e, boolean computation) {
        long current = System.nanoTime();
        if (this.callStack.isEmpty()) {
            log.warn((Object)("Empty stack in after for " + e));
        } else {
            long[] stackItem = this.callStack.pop();
            long timeSpent = current - stackItem[1];
            long timeSpentNestMethod = current - stackItem[2];
            long[] stat = this.getStatistics(e);
            if (computation) {
                stat[1] = stat[1] + 1L;
            } else {
                stat[0] = stat[0] + 1L;
            }
            stat[2] = stat[2] + stackItem[0];
            stat[5] = stat[5] + timeSpent;
            stat[6] = stat[6] + timeSpentNestMethod;
            if (stat[3] > timeSpent) {
                stat[3] = timeSpent;
            }
            if (stat[4] < timeSpent) {
                stat[4] = timeSpent;
            }
            if (!this.callStack.isEmpty()) {
                long[] parent = this.callStack.peek();
                parent[0] = parent[0] + 1L;
                parent[1] = parent[1] + timeSpentNestMethod;
            }
        }
    }

    public String printStatisticAndClear() {
        long call = 0L;
        long computation = 0L;
        StringBuffer result = new StringBuffer();
        result.append("--- " + this.name + " Statistics ---\n");
        for (String e : this.statistics.keySet()) {
            long[] stat = this.getStatistics(e);
            if (stat[1] == 0L) {
                stat[1] = stat[0];
            }
            long meanTime = stat[5] / stat[1];
            call += stat[0];
            computation += stat[1];
            result.append(e + " call: " + stat[0] + " computation: " + stat[1] + "(" + 100L * stat[1] / stat[0] + "%)" + " min: " + DurationFormatUtils.formatDuration((long)(stat[3] / 1000000L), (String)"s'.'S") + " mean: " + DurationFormatUtils.formatDuration((long)(meanTime / 1000000L), (String)"s'.'S") + " max: " + DurationFormatUtils.formatDuration((long)(stat[4] / 1000000L), (String)"s'.'S") + " total: " + DurationFormatUtils.formatDuration((long)(stat[5] / 1000000L), (String)"s'.'S") + " call_nest: " + stat[2] + " total_with_nest: " + DurationFormatUtils.formatDuration((long)(stat[6] / 1000000L), (String)"s'.'S") + "\n");
        }
        result.append("--------------------\n");
        result.append("Total call: " + call + "\n");
        result.append("Total computation: " + computation + "\n");
        result.append("Cache usage: " + 100L * (call - computation) / (call + 1L) + "%" + "\n");
        result.append("--------------------\n");
        this.callStack.clear();
        this.statistics.clear();
        System.out.println(result.toString());
        return result.toString();
    }
}

