/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import fr.ifremer.isisfish.util.Doc;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class DocHelper {
    private static final Log log = LogFactory.getLog(DocHelper.class);

    public static Doc getClassDoc(Class<?> klazz) {
        return klazz == null ? null : klazz.getAnnotation(Doc.class);
    }

    public static Doc getClassDoc(Object value) {
        return value == null ? null : DocHelper.getClassDoc(value.getClass());
    }

    public static Doc getFieldDoc(Field f) {
        return f == null ? null : f.getAnnotation(Doc.class);
    }

    public static Doc getFieldDoc(Class<?> klazz, String fieldName) {
        Field f = null;
        try {
            f = klazz == null ? null : klazz.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            log.warn((Object)I18n._((String)"isisfish.error.not.found.field.class", (Object[])new Object[]{fieldName, klazz}));
        }
        return f == null ? null : f.getAnnotation(Doc.class);
    }

    public static String getValue(Doc doc) {
        return doc == null ? "" : doc.value();
    }

    public static String getAuthor(Doc doc) {
        return doc == null ? "" : doc.author();
    }

    public static String getDate(Doc doc) {
        return doc == null ? "" : doc.date();
    }

    public static String getVersion(Doc doc) {
        return doc == null ? "" : doc.version();
    }
}

