/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.widget.filter;

import fr.ifremer.isisfish.ui.widget.filter.Acceptor;
import fr.ifremer.isisfish.ui.widget.filter.CompositeFilterAcceptor;
import fr.ifremer.isisfish.ui.widget.filter.DateInterval;
import fr.ifremer.isisfish.ui.widget.filter.FilterAcceptor;
import fr.ifremer.isisfish.ui.widget.filter.ValueGetter;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcceptorFactory {
    private static Log log = LogFactory.getLog(AcceptorFactory.class);
    protected static Map<Integer, Acceptor<?>> cache;

    public static <M, T> FilterAcceptor<M, T> createCompositeFilterAcceptor(Class<T> klazz, ValueGetter<M, T> getter) {
        return new CompositeFilterAcceptor<M, T>(klazz, getter);
    }

    public static <T> Acceptor<T> getAcceptor(Class<T> klazz) {
        return AcceptorFactory.getCache().get(klazz.hashCode());
    }

    protected static synchronized Map<Integer, Acceptor<?>> getCache() {
        if (cache == null) {
            cache = new TreeMap();
            cache.put(String.class.hashCode(), new StringAcceptor());
            cache.put(Boolean.class.hashCode(), new BooleanAcceptor());
            cache.put(Short.class.hashCode(), new ShortAcceptor());
            cache.put(Integer.class.hashCode(), new IntegerAcceptor());
            cache.put(Long.class.hashCode(), new LongAcceptor());
            cache.put(Float.class.hashCode(), new ShortAcceptor());
            cache.put(Double.class.hashCode(), new DoubleAcceptor());
            cache.put(DateInterval.class.hashCode(), new DateIntervalAcceptor());
            for (Acceptor<?> acceptor : cache.values()) {
                log.debug((Object)("registred " + acceptor));
            }
        }
        return cache;
    }

    static abstract class AbstractAcceptor<T>
    implements Acceptor<T> {
        AbstractAcceptor() {
        }

        @Override
        public boolean accept(T meta, T value) {
            return meta != null && value != null;
        }

        @Override
        public boolean canUse(Object[] value) {
            return value != null && value.length > 0 && !"".equals(value[0]);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(super.toString());
            sb.append(" [klazz ").append(this.getKlazz().getSimpleName()).append(']');
            return sb.toString();
        }
    }

    static class DateIntervalAcceptor
    extends AbstractAcceptor<DateInterval> {
        DateIntervalAcceptor() {
        }

        @Override
        public Class<DateInterval> getKlazz() {
            return DateInterval.class;
        }

        @Override
        public boolean accept(DateInterval meta, DateInterval value) {
            return !(!super.accept(meta, value) || value.getD0() != -1L && value.getD0() > meta.getD0() || value.getD1() != -1L && value.getD1() < meta.getD1());
        }

        @Override
        public DateInterval extract(Object args) {
            if (args == null || !args.getClass().isArray() || ((Object[])args).length != 2) {
                return null;
            }
            Object o0 = ((Object[])args)[0];
            Object o1 = ((Object[])args)[1];
            return new DateInterval(o0 == null ? -1L : Long.valueOf(o0.toString()), o1 == null ? -1L : Long.valueOf(o1.toString()));
        }

        @Override
        public boolean canUse(Object[] value) {
            return super.canUse(value) || value != null && value.length > 1 && !"".equals(value[1]);
        }
    }

    static class BooleanAcceptor
    extends AbstractAcceptor<Boolean> {
        BooleanAcceptor() {
        }

        @Override
        public Class<Boolean> getKlazz() {
            return Boolean.class;
        }

        @Override
        public boolean accept(Boolean meta, Boolean value) {
            return super.accept(meta, value) && meta.equals(value);
        }

        @Override
        public Boolean extract(Object args) {
            return Boolean.valueOf(args == null ? "false" : args.toString());
        }
    }

    static class StringAcceptor
    extends AbstractAcceptor<String> {
        StringAcceptor() {
        }

        @Override
        public Class<String> getKlazz() {
            return String.class;
        }

        @Override
        public boolean accept(String meta, String value) {
            if (!super.accept(meta, value)) {
                return false;
            }
            if (!value.endsWith(".*") || value.endsWith("$")) {
                value = value + ".*";
            }
            Pattern pattern = Pattern.compile(value, 2);
            return pattern.matcher(meta).matches();
        }

        @Override
        public String extract(Object args) {
            return args == null ? "" : args.toString();
        }
    }

    public static class DoubleAcceptor
    extends AbstractAcceptor<Double> {
        @Override
        public Class<Double> getKlazz() {
            return Double.class;
        }

        @Override
        public boolean accept(Double meta, Double value) {
            return super.accept(meta, value) && meta.equals(value);
        }

        @Override
        public Double extract(Object args) {
            return args == null ? 0.0 : Double.valueOf(args.toString());
        }
    }

    public static class FloatAcceptor
    extends AbstractAcceptor<Float> {
        @Override
        public Class<Float> getKlazz() {
            return Float.class;
        }

        @Override
        public boolean accept(Float meta, Float value) {
            return super.accept(meta, value) && meta.equals(value);
        }

        @Override
        public Float extract(Object args) {
            return Float.valueOf(args == null ? 0.0f : Float.valueOf(args.toString()).floatValue());
        }
    }

    public static class LongAcceptor
    extends AbstractAcceptor<Long> {
        @Override
        public Class<Long> getKlazz() {
            return Long.class;
        }

        @Override
        public boolean accept(Long meta, Long value) {
            return super.accept(meta, value) && meta.equals(value);
        }

        @Override
        public Long extract(Object args) {
            return args == null ? 0L : Long.valueOf(args.toString());
        }
    }

    static class IntegerAcceptor
    extends AbstractAcceptor<Integer> {
        IntegerAcceptor() {
        }

        @Override
        public Class<Integer> getKlazz() {
            return Integer.class;
        }

        @Override
        public boolean accept(Integer meta, Integer value) {
            return super.accept(meta, value) && meta.equals(value);
        }

        @Override
        public Integer extract(Object args) {
            return args == null ? 0 : Integer.valueOf(args.toString());
        }
    }

    static class ShortAcceptor
    extends AbstractAcceptor<Short> {
        ShortAcceptor() {
        }

        @Override
        public Class<Short> getKlazz() {
            return Short.class;
        }

        @Override
        public boolean accept(Short meta, Short value) {
            return super.accept(meta, value) && meta.equals(value);
        }

        @Override
        public Short extract(Object args) {
            return args == null ? (short)0 : Short.valueOf(args.toString());
        }
    }
}

